/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.basesetting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class BodySysMangeDisableValidator
extends AbstractTmcBizOppValidator {
    private static List<BillInProgressStatus> BILL_IN_PROGRESS_STATUS_LIST;
    private static final Log logger;

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        ExtendedDataEntity extendedDataEntity = extendedDataEntities[0];
        DynamicObject dyObj = extendedDataEntity.getDataEntity();
        for (ExtendedDataEntity dataEntity : extendedDataEntities) {
            this.canDisable(dataEntity);
        }
    }

    private void canDisable(ExtendedDataEntity dataEntity) {
        DynamicObject entity = dataEntity.getDataEntity();
        for (BillInProgressStatus billInProgressStatus : BILL_IN_PROGRESS_STATUS_LIST) {
            String entityNumber = billInProgressStatus.getEntityNumber();
            QFilter qFilter = billInProgressStatus.getInProgressFilter().and(billInProgressStatus.getBodySysFilterField(), "=", entity.getPkValue());
            logger.info("\u8fc7\u6ee4\u6761\u4ef6\uff1a{}", (Object)qFilter);
            DynamicObject[] dynamicObjects = TmcDataServiceHelper.load((String)entityNumber, (String)billInProgressStatus.getSelectFields(), (QFilter[])new QFilter[]{qFilter});
            if (dynamicObjects == null || dynamicObjects.length <= 0) continue;
            String errorMessage = billInProgressStatus.getDealFunction().apply(dynamicObjects[0]);
            this.addErrorMessage(dataEntity, errorMessage);
            return;
        }
    }

    private static QFilter defaultQFilter() {
        HashSet<String> status = new HashSet<String>(8);
        status.add("A");
        status.add("B");
        return new QFilter("billstatus", "in", status);
    }

    static {
        logger = LogFactory.getLog(BodySysMangeDisableValidator.class);
        ArrayList<BillInProgressStatus> billInProgressStatusList = new ArrayList<BillInProgressStatus>(4);
        Set<String> planStatus = Collections.singleton("A");
        QFilter reportInProgress = new QFilter("planstatus", "in", planStatus);
        billInProgressStatusList.add(new BillInProgressStatus("fpm_report", reportInProgress, "bodysys", String.join((CharSequence)",", "id", "reportperiod"), dynamicObject -> {
            DynamicObject reportPeriod = dynamicObject.getDynamicObject("reportperiod");
            DynamicObject reportType = reportPeriod.getDynamicObject("reporttype");
            return "\u3010" + reportPeriod.getString("name") + "\u3011" + "\u3010" + reportType.getString("name") + "\u3011" + ResManager.loadKDString((String)"\u7533\u62a5\u5df2\u5f00\u542f\uff0c\u6682\u4e0d\u53ef\u7981\u7528\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\u3002", (String)"BodySysMangeDisableValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]);
        }));
        billInProgressStatusList.add(new BillInProgressStatus("fpm_reportplan_adjust", "bodysys", String.join((CharSequence)",", "id", "reportperiod"), dynamicObject -> {
            DynamicObject reportPeriod = dynamicObject.getDynamicObject("reportperiod");
            DynamicObject reportType = reportPeriod.getDynamicObject("reporttype");
            return "\u3010" + reportPeriod.getString("name") + "\u3011" + "\u3010" + reportType.getString("name") + "\u3011" + ResManager.loadKDString((String)"\u5df2\u5f00\u542f\u8c03\u6574\uff0c\u6682\u4e0d\u53ef\u8fdb\u884c\u7981\u7528\u5904\u7406\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c", (String)"BodySysMangeDisableValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]);
        }));
        BILL_IN_PROGRESS_STATUS_LIST = Collections.unmodifiableList(billInProgressStatusList);
    }

    static class BillInProgressStatus {
        private String entityNumber;
        private QFilter inProgressFilter;
        private String selectFields;
        private String bodySysFilterField;
        private Function<DynamicObject, String> dealFunction;

        public BillInProgressStatus() {
        }

        public BillInProgressStatus(String entityNumber, String bodySysFilterField, Function<DynamicObject, String> dealFunction) {
            this(entityNumber, BodySysMangeDisableValidator.defaultQFilter(), bodySysFilterField, dealFunction);
        }

        public BillInProgressStatus(String entityNumber, String bodySysFilterField, String selectFields, Function<DynamicObject, String> dealFunction) {
            this(entityNumber, BodySysMangeDisableValidator.defaultQFilter(), bodySysFilterField, selectFields, dealFunction);
        }

        public BillInProgressStatus(String entityNumber, QFilter inProgressFilter, String bodySysFilterField, Function<DynamicObject, String> dealFunction) {
            this(entityNumber, inProgressFilter, bodySysFilterField, "id", dealFunction);
        }

        public BillInProgressStatus(String entityNumber, QFilter inProgressFilter, String bodySysFilterField, String selectFields, Function<DynamicObject, String> dealFunction) {
            this.entityNumber = entityNumber;
            this.inProgressFilter = inProgressFilter;
            this.bodySysFilterField = bodySysFilterField;
            this.selectFields = selectFields;
            this.dealFunction = dealFunction;
        }

        public String getEntityNumber() {
            return this.entityNumber;
        }

        public void setEntityNumber(String entityNumber) {
            this.entityNumber = entityNumber;
        }

        public QFilter getInProgressFilter() {
            return this.inProgressFilter.copy();
        }

        public void setInProgressFilter(QFilter inProgressFilter) {
            this.inProgressFilter = inProgressFilter;
        }

        public String getSelectFields() {
            return this.selectFields;
        }

        public void setSelectFields(String selectFields) {
            this.selectFields = selectFields;
        }

        public Function<DynamicObject, String> getDealFunction() {
            return this.dealFunction;
        }

        public void setDealFunction(Function<DynamicObject, String> dealFunction) {
            this.dealFunction = dealFunction;
        }

        public String getBodySysFilterField() {
            return this.bodySysFilterField;
        }

        public void setBodySysFilterField(String bodySysFilterField) {
            this.bodySysFilterField = bodySysFilterField;
        }
    }
}

