/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.basesetting;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import org.apache.commons.collections.CollectionUtils;

public class ControlWayConfigEnableValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        Object[] objects = Arrays.stream(dataEntity).map(extendedDataEntity -> extendedDataEntity.getDataEntity().getPkValue()).toArray();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])objects, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_controlwayconfig"));
        Map<Object, DynamicObject> dynamicObjectMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
        List bodySysIds = Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getDynamicObject("bodysys").getPkValue()).collect(Collectors.toList());
        List reportOrgIdList = Arrays.stream(dynamicObjects).flatMap(dynamicObject -> dynamicObject.getDynamicObjectCollection("entryentity").stream()).map(dynamicObject -> dynamicObject.get("entry_reportorg.id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("entryentity.entry_reportorg", "in", reportOrgIdList).or(new QFilter("entryentity.entry_reportorg", "=", null));
        QFilter enableBodySysFilter = new QFilter("bodysys", "in", bodySysIds).and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] dynamicObjectExist = BusinessDataServiceHelper.load((String)"fpm_controlwayconfig", (String)"id", (QFilter[])new QFilter[]{qFilter, enableBodySysFilter});
        dynamicObjectExist = BusinessDataServiceHelper.load((Object[])Arrays.stream(dynamicObjectExist).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_controlwayconfig"));
        Set<ExistObj> existObjSet = Arrays.stream(dynamicObjectExist).flatMap(dynamicObject -> ExistObj.getExistObj(dynamicObject).stream()).collect(Collectors.toSet());
        for (ExtendedDataEntity extendedDataEntity2 : dataEntity) {
            this.checkBeforeEnable(extendedDataEntity2, dynamicObjectMap, existObjSet);
        }
    }

    private void checkBeforeEnable(ExtendedDataEntity extendedDataEntity, Map<Object, DynamicObject> dynamicObjectMap, Set<ExistObj> existObjSet) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        Object pkValue = dataEntity.getPkValue();
        DynamicObject dynamicObject = dynamicObjectMap.get(pkValue);
        boolean aBoolean = dynamicObject.getBoolean("enable");
        if (aBoolean) {
            return;
        }
        Set<ExistObj> needJudgeSet = ExistObj.getExistObj(dynamicObject);
        ExistObj exist = ExistObj.exist(existObjSet, needJudgeSet);
        if (Objects.isNull(exist)) {
            existObjSet.addAll(needJudgeSet);
            return;
        }
        this.addErrorMessage(extendedDataEntity, exist.getNotifyMessage(dataEntity.getString("number")));
    }

    public boolean isAddBillNoForContent() {
        return false;
    }

    static class ExistObj {
        private Object reportTyeId;
        private Object reportOrgId;
        private String reportTypeNumber;
        private String reportOrgName;
        private String configNumber;
        private Object bodySysId;
        private String bodySysNumber;

        public Object getReportTyeId() {
            return this.reportTyeId;
        }

        public void setReportTyeId(Object reportTyeId) {
            this.reportTyeId = reportTyeId;
        }

        public Object getReportOrgId() {
            return this.reportOrgId;
        }

        public void setReportOrgId(Object reportOrgId) {
            this.reportOrgId = reportOrgId;
        }

        public String getReportTypeNumber() {
            return this.reportTypeNumber;
        }

        public void setReportTypeNumber(String reportTypeNumber) {
            this.reportTypeNumber = reportTypeNumber;
        }

        public String getReportOrgName() {
            return this.reportOrgName;
        }

        public void setReportOrgName(String reportOrgName) {
            this.reportOrgName = reportOrgName;
        }

        public String getConfigNumber() {
            return this.configNumber;
        }

        public void setConfigNumber(String configNumber) {
            this.configNumber = configNumber;
        }

        public Object getBodySysId() {
            return this.bodySysId;
        }

        public void setBodySysId(Object bodySysId) {
            this.bodySysId = bodySysId;
        }

        public String getBodySysNumber() {
            return this.bodySysNumber;
        }

        public void setBodySysNumber(String bodySysNumber) {
            this.bodySysNumber = bodySysNumber;
        }

        public ExistObj(Object reportTyeId, String reportTypeNumber, String configNumber, Object bodySysId, String bodySysNumber) {
            this.reportTyeId = reportTyeId;
            this.reportTypeNumber = reportTypeNumber;
            this.configNumber = configNumber;
            this.bodySysId = bodySysId;
            this.bodySysNumber = bodySysNumber;
        }

        public ExistObj(Object reportTyeId, Object reportOrgId, String reportTypeNumber, String reportOrgName, String configNumber, Object bodySysId, String bodySysNumber) {
            this.reportTyeId = reportTyeId;
            this.reportOrgId = reportOrgId;
            this.reportTypeNumber = reportTypeNumber;
            this.reportOrgName = reportOrgName;
            this.configNumber = configNumber;
            this.bodySysId = bodySysId;
            this.bodySysNumber = bodySysNumber;
        }

        public ExistObj() {
        }

        public String getNotifyMessage(String currentNumber) {
            if (Objects.isNull(this.reportOrgId)) {
                return String.format(ResManager.loadKDString((String)"\u63a7\u5236\u7b56\u7565\u201c%1$s\u201d\u542f\u7528\u5931\u8d25\uff0c\u56e0\u53d7\u63a7\u7f16\u62a5\u7c7b\u578b\u201c%2$s\u201d\u5df2\u5b58\u5728\u201c\u53ef\u7528\u201d\u72b6\u6001\u4e0b\u7684\u63a7\u5236\u7b56\u7565\u201c%3$s\u201d\u3002\u8bf7\u5148\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\u3002", (String)"ControlWayConfigEnableValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), currentNumber, this.reportTypeNumber, this.configNumber);
            }
            String errorMessage = String.format(ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\uff0c\u5df2\u5b58\u5728\u201c\u53ef\u7528\u201d\u72b6\u6001\u4e0b\u7684\u63a7\u5236\u7b56\u7565\u201c%1$s\u201d\u3002\uff08\u9002\u7528\u7f16\u62a5\u4e3b\u4f53\uff1a%2$s\uff0c\u53d7\u63a7\u7f16\u62a5\u7c7b\u578b\uff1a%3$s\uff09", (String)"ControlWayConfigEnableValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]), currentNumber, this.reportOrgName, this.reportTypeNumber, this.configNumber);
            return errorMessage;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExistObj existObj = (ExistObj)o;
            return Objects.equals(this.reportTyeId, existObj.reportTyeId) && Objects.equals(this.reportOrgId, existObj.reportOrgId) && Objects.equals(this.bodySysId, existObj.bodySysId);
        }

        public int hashCode() {
            return Objects.hash(this.reportTyeId, this.reportOrgId, this.bodySysId);
        }

        public static Set<ExistObj> getExistObj(DynamicObject dynamicObject) {
            DynamicObject bodySys = dynamicObject.getDynamicObject("bodysys");
            List reportTypeList = dynamicObject.getDynamicObjectCollection("reporttype").stream().map(dy -> dy.getDynamicObject("fbasedataid")).collect(Collectors.toList());
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
            String configNumber = dynamicObject.getString("number");
            Object bodySysId = bodySys.getPkValue();
            String bodySysNumber = bodySys.getString("number");
            int size = reportTypeList.size();
            if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
                HashSet<ExistObj> existObjSet = new HashSet<ExistObj>(size);
                for (DynamicObject reportType : reportTypeList) {
                    existObjSet.add(new ExistObj(reportType.getPkValue(), reportType.getString("number"), configNumber, bodySysId, bodySysNumber));
                }
                return existObjSet;
            }
            HashSet<ExistObj> existObjSet = new HashSet<ExistObj>(size * dynamicObjectCollection.size());
            for (DynamicObject entryDynamicObject : dynamicObjectCollection) {
                DynamicObject reportOrg = entryDynamicObject.getDynamicObject("entry_reportorg");
                Object reportOrgId = reportOrg.getPkValue();
                String reportOrgName = reportOrg.getString("name");
                for (DynamicObject report : reportTypeList) {
                    existObjSet.add(new ExistObj(report.getPkValue(), reportOrgId, report.getString("name"), reportOrgName, configNumber, bodySysId, bodySysNumber));
                }
            }
            return existObjSet;
        }

        public static ExistObj exist(Set<ExistObj> existObjSet, Set<ExistObj> needJudgeSet) {
            for (ExistObj existObj : needJudgeSet) {
                ExistObj orElse = existObjSet.stream().filter(existObj::equals).findFirst().orElse(null);
                if (!Objects.nonNull(orElse)) continue;
                return orElse;
            }
            return null;
        }
    }
}

