/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.basesetting;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.common.enums.ControlIntensityEnum;

public class ControlWayConfigSaveValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            if (!this.checkBeforeSave(extendedDataEntity)) break;
        }
    }

    private boolean checkBeforeSave(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        DynamicObjectCollection objectCollection = dataEntity.getDynamicObjectCollection("treeentryentity");
        boolean flag = true;
        for (DynamicObject dynamicObject : objectCollection) {
            if (this.checkEntry(extendedDataEntity, dynamicObject)) continue;
            flag = false;
        }
        return flag;
    }

    private boolean checkEntry(ExtendedDataEntity extendedDataEntity, DynamicObject dynamicObject) {
        String controlIntensity = dynamicObject.getString("entry_controlintensity");
        if ((StringUtils.equals((CharSequence)controlIntensity, (CharSequence)ControlIntensityEnum.RIGID.getValue()) || StringUtils.equals((CharSequence)controlIntensity, (CharSequence)ControlIntensityEnum.SOFT.getValue())) && EmptyUtil.isEmpty((Object)dynamicObject.get("entry_controlcoefficient"))) {
            String errorMessage = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u63a7\u5236\u5f3a\u5ea6\u4e3a\u201c%1$s\u201d\u6216\u201c%2$s\u201d\u63a7\u5236\u7cfb\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ControlWayConfigSaveValidator_7", (String)"tmc-fpm-business", (Object[])new Object[0]), ControlIntensityEnum.RIGID.getName().getDescription(), ControlIntensityEnum.SOFT.getName().getDescription());
            this.addErrorMessage(extendedDataEntity, errorMessage);
            return false;
        }
        if (dynamicObject.getBoolean("entry_detailcontrol") && EmptyUtil.isEmpty((Object)dynamicObject.get("entry_detailcontrolbasis"))) {
            String errorMessage = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u6309\u660e\u7ec6\u9879\u63a7\u5236\u5f00\u542f\u540e\uff0c\u660e\u7ec6\u9879\u63a7\u5236\u4f9d\u636e\u4e0d\u80fd\u4e3a\u7a7a", (String)"ControlWayConfigSaveValidator_8", (String)"tmc-fpm-business", (Object[])new Object[0]);
            this.addErrorMessage(extendedDataEntity, errorMessage);
            return false;
        }
        return true;
    }

    public boolean isAddBillNoForContent() {
        return false;
    }
}

