/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.basesetting;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.common.helper.DetailPlanFieldsHelper;

public class DetailPlanFieldSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("id");
        selector.add("bodysys");
        selector.add("isshow");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        Set idSet = Arrays.stream(extendedDataEntities).map(e -> e.getDataEntity().getPkValue()).collect(Collectors.toSet());
        DynamicObject[] dbDataArr = TmcDataServiceHelper.load((Object[])idSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_detailplanfields"));
        Map dbDataMap = null;
        if (dbDataArr.length > 0) {
            dbDataMap = Arrays.stream(dbDataArr).collect(Collectors.toMap(e -> e.getPkValue(), Function.identity()));
        }
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            Boolean validator;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            Object pkValue = dataEntity.getPkValue();
            Object modelPkValue = dataEntity.getDynamicObject("bodysys").getPkValue();
            if (dbDataMap == null) continue;
            DynamicObject dbData = (DynamicObject)dbDataMap.get(pkValue);
            boolean dbIsShow = dbData.getBoolean("isshow");
            boolean currIsShow = dataEntity.getBoolean("isshow");
            if (currIsShow || !dbIsShow || (validator = DetailPlanFieldsHelper.showChangeValidator((Object)modelPkValue, (Object)pkValue)).booleanValue()) continue;
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6b64\u5b57\u6bb5\u5df2\u88ab\u6a21\u677f\u5f15\u7528\u5e76\u5df2\u88ab\u9009\u4e2d\uff0c\u4e0d\u53ef\u8bbe\u7f6e\u4e3a\u4e0d\u53ef\u89c1\u3002", (String)"DetailPlanFieldSaveValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }
}

