/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.basesetting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.common.property.ExecuteTimeProp;

public class ExecuteTimeSaveValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            if (!this.checkBeforeSave(extendedDataEntity)) break;
        }
    }

    public boolean isAddBillNoForContent() {
        return false;
    }

    private boolean checkBeforeSave(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        Map<String, String> operatorValueNameMap = ExecuteTimeProp.OPERATOR_NAME_KEY_MAP.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        HashMap<Object, ExecuteTimeEntity> executeTimeEntityMap = new HashMap<Object, ExecuteTimeEntity>(8);
        for (Map.Entry entry : ExecuteTimeProp.ENTRY_ENTTIY_BUSINESS_BILL_OPERATION_CODE_MAP.entrySet()) {
            Set operatorCodeSet = (Set)entry.getValue();
            String entryEntityName = (String)entry.getKey();
            DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection(entryEntityName);
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                DynamicObject businessBill = dynamicObject.getDynamicObject((String)ExecuteTimeProp.ENTRY_ENTITY_BUSINESS_BILL_MAP.get(entryEntityName));
                String businessBillName = businessBill.getString("name");
                Object pkValue = businessBill.getPkValue();
                ExecuteTimeEntity executeTimeEntity = (ExecuteTimeEntity)executeTimeEntityMap.get(pkValue);
                if (Objects.isNull(executeTimeEntity)) {
                    executeTimeEntity = new ExecuteTimeEntity(businessBillName, pkValue);
                    executeTimeEntityMap.put(pkValue, executeTimeEntity);
                }
                for (String keyField : operatorCodeSet) {
                    String[] split;
                    String operatorNameField = operatorValueNameMap.get(keyField);
                    String keyString = dynamicObject.getString(keyField);
                    if (EmptyUtil.isEmpty((String)keyString)) continue;
                    for (String key : split = keyString.split(",")) {
                        executeTimeEntity.getOperatorValueList().add(new OperatorValue(operatorNameField, key, ExecuteTimeSaveValidator.getDependsOn(operatorNameField), ExecuteTimeSaveValidator.getMutuallyExclusives(operatorNameField)));
                    }
                }
                if (StringUtils.equals((CharSequence)entryEntityName, (CharSequence)"entryentity_actual") && EmptyUtil.isNoEmpty((String)dynamicObject.getString("entry_releaseacltimecode")) && EmptyUtil.isEmpty((String)dynamicObject.getString("entry_factbackamountfield"))) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u3010%1$s\u3011\u5df2\u914d\u7f6e\u201c\u5b9e\u5360\u8fd4\u8fd8\uff08\u91ca\u653e\uff09\u65f6\u673a\u201d\u64cd\u4f5c\uff0c\u6545\u201c\u5b9e\u5360\u8fd4\u8fd8\uff08\u91ca\u653e\uff09\u91d1\u989d\u53d6\u503c\u201d\u503c\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExecuteTimeSaveValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), businessBillName));
                    return false;
                }
                if (!StringUtils.equals((CharSequence)entryEntityName, (CharSequence)"entryentity_actual") || !EmptyUtil.isNoEmpty((String)dynamicObject.getString("entry_aclupdatetimecode")) || !EmptyUtil.isEmpty((String)dynamicObject.getString("entry_aclupdateamtfield"))) continue;
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u3010%1$s\u3011\u5df2\u914d\u7f6e\u201c\u5b9e\u5360\u66f4\u65b0\u65f6\u673a\u201d\u64cd\u4f5c\uff0c\u6545\u201c\u5b9e\u5360\u66f4\u65b0\u7684\u91d1\u989d\u53d6\u503c\u5b57\u6bb5\u201d\u503c\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExecuteTimeSaveValidator_13", (String)"tmc-fpm-business", (Object[])new Object[0]), businessBillName));
                return false;
            }
        }
        for (ExecuteTimeEntity executeTimeEntity : executeTimeEntityMap.values()) {
            String errorMessage = executeTimeEntity.getErrorMessage();
            if (Objects.isNull(errorMessage)) continue;
            this.addErrorMessage(extendedDataEntity, errorMessage);
            return false;
        }
        return true;
    }

    private static String[] getDependsOn(String keyName) {
        switch (keyName) {
            case "entry_unpreempted": {
                return new String[]{"entry_preemptedtime"};
            }
            case "entry_release": {
                return new String[]{"entry_preemptedtime"};
            }
            case "entry_unacldeduction": 
            case "entry_releaseacltime": 
            case "entry_aclupdatetime": {
                return new String[]{"entry_acldeduction"};
            }
        }
        return null;
    }

    private static String[] getMutuallyExclusives(String keyName) {
        switch (keyName) {
            case "entry_releaseacltime": {
                return new String[]{"entry_aclupdatetime"};
            }
            case "entry_aclupdatetime": {
                return new String[]{"entry_releaseacltime"};
            }
        }
        return null;
    }

    static class OperatorValue {
        private String name;
        private String value;
        private String[] dependsOn;
        private String[] mutuallyExclusives;

        public OperatorValue(String name, String value, String[] dependsOn, String[] mutuallyExclusives) {
            this.name = name;
            this.value = value;
            this.dependsOn = dependsOn;
            this.mutuallyExclusives = mutuallyExclusives;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String[] getDependsOn() {
            return this.dependsOn;
        }

        public void setDependsOn(String[] dependsOn) {
            this.dependsOn = dependsOn;
        }

        public String[] getMutuallyExclusives() {
            return this.mutuallyExclusives;
        }

        public void setMutuallyExclusives(String[] mutuallyExclusives) {
            this.mutuallyExclusives = mutuallyExclusives;
        }
    }

    static class ExecuteTimeEntity {
        private String businessBillName;
        private Object businessBIllId;
        private List<OperatorValue> operatorValueList;
        private static Map<String, String> MAP = new HashMap<String, String>();
        private static Map<String, String> DEPENDS_ON_MESSAGE = new HashMap<String, String>();
        private static final String FIELD_SEPARATOR = "\u3001";

        public ExecuteTimeEntity(String businessBillName, Object businessBIllId) {
            this.businessBillName = businessBillName;
            this.businessBIllId = businessBIllId;
            this.operatorValueList = new ArrayList<OperatorValue>(16);
        }

        public String getBusinessBillName() {
            return this.businessBillName;
        }

        public void setBusinessBillName(String businessBillName) {
            this.businessBillName = businessBillName;
        }

        public Object getBusinessBIllId() {
            return this.businessBIllId;
        }

        public void setBusinessBIllId(Object businessBIllId) {
            this.businessBIllId = businessBIllId;
        }

        public List<OperatorValue> getOperatorValueList() {
            return this.operatorValueList;
        }

        public void setOperatorValueList(List<OperatorValue> operatorValueList) {
            this.operatorValueList = operatorValueList;
        }

        public String getErrorMessage() {
            Map<String, List<OperatorValue>> operatorValueMap = this.operatorValueList.stream().collect(Collectors.groupingBy(OperatorValue::getName));
            for (OperatorValue operatorValue : this.operatorValueList) {
                String[] dependsOn = operatorValue.getDependsOn();
                if (Objects.isNull(dependsOn)) continue;
                for (String key : dependsOn) {
                    List<OperatorValue> operatorValues = operatorValueMap.get(key);
                    if (!EmptyUtil.isEmpty(operatorValues)) continue;
                    return String.format(DEPENDS_ON_MESSAGE.get(operatorValue.getName()), this.getBusinessBillName());
                }
                String[] mutuallyExclusives = operatorValue.getMutuallyExclusives();
                if (Objects.isNull(mutuallyExclusives)) continue;
                for (String key : mutuallyExclusives) {
                    List<OperatorValue> operatorValues = operatorValueMap.get(key);
                    if (!EmptyUtil.isNoEmpty(operatorValues)) continue;
                    String errorMsg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u540c\u4e00\u4e1a\u52a1\u5355\u636e\u4e0b\u4e0d\u5141\u8bb8\u540c\u65f6\u914d\u7f6e\u201c\u5b9e\u5360\u8fd4\u8fd8\uff08\u91ca\u653e\uff09\u65f6\u673a\u201d\u3001\u201c\u5b9e\u5360\u66f4\u65b0\u65f6\u673a\u201d\uff0c\u8bf7\u68c0\u67e5\u3010%1$s\u3011\u7684\u914d\u7f6e\u3002", (String)"ExecuteTimeSaveValidator_14", (String)"tmc-fpm-business", (Object[])new Object[0]);
                    return String.format(errorMsg, this.getBusinessBillName());
                }
            }
            Map<String, List<OperatorValue>> groupMap = this.operatorValueList.stream().collect(Collectors.groupingBy(OperatorValue::getValue));
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, List<OperatorValue>> entry : groupMap.entrySet()) {
                List<OperatorValue> entryValue = entry.getValue();
                if (entryValue.size() <= 1) continue;
                for (OperatorValue operatorValue : entryValue) {
                    sb.append(MAP.get(operatorValue.getName())).append(FIELD_SEPARATOR);
                }
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
                return String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u4e1a\u52a1\u5355\u636e\u5404\u9879\u6267\u884c\u65f6\u673a\u4e0d\u53ef\u4ee5\u7ed1\u5b9a\u5728\u540c\u4e00\u4e2a\u64cd\u4f5c\u4e0a\u3002\u8bf7\u68c0\u67e5\u4e1a\u52a1\u5355\u636e\u201c%1$s\u201d\u5bf9\u5e94\u7684\u201c%2$s\u201d\u65f6\u673a\u64cd\u4f5c\u9009\u9879\u3002", (String)"ExecuteTimeSaveValidator_11", (String)"tmc-fpm-business", (Object[])new Object[0]), this.businessBillName, sb);
            }
            return null;
        }

        static {
            MAP.put("entry_preemptedtime", ResManager.loadKDString((String)"\u9884\u5360\u65f6\u673a", (String)"ExecuteTimeSaveValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
            MAP.put("entry_unpreempted", ResManager.loadKDString((String)"\u53d6\u6d88\u9884\u5360\u65f6\u673a", (String)"ExecuteTimeSaveValidator_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
            MAP.put("entry_release", ResManager.loadKDString((String)"\u91ca\u653e\u9884\u5360\u65f6\u673a", (String)"ExecuteTimeSaveValidator_3", (String)"tmc-fpm-business", (Object[])new Object[0]));
            MAP.put("entry_acldeduction", ResManager.loadKDString((String)"\u5b9e\u5360\uff08\u5b9e\u9645\u6263\u51cf\uff09\u65f6\u673a", (String)"ExecuteTimeSaveValidator_4", (String)"tmc-fpm-business", (Object[])new Object[0]));
            MAP.put("entry_unacldeduction", ResManager.loadKDString((String)"\u53d6\u6d88\u5b9e\u5360\uff08\u5b9e\u9645\u6263\u51cf\uff09\u65f6\u673a", (String)"ExecuteTimeSaveValidator_5", (String)"tmc-fpm-business", (Object[])new Object[0]));
            MAP.put("entry_releaseacltime", ResManager.loadKDString((String)"\u91ca\u653e\u5b9e\u5360\u8fd4\u8fd8\uff08\u91ca\u653e\uff09\u65f6\u673a", (String)"ExecuteTimeSaveValidator_6", (String)"tmc-fpm-business", (Object[])new Object[0]));
            MAP.put("entry_aclupdatetime", ResManager.loadKDString((String)"\u5b9e\u5360\u66f4\u65b0\u65f6\u673a", (String)"ExecuteTimeSaveValidator_12", (String)"tmc-fpm-business", (Object[])new Object[0]));
            DEPENDS_ON_MESSAGE.put("entry_unpreempted", ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u4e1a\u52a1\u5355\u636e\u201c%s\u201d\u7684\u9884\u5360\u8bb0\u5f55\u64cd\u4f5c\u65f6\u673a\u3002", (String)"ExecuteTimeSaveValidator_7", (String)"tmc-fpm-business", (Object[])new Object[0]));
            DEPENDS_ON_MESSAGE.put("entry_release", ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u5148\u8bbe\u7f6e\u4e1a\u52a1\u5355\u636e\u201c%1$s\u201d\u7684\u9884\u5360\u8bb0\u5f55\u64cd\u4f5c\u65f6\u673a\u3002", (String)"ExecuteTimeSaveValidator_8", (String)"tmc-fpm-business", (Object[])new Object[0]));
            DEPENDS_ON_MESSAGE.put("entry_unacldeduction", ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u8bf7\u5148\u8bbe\u7f6e\u4e1a\u52a1\u5355\u636e\u201c%1$s\u201d\u7684\u5b9e\u5360\uff08\u5b9e\u9645\u6263\u51cf\uff09\u64cd\u4f5c\u65f6\u673a\u3002", (String)"ExecuteTimeSaveValidator_9", (String)"tmc-fpm-business", (Object[])new Object[0]));
            DEPENDS_ON_MESSAGE.put("entry_releaseacltime", ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u8bf7\u5148\u8bbe\u7f6e\u4e1a\u52a1\u5355\u636e\u201c%1$s\u201d\u7684\u5b9e\u5360\uff08\u5b9e\u9645\u6263\u51cf\uff09\u64cd\u4f5c\u65f6\u673a\u3002", (String)"ExecuteTimeSaveValidator_10", (String)"tmc-fpm-business", (Object[])new Object[0]));
            DEPENDS_ON_MESSAGE.put("entry_aclupdatetime", ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u8bf7\u5148\u8bbe\u7f6e\u4e1a\u52a1\u5355\u636e\u201c%1$s\u201d\u7684\u5b9e\u5360\uff08\u5b9e\u9645\u6263\u51cf\uff09\u64cd\u4f5c\u65f6\u673a\u3002", (String)"ExecuteTimeSaveValidator_10", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
    }
}

