/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.basesetting;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.common.enums.BillStatusEnum;
import kd.tmc.fpm.common.enums.ReportPlanStatusEnum;

public class InternalCancelRuleEnableValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bodysys");
        selector.add("number");
        selector.add("name");
        selector.add("apply_reportorg");
        selector.add("applyreporttype");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        QFilter qFilter;
        Set systemIdSet = Arrays.stream(dataEntity).map(ExtendedDataEntity::getDataEntity).map(dy -> dy.getDynamicObject("bodysys")).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        String selectFields = String.join((CharSequence)",", "id", "billno", "reportorg", "reporttype", "reportperiod");
        Object[] load = TmcDataServiceHelper.load((String)"fpm_reportplansum", (String)selectFields, (QFilter[])new QFilter[]{qFilter = new QFilter("bodysys", "in", systemIdSet).and("planstatus", "!=", (Object)ReportPlanStatusEnum.EFFECTIVE.getValue()).and("billstatus", "!=", (Object)BillStatusEnum.STAGE.getCode())});
        if (EmptyUtil.isEmpty((Object[])load)) {
            return;
        }
        Map<Object, Map<Object, List<DynamicObject>>> sumPlanMap = Arrays.stream(load).collect(Collectors.groupingBy(dy -> dy.getDynamicObject("reporttype").getPkValue(), Collectors.groupingBy(dy -> dy.getDynamicObject("reportorg").getPkValue())));
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            Object orgId;
            List dynamicObjects;
            Object next;
            Map sumOrgMap;
            DynamicObject innerCancelRule = extendedDataEntity.getDataEntity();
            Set reportTypes = innerCancelRule.getDynamicObjectCollection("applyreporttype").stream().map(dy -> dy.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
            HashSet<Object> sumReportTypes = new HashSet<Object>(sumPlanMap.keySet());
            sumReportTypes.retainAll(reportTypes);
            if (EmptyUtil.isEmpty(sumReportTypes) || CollectionUtils.isEmpty(sumOrgMap = sumPlanMap.getOrDefault(next = sumReportTypes.iterator().next(), Collections.emptyMap()))) continue;
            DynamicObjectCollection dynamicObjectCollection = innerCancelRule.getDynamicObjectCollection("apply_entryentity");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)dynamicObjectCollection)) {
                List value = (List)sumOrgMap.entrySet().iterator().next().getValue();
                DynamicObject sumPlan = (DynamicObject)value.get(0);
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u542f\u7528\u64cd\u4f5c\u5931\u8d25\uff0c\u6240\u9009\u62b5\u6d88\u89c4\u5219\u3010%1$s %2$s\u3011\u9002\u7528\u6c47\u603b\u7f16\u62a5\u4e3b\u4f53\u3010%3$s\u3011\u3010%4$s\u3011\u4e0b\u5b58\u5728\u975e\u6682\u5b58\u72b6\u6001\u4e14\u672a\u751f\u6548\u7684\u6c47\u603b\u5904\u7406\u5355\uff0c\u6682\u4e0d\u5141\u8bb8\u8fdb\u884c\u542f\u7528\u64cd\u4f5c\u3002", (String)"InternalCancelRuleEnableValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), innerCancelRule.getString("number"), innerCancelRule.getString("name"), sumPlan.getDynamicObject("reportorg").getString("name"), sumPlan.getDynamicObject("reportperiod").getString("name")));
                continue;
            }
            Set applyOrgIdSet = dynamicObjectCollection.stream().map(dy -> dy.getDynamicObject("apply_reportorg")).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
            HashSet sumReportOrgIds = new HashSet(sumOrgMap.keySet());
            sumReportOrgIds.retainAll(applyOrgIdSet);
            if (EmptyUtil.isEmpty(sumReportOrgIds) || EmptyUtil.isEmpty((Collection)(dynamicObjects = (List)sumOrgMap.get(orgId = sumReportOrgIds.iterator().next())))) continue;
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(0);
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u62b5\u6d88\u89c4\u5219\u201c%1$s\u201d\uff08%2$s\uff09\u9002\u7528\u6c47\u603b\u7f16\u62a5\u4e3b\u4f53\u201c%3$s\u201d\u3001\u201c%4$s\u201d\u4e0b\u5b58\u5728\u975e\u6682\u5b58\u72b6\u6001\u7684\u6c47\u603b\u5904\u7406\u5355\u3002\u8bf7\u5148\u5904\u7406\u6682\u5b58\u7684\u6c47\u603b\u5904\u7406\u5355\u540e\uff0c\u518d\u8fdb\u884c\u542f\u7528\u64cd\u4f5c\u3002", (String)"InternalCancelRuleEnableValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]), innerCancelRule.getString("number"), innerCancelRule.getString("name"), dynamicObject.getDynamicObject("reportorg").getString("name"), dynamicObject.getDynamicObject("reportperiod").getString("name")));
        }
    }
}

