/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.basesetting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.validate.basesetting.SubjectCancelConfigConfirmValidator;
import kd.tmc.fpm.common.bean.SubjectCancelConfig;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.FlowEnum;

public class InternalCancelRuleSaveValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        Set bodySysIds = Arrays.stream(dataEntity).map(ExtendedDataEntity::getDataEntity).map(dy -> dy.getDynamicObject("bodysys").getPkValue()).collect(Collectors.toSet());
        Object[] load = TmcDataServiceHelper.load((String)"fpm_internalcancelrule", (String)"id", (QFilter[])new QFilter[]{new QFilter("bodysys", "in", bodySysIds)});
        HashSet<UniqueEntity> uniqueEntitySet = new HashSet<UniqueEntity>(128);
        if (!EmptyUtil.isEmpty((Object[])load)) {
            for (Object dynamicObject : load = TmcDataServiceHelper.load((Object[])Arrays.stream(load).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_internalcancelrule"))) {
                uniqueEntitySet.add(UniqueEntity.getUniqueEntity((DynamicObject)dynamicObject));
            }
        }
        String selectFields = String.join((CharSequence)",", "sumreporttype", "bodysys", String.join((CharSequence)".", "treeentryentity", "sum_reportorg"), String.join((CharSequence)".", "treeentryentity", "sum_issumaudit"));
        DynamicObject[] summaryConfigs = TmcDataServiceHelper.load((String)"fpm_summaryconfig", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("bodysys", "in", bodySysIds)});
        Map<Object, List<DynamicObject>> summaryConfigMap = Arrays.stream(summaryConfigs).collect(Collectors.groupingBy(dy -> dy.getDynamicObject("bodysys").getPkValue()));
        block1: for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject entity = extendedDataEntity.getDataEntity();
            Object bodySysId = entity.getDynamicObject("bodysys").getPkValue();
            List<DynamicObject> dynamicObjects = summaryConfigMap.get(bodySysId);
            if (!this.hasAllParents(extendedDataEntity, dynamicObjects)) continue;
            DynamicObjectCollection applyEntity = entity.getDynamicObjectCollection("apply_entryentity");
            DynamicObjectCollection dynamicObjectCollection = entity.getDynamicObjectCollection("entryentity");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)dynamicObjectCollection)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u672a\u914d\u7f6e\u89c4\u5219\u9879\u3002", (String)"InternalCancelRuleSaveValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
                continue;
            }
            Map<Long, SubjectCancelConfigConfirmValidator.SubjectInfo> subjectInfoToMap = Collections.emptyMap();
            ArrayList<ConfigEntity> configEntityList = new ArrayList<ConfigEntity>(dynamicObjectCollection.size());
            for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
                String inConfig = dynamicObject.getString("entry_inconfig");
                String outConfig = dynamicObject.getString("entry_outconfig");
                String ruleName = dynamicObject.getString("entry_rulename");
                if (EmptyUtil.isEmpty((String)inConfig)) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u89c4\u5219\u9879\u201c%1$s\u201d\u672a\u914d\u7f6e\u6d41\u5165\u65b9\u8ba1\u5212\u79d1\u76ee\u3002", (String)"InternalCancelRuleSaveValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]), ruleName));
                    continue block1;
                }
                if (EmptyUtil.isEmpty((String)outConfig)) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u89c4\u5219\u9879\u201c%1$s\u201d\u672a\u914d\u7f6e\u6d41\u51fa\u65b9\u8ba1\u5212\u79d1\u76ee\u3002", (String)"InternalCancelRuleSaveValidator_2", (String)"tmc-fpm-business", (Object[])new Object[0]), ruleName));
                    continue block1;
                }
                boolean isAccurateMode = dynamicObject.getBoolean("entry_accurate_match_mode");
                String schemeStr = dynamicObject.getString("entry_offset_scheme");
                if (isAccurateMode && EmptyUtil.isEmpty((String)schemeStr)) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u89c4\u5219\u9879\u201c%1$s\u201d\u672a\u914d\u7f6e\u7cbe\u786e\u62b5\u6d88\u5339\u914d\u65b9\u6848\u3002", (String)"InternalCancelRuleSaveValidator_3", (String)"tmc-fpm-business", (Object[])new Object[0]), ruleName));
                    continue block1;
                }
                String inConfigReal = dynamicObject.getString("entry_inconfigreal_tag");
                SubjectCancelConfig subjectCancelConfig = (SubjectCancelConfig)SerializationUtils.fromJsonString((String)inConfigReal, SubjectCancelConfig.class);
                List subjectList = subjectCancelConfig.getSubjectList();
                String outConfigReal = dynamicObject.getString("entry_outconfigreal_tag");
                SubjectCancelConfig outSubjectCancelConfig = (SubjectCancelConfig)SerializationUtils.fromJsonString((String)outConfigReal, SubjectCancelConfig.class);
                List outSubjectList = outSubjectCancelConfig.getSubjectList();
                ConfigEntity configEntity = new ConfigEntity(ruleName, subjectList.stream().map(SubjectCancelConfig.Subject::getId).collect(Collectors.toSet()), outSubjectList.stream().map(SubjectCancelConfig.Subject::getId).collect(Collectors.toSet()));
                for (ConfigEntity ce : configEntityList) {
                    ConfigEntity intersect = configEntity.intersect(ce);
                    if (!CollectionUtils.isEmpty(intersect.getSubjectIds())) {
                        this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u672a\u901a\u8fc7\u89c4\u5219\u9879\u552f\u4e00\u6027\u6821\u9a8c\uff0c\u8bf7\u68c0\u67e5\u89c4\u5219\u9879\u201c%1$s\u201d\u3001\u201c%2$s\u201d\u7684\u6d41\u5165\u65b9\u8ba1\u5212\u79d1\u76ee\u8bbe\u7f6e\u3002", (String)"InternalCancelRuleSaveValidator_4", (String)"tmc-fpm-business", (Object[])new Object[0]), intersect.getName(), intersect.getSecondName()));
                        continue block1;
                    }
                    if (!CollectionUtils.isEmpty(intersect.getOutSubjectIds())) {
                        this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u672a\u901a\u8fc7\u89c4\u5219\u9879\u552f\u4e00\u6027\u6821\u9a8c\uff0c\u8bf7\u68c0\u67e5\u89c4\u5219\u9879\u201c%1$s\u201d\u3001\u201c%2$s\u201d\u7684\u6d41\u51fa\u65b9\u8ba1\u5212\u79d1\u76ee\u8bbe\u7f6e\u3002", (String)"InternalCancelRuleSaveValidator_5", (String)"tmc-fpm-business", (Object[])new Object[0]), intersect.getName(), intersect.getSecondName()));
                        continue block1;
                    }
                    Optional<String> errorMsgOpt = this.hasSameParentNotSameLevel(subjectInfoToMap = CollectionUtils.isEmpty(subjectInfoToMap) ? this.getSubjectInfoToMapSupplier((Long)bodySysId).get() : subjectInfoToMap, FlowEnum.INFLOW, configEntity, ce);
                    if (errorMsgOpt.isPresent()) {
                        this.addErrorMessage(extendedDataEntity, errorMsgOpt.get());
                        continue block1;
                    }
                    errorMsgOpt = this.hasSameParentNotSameLevel(subjectInfoToMap, FlowEnum.OUTFLOW, configEntity, ce);
                    if (!errorMsgOpt.isPresent()) continue;
                    this.addErrorMessage(extendedDataEntity, errorMsgOpt.get());
                    continue block1;
                }
                configEntityList.add(configEntity);
            }
            List collect = applyEntity.stream().map(dy -> dy.getDynamicObject("apply_reportorg")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            HashSet idSet = new HashSet(collect);
            if (collect.size() != idSet.size()) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u9002\u7528\u6c47\u603b\u7f16\u62a5\u4e3b\u4f53\u4e0d\u53ef\u91cd\u590d\u3002", (String)"InternalCancelRuleSaveValidator_6", (String)"tmc-fpm-business", (Object[])new Object[0]));
                continue;
            }
            UniqueEntity uniqueEntity = UniqueEntity.getUniqueEntity(entity);
            for (UniqueEntity ue : uniqueEntitySet) {
                Optional<String> descriptionOpt = uniqueEntity.getDescription(ue, subjectInfoToMap = CollectionUtils.isEmpty(subjectInfoToMap) ? this.getSubjectInfoToMapSupplier((Long)bodySysId).get() : subjectInfoToMap);
                if (!descriptionOpt.isPresent()) continue;
                this.addErrorMessage(extendedDataEntity, descriptionOpt.get());
                continue block1;
            }
        }
    }

    public boolean isAddBillNoForContent() {
        return true;
    }

    private boolean hasAllParents(ExtendedDataEntity extendedDataEntity, List<DynamicObject> summaryConfigs) {
        if (EmptyUtil.isEmpty(summaryConfigs)) {
            return true;
        }
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        DynamicObjectCollection applyEntity = dataEntity.getDynamicObjectCollection("apply_entryentity");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)applyEntity)) {
            return true;
        }
        Map applyOrgMap = applyEntity.stream().map(dy -> dy.getDynamicObject("apply_reportorg")).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity(), (a, b) -> a));
        Set<Object> selectOrgIds = applyOrgMap.keySet();
        DynamicObjectCollection reportTypes = dataEntity.getDynamicObjectCollection("applyreporttype");
        Set reportTypeIds = reportTypes.stream().map(dy -> dy.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        List<DynamicObject> selectedSummaryConfigs = summaryConfigs.stream().filter(dy -> {
            DynamicObjectCollection sumReportTypes = dy.getDynamicObjectCollection("sumreporttype");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)sumReportTypes)) {
                return true;
            }
            for (DynamicObject sumReportType : sumReportTypes) {
                Object sumReportTypeId = sumReportType.getDynamicObject("fbasedataid").getPkValue();
                if (!reportTypeIds.contains(sumReportTypeId)) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        HashMap<Object, DynamicObject> needSelectMap = new HashMap<Object, DynamicObject>(16);
        for (Object orgId : selectOrgIds) {
            this.getAllParents(orgId, needSelectMap, selectedSummaryConfigs);
            HashSet needSelectParents = new HashSet(needSelectMap.keySet());
            needSelectParents.removeAll(selectOrgIds);
            if (EmptyUtil.isEmpty(needSelectParents)) continue;
            String needSelectOrgName = needSelectMap.entrySet().stream().filter(entry -> needSelectParents.contains(entry.getKey())).map(Map.Entry::getValue).map(dy -> dy.getString("name")).collect(Collectors.joining(","));
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7f16\u62a5\u4e3b\u4f53\u3010%1$s\u3011\u7684\u4e0a\u7ea7\u6c47\u603b\u7f16\u62a5\u4e3b\u4f53\u3010%2$s\u3011\u672a\u52fe\u9009\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"InternalCancelRuleSaveValidator_7", (String)"tmc-fpm-business", (Object[])new Object[0]), ((DynamicObject)applyOrgMap.get(orgId)).getString("name"), needSelectOrgName));
            return false;
        }
        return true;
    }

    private void getAllParents(Object orgId, Map<Object, DynamicObject> needSelectSet, List<DynamicObject> selectedSummaryConfigs) {
        block0: for (DynamicObject sumConfig : selectedSummaryConfigs) {
            Object needSelect = orgId;
            DynamicObjectCollection treeEntry = sumConfig.getDynamicObjectCollection("treeentryentity");
            for (int i = treeEntry.size() - 1; i >= 0; --i) {
                DynamicObject sumConfigEntry = (DynamicObject)treeEntry.get(i);
                DynamicObject sumOrg = sumConfigEntry.getDynamicObject("sum_reportorg");
                DynamicObject parent = sumOrg.getDynamicObject("parent");
                if (!Objects.equals(sumOrg.getPkValue(), needSelect)) continue;
                if (!sumConfigEntry.getBoolean("sum_issumaudit")) {
                    if (EmptyUtil.isEmpty((DynamicObject)parent)) continue block0;
                    needSelect = parent.getPkValue();
                    continue;
                }
                if (!Objects.equals(needSelect, orgId)) {
                    needSelectSet.put(needSelect, sumOrg);
                }
                if (EmptyUtil.isEmpty((DynamicObject)parent)) continue block0;
                needSelect = parent.getPkValue();
            }
        }
    }

    private Supplier<Map<Long, SubjectCancelConfigConfirmValidator.SubjectInfo>> getSubjectInfoToMapSupplier(Long bodySysId) {
        return () -> {
            String subjectParentIdProp = String.join((CharSequence)".", "parent", "id");
            String subjectSelectFields = String.join((CharSequence)",", "id", "level", "name", subjectParentIdProp);
            DynamicObject[] subjectMemberArr = TmcDataServiceHelper.load((String)"fpm_member", (String)subjectSelectFields, (QFilter[])new QFilter("bodysystem", "=", (Object)bodySysId).and("dimtype", "=", (Object)DimsionEnums.SUBJECT.getNumber()).toArray());
            return SubjectCancelConfigConfirmValidator.SubjectInfo.getSubjectInfoToMap(subjectMemberArr);
        };
    }

    private Optional<String> hasSameParentNotSameLevel(Map<Long, SubjectCancelConfigConfirmValidator.SubjectInfo> subjectInfoToMap, FlowEnum flowEnum, ConfigEntity configEntity, ConfigEntity otherConfigEntity) {
        Set<Long> subjectIds = flowEnum == FlowEnum.INFLOW ? configEntity.getSubjectIds() : configEntity.getOutSubjectIds();
        Set<Long> otherConfigSubjectIds = flowEnum == FlowEnum.INFLOW ? otherConfigEntity.getSubjectIds() : otherConfigEntity.getOutSubjectIds();
        for (Long subjectId : subjectIds) {
            SubjectCancelConfigConfirmValidator.SubjectInfo subjectInfo = subjectInfoToMap.get(subjectId);
            List<SubjectCancelConfigConfirmValidator.SubjectInfo> otherConfigSubjectInfoList = otherConfigSubjectIds.stream().map(subjectInfoToMap::get).collect(Collectors.toList());
            SubjectCancelConfigConfirmValidator.SubjectInfo result = subjectInfo.hasSameParentNotSameLevel(otherConfigSubjectInfoList);
            if (!EmptyUtil.isNoEmpty((Object)result)) continue;
            return Optional.of(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u89c4\u5219\u9879\u4e0a\u4e0b\u7ea7\u8ba1\u5212\u79d1\u76ee\u4e0d\u80fd\u540c\u65f6\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u89c4\u5219\u9879\u3010%1$s\u3011\u3001\u3010%2$s\u3011\u7684\u3010%3$s\u3011\u65b9\u8ba1\u5212\u79d1\u76ee\u3010%4$s\u3011\u3010%5$s\u3011\u8bbe\u7f6e\u3002", (String)"InternalCancelRuleSaveValidator_10", (String)"tmc-fpm-business", (Object[])new Object[0]), configEntity.getName(), otherConfigEntity.getName(), flowEnum.getName(), subjectInfo.getName(), result.getName()));
        }
        return Optional.empty();
    }

    static class UniqueEntity {
        private Long id;
        private Long systemId;
        private String name;
        private String duplicateName;
        private Map<Long, String> reportTypeMap;
        private Map<Long, String> applyCurrencyMap;
        private Map<Long, String> otherOptionalDimMap;
        private Map<Long, String> otherOptionalDim1Map;
        private Map<Long, String> otherOptionalDim2Map;
        private Map<Long, String> subjectMap;
        private Map<Long, String> reportOrgMap;
        private Set<Long> reportTypeSet;
        private Set<Long> applyCurrencySet;
        private Set<Long> subjectSet;
        private Set<Long> reportOrgSet;
        private boolean defaultRule;

        UniqueEntity() {
        }

        public Long getSystemId() {
            return this.systemId;
        }

        public void setSystemId(Long systemId) {
            this.systemId = systemId;
        }

        public Map<Long, String> getReportTypeMap() {
            return this.reportTypeMap;
        }

        public void setReportTypeMap(Map<Long, String> reportTypeMap) {
            this.reportTypeMap = reportTypeMap;
        }

        public Map<Long, String> getApplyCurrencyMap() {
            return this.applyCurrencyMap;
        }

        public void setApplyCurrencyMap(Map<Long, String> applyCurrencyMap) {
            this.applyCurrencyMap = applyCurrencyMap;
        }

        public Map<Long, String> getOtherOptionalDimMap() {
            return this.otherOptionalDimMap;
        }

        public void setOtherOptionalDimMap(Map<Long, String> otherOptionalDimMap) {
            this.otherOptionalDimMap = otherOptionalDimMap;
        }

        public Map<Long, String> getOtherOptionalDim1Map() {
            return this.otherOptionalDim1Map;
        }

        public void setOtherOptionalDim1Map(Map<Long, String> otherOptionalDim1Map) {
            this.otherOptionalDim1Map = otherOptionalDim1Map;
        }

        public Map<Long, String> getOtherOptionalDim2Map() {
            return this.otherOptionalDim2Map;
        }

        public void setOtherOptionalDim2Map(Map<Long, String> otherOptionalDim2Map) {
            this.otherOptionalDim2Map = otherOptionalDim2Map;
        }

        public Map<Long, String> getSubjectMap() {
            return this.subjectMap;
        }

        public void setSubjectMap(Map<Long, String> subjectMap) {
            this.subjectMap = subjectMap;
        }

        public Map<Long, String> getReportOrgMap() {
            return this.reportOrgMap;
        }

        public void setReportOrgMap(Map<Long, String> reportOrgMap) {
            this.reportOrgMap = reportOrgMap;
        }

        public Set<Long> getReportTypeSet() {
            return this.reportTypeSet;
        }

        public Set<Long> getApplyCurrencySet() {
            return this.applyCurrencySet;
        }

        public Set<Long> getSubjectSet() {
            return this.subjectSet;
        }

        public Set<Long> getReportOrgSet() {
            return this.reportOrgSet;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDuplicateName() {
            return this.duplicateName;
        }

        public void setDuplicateName(String duplicateName) {
            this.duplicateName = duplicateName;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public boolean isDefaultRule() {
            return this.defaultRule;
        }

        public void setDefaultRule(boolean defaultRule) {
            this.defaultRule = defaultRule;
        }

        public boolean hasIntersect(UniqueEntity uniqueEntity) {
            if (EmptyUtil.isNoEmpty((Long)this.id) && Objects.equals(this.id, uniqueEntity.getId())) {
                return false;
            }
            if (!Objects.equals(this.systemId, uniqueEntity.getSystemId())) {
                return false;
            }
            this.reportTypeSet = new HashSet<Long>(this.reportTypeMap.keySet());
            this.reportTypeSet.retainAll(uniqueEntity.getReportTypeMap().keySet());
            if (CollectionUtils.isEmpty(this.reportTypeSet)) {
                return false;
            }
            if (!this.applyCurrencyMap.isEmpty() && !uniqueEntity.getApplyCurrencyMap().isEmpty()) {
                this.applyCurrencySet = new HashSet<Long>(this.applyCurrencyMap.keySet());
                this.applyCurrencySet.retainAll(uniqueEntity.getApplyCurrencyMap().keySet());
                if (CollectionUtils.isEmpty(this.applyCurrencySet)) {
                    return false;
                }
            }
            HashSet optionDimMemberSet = new HashSet(2, 1.0f);
            Optional.of(this.otherOptionalDimMap).ifPresent(dimMap -> optionDimMemberSet.addAll(dimMap.keySet()));
            Optional.of(this.otherOptionalDim1Map).ifPresent(dimMap -> optionDimMemberSet.addAll(dimMap.keySet()));
            Optional.of(this.otherOptionalDim2Map).ifPresent(dimMap -> optionDimMemberSet.addAll(dimMap.keySet()));
            HashSet uniqueEntityOptionDimMemberSet = new HashSet(2, 1.0f);
            Optional.of(uniqueEntity.getOtherOptionalDimMap()).ifPresent(dimMap -> uniqueEntityOptionDimMemberSet.addAll(dimMap.keySet()));
            Optional.of(uniqueEntity.getOtherOptionalDim1Map()).ifPresent(dimMap -> uniqueEntityOptionDimMemberSet.addAll(dimMap.keySet()));
            Optional.of(uniqueEntity.getOtherOptionalDim2Map()).ifPresent(dimMap -> uniqueEntityOptionDimMemberSet.addAll(dimMap.keySet()));
            if (!optionDimMemberSet.isEmpty() && !uniqueEntityOptionDimMemberSet.isEmpty()) {
                optionDimMemberSet.retainAll(uniqueEntityOptionDimMemberSet);
                if (CollectionUtils.isEmpty(optionDimMemberSet)) {
                    return false;
                }
            }
            this.subjectSet = new HashSet<Long>(this.subjectMap.keySet());
            this.subjectSet.retainAll(uniqueEntity.getSubjectMap().keySet());
            if (CollectionUtils.isEmpty(this.subjectSet)) {
                return false;
            }
            if (this.isDefaultRule()) {
                if (!uniqueEntity.isDefaultRule()) {
                    return false;
                }
            } else {
                this.reportOrgSet = new HashSet<Long>(this.reportOrgMap.keySet());
                this.reportOrgSet.retainAll(uniqueEntity.getReportOrgMap().keySet());
                if (CollectionUtils.isEmpty(this.reportOrgSet)) {
                    return false;
                }
            }
            this.duplicateName = uniqueEntity.getName();
            return true;
        }

        public Optional<String> getDescription(UniqueEntity uniqueEntity, Map<Long, SubjectCancelConfigConfirmValidator.SubjectInfo> subjectInfoToMap) {
            if (this.hasIntersect(uniqueEntity)) {
                String des = this.reportTypeSet.stream().map(this.reportTypeMap::get).collect(Collectors.joining("/"));
                return Optional.of(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u672a\u901a\u8fc7\u62b5\u6d88\u89c4\u5219\u552f\u4e00\u6027\u6821\u9a8c\uff0c\u4e0e\u62b5\u6d88\u89c4\u5219\u3010%1$s\u3011\u7684\u914d\u7f6e\u9879\u51fa\u73b0\u91cd\u590d\uff0c\u7f16\u62a5\u7c7b\u578b\u3010%2$s\u3011\u7684\u62b5\u6d88\u8ba1\u5212\u79d1\u76ee\u8303\u56f4\u4e0d\u5141\u8bb8\u51fa\u73b0\u91cd\u590d\u3002", (String)"InternalCancelRuleSaveValidator_9", (String)"tmc-fpm-business", (Object[])new Object[0]), this.duplicateName, des));
            }
            if (this.hasSameParentNotSameLevel(subjectInfoToMap, uniqueEntity)) {
                String des = this.reportTypeMap.keySet().stream().filter(uniqueEntity.getReportTypeMap()::containsKey).map(this.reportTypeMap::get).collect(Collectors.joining("/"));
                return Optional.of(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u62b5\u6d88\u89c4\u5219\u4e0a\u4e0b\u7ea7\u8ba1\u5212\u79d1\u76ee\u4e0d\u80fd\u540c\u65f6\u914d\u7f6e\uff0c\u4e0e\u62b5\u6d88\u89c4\u5219\u3010%1$s\u3011\u7684\u914d\u7f6e\u9879\u51fa\u73b0\u51b2\u7a81\uff0c\u8bf7\u786e\u8ba4\u540c\u4e00\u4e2a\u7f16\u62a5\u7c7b\u578b\u3010%2$s\u3011\u4e0b\u62b5\u6d88\u8ba1\u5212\u79d1\u76ee\u4e0d\u5b58\u5728\u4e0a\u4e0b\u7ea7\u3002", (String)"InternalCancelRuleSaveValidator_11", (String)"tmc-fpm-business", (Object[])new Object[0]), uniqueEntity.getName(), des));
            }
            return Optional.empty();
        }

        private boolean hasSameParentNotSameLevel(Map<Long, SubjectCancelConfigConfirmValidator.SubjectInfo> subjectInfoToMap, UniqueEntity otherUniqueEntity) {
            boolean nonExistReportOrgIntersect;
            if (EmptyUtil.isNoEmpty((Long)this.id) && Objects.equals(this.id, otherUniqueEntity.getId())) {
                return false;
            }
            if (!Objects.equals(this.systemId, otherUniqueEntity.getSystemId())) {
                return false;
            }
            boolean nonExistReportTypeIntersect = this.reportTypeMap.keySet().stream().noneMatch(otherUniqueEntity.getReportTypeMap()::containsKey);
            if (nonExistReportTypeIntersect) {
                return false;
            }
            if (!this.applyCurrencyMap.isEmpty() && !otherUniqueEntity.getApplyCurrencyMap().isEmpty()) {
                boolean nonExistCurrencyIntersect = this.applyCurrencyMap.keySet().stream().noneMatch(otherUniqueEntity.getApplyCurrencyMap()::containsKey);
                if (nonExistCurrencyIntersect) {
                    return false;
                }
            }
            HashSet optionDimMemberSet = new HashSet(2, 1.0f);
            Optional.of(this.otherOptionalDimMap).ifPresent(dimMap -> optionDimMemberSet.addAll(dimMap.keySet()));
            Optional.of(this.otherOptionalDim1Map).ifPresent(dimMap -> optionDimMemberSet.addAll(dimMap.keySet()));
            Optional.of(this.otherOptionalDim2Map).ifPresent(dimMap -> optionDimMemberSet.addAll(dimMap.keySet()));
            HashSet uniqueEntityOptionDimMemberSet = new HashSet(2, 1.0f);
            Optional.of(otherUniqueEntity.getOtherOptionalDimMap()).ifPresent(dimMap -> uniqueEntityOptionDimMemberSet.addAll(dimMap.keySet()));
            Optional.of(otherUniqueEntity.getOtherOptionalDim1Map()).ifPresent(dimMap -> uniqueEntityOptionDimMemberSet.addAll(dimMap.keySet()));
            Optional.of(otherUniqueEntity.getOtherOptionalDim2Map()).ifPresent(dimMap -> uniqueEntityOptionDimMemberSet.addAll(dimMap.keySet()));
            if (!optionDimMemberSet.isEmpty() && !uniqueEntityOptionDimMemberSet.isEmpty()) {
                optionDimMemberSet.retainAll(uniqueEntityOptionDimMemberSet);
                if (CollectionUtils.isEmpty(optionDimMemberSet)) {
                    return false;
                }
            }
            if (this.isDefaultRule() ? !otherUniqueEntity.isDefaultRule() : (nonExistReportOrgIntersect = this.reportOrgMap.keySet().stream().noneMatch(otherUniqueEntity.getReportOrgMap()::containsKey))) {
                return false;
            }
            for (Long subjectId : this.subjectMap.keySet()) {
                SubjectCancelConfigConfirmValidator.SubjectInfo subjectInfo = subjectInfoToMap.get(subjectId);
                List<SubjectCancelConfigConfirmValidator.SubjectInfo> otherEntitySubjectInfoList = otherUniqueEntity.getSubjectMap().keySet().stream().map(subjectInfoToMap::get).collect(Collectors.toList());
                SubjectCancelConfigConfirmValidator.SubjectInfo result = subjectInfo.hasSameParentNotSameLevel(otherEntitySubjectInfoList);
                if (!EmptyUtil.isNoEmpty((Object)result)) continue;
                return true;
            }
            return false;
        }

        public static UniqueEntity getUniqueEntity(DynamicObject dynamicObject) {
            UniqueEntity uniqueEntity = new UniqueEntity();
            uniqueEntity.setId((Long)dynamicObject.getPkValue());
            uniqueEntity.setName(dynamicObject.getString("name"));
            uniqueEntity.setSystemId((Long)dynamicObject.getDynamicObject("bodysys").getPkValue());
            uniqueEntity.setReportTypeMap(UniqueEntity.getMap((Collection<DynamicObject>)dynamicObject.getDynamicObjectCollection("applyreporttype"), true));
            uniqueEntity.setApplyCurrencyMap(UniqueEntity.getMap((Collection<DynamicObject>)dynamicObject.getDynamicObjectCollection("applycurrency"), true));
            uniqueEntity.setOtherOptionalDimMap(UniqueEntity.getMap((Collection<DynamicObject>)dynamicObject.getDynamicObjectCollection("applyoptionaldim"), true));
            uniqueEntity.setOtherOptionalDim1Map(UniqueEntity.getMap((Collection<DynamicObject>)dynamicObject.getDynamicObjectCollection("applyoptionaldim1"), true));
            uniqueEntity.setOtherOptionalDim2Map(UniqueEntity.getMap((Collection<DynamicObject>)dynamicObject.getDynamicObjectCollection("applyoptionaldim2"), true));
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("apply_entryentity");
            uniqueEntity.setReportOrgMap(UniqueEntity.getMap(dynamicObjectCollection.stream().map(dy -> dy.getDynamicObject("apply_reportorg")).collect(Collectors.toList()), false));
            if (uniqueEntity.getReportOrgMap().isEmpty()) {
                uniqueEntity.setDefaultRule(true);
            }
            HashMap<Long, String> subjectMap = new HashMap<Long, String>(128);
            DynamicObjectCollection objectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject dy2 : objectCollection) {
                String configOUtJson;
                String configJson = dy2.getString("entry_inconfigreal_tag");
                if (EmptyUtil.isNoEmpty((String)configJson)) {
                    SubjectCancelConfig subjectCancelConfig = (SubjectCancelConfig)SerializationUtils.fromJsonString((String)configJson, SubjectCancelConfig.class);
                    List subjectList = subjectCancelConfig.getSubjectList();
                    subjectMap.putAll(subjectList.stream().collect(Collectors.toMap(SubjectCancelConfig.Subject::getId, SubjectCancelConfig.Subject::getName)));
                }
                if (!EmptyUtil.isNoEmpty((String)(configOUtJson = dy2.getString("entry_outconfigreal_tag")))) continue;
                SubjectCancelConfig subjectCancelOutConfig = (SubjectCancelConfig)SerializationUtils.fromJsonString((String)configOUtJson, SubjectCancelConfig.class);
                subjectMap.putAll(subjectCancelOutConfig.getSubjectList().stream().collect(Collectors.toMap(SubjectCancelConfig.Subject::getId, SubjectCancelConfig.Subject::getName)));
            }
            uniqueEntity.setSubjectMap(subjectMap);
            return uniqueEntity;
        }

        private static Map<Long, String> getMap(Collection<DynamicObject> dynamicObjectCollection, boolean isMultiBaseDataEdit) {
            if (CollectionUtils.isEmpty(dynamicObjectCollection)) {
                return Collections.emptyMap();
            }
            if (isMultiBaseDataEdit) {
                return dynamicObjectCollection.stream().map(dy -> dy.getDynamicObject("fbasedataid")).collect(Collectors.toMap(dy -> (Long)dy.getPkValue(), dy -> dy.getString("name")));
            }
            return dynamicObjectCollection.stream().filter(Objects::nonNull).collect(Collectors.toMap(dy -> (Long)dy.getPkValue(), dy -> dy.getString("name"), (a, b) -> a));
        }
    }

    static class ConfigEntity {
        private String name;
        private Set<Long> subjectIds;
        private Set<Long> outSubjectIds;
        private String secondName;

        public ConfigEntity() {
        }

        public ConfigEntity(String name, Set<Long> subjectIds, Set<Long> outSubjectIds) {
            this.name = name;
            this.subjectIds = subjectIds;
            this.outSubjectIds = outSubjectIds;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Set<Long> getSubjectIds() {
            return this.subjectIds;
        }

        public void setSubjectIds(Set<Long> subjectIds) {
            this.subjectIds = subjectIds;
        }

        public String getSecondName() {
            return this.secondName;
        }

        public void setSecondName(String secondName) {
            this.secondName = secondName;
        }

        public Set<Long> getOutSubjectIds() {
            return this.outSubjectIds;
        }

        public void setOutSubjectIds(Set<Long> outSubjectIds) {
            this.outSubjectIds = outSubjectIds;
        }

        public ConfigEntity intersect(ConfigEntity configEntity) {
            ConfigEntity entity = new ConfigEntity();
            HashSet<Long> subjectIds = new HashSet<Long>(this.getSubjectIds());
            subjectIds.retainAll(configEntity.getSubjectIds());
            entity.setName(this.getName());
            entity.setSubjectIds(subjectIds);
            entity.setSecondName(configEntity.getName());
            HashSet<Long> outSubjectIds = new HashSet<Long>(this.getOutSubjectIds());
            outSubjectIds.retainAll(configEntity.getOutSubjectIds());
            entity.setOutSubjectIds(outSubjectIds);
            return entity;
        }
    }
}

