/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.basesetting;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.helper.MatchRuleHelper;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.MatchRuleDetailFieldDataTypeEnum;
import kd.tmc.fpm.common.enums.MatchRuleDimensionDataTypeEnum;
import kd.tmc.fpm.common.enums.MatchRuleFetchPurposeEnum;
import kd.tmc.fpm.common.helper.FpmGlobalConfigHelper;
import org.apache.commons.lang3.StringUtils;

public class MatchRuleSaveValidator
extends AbstractTmcBizOppValidator {
    private MatchRuleHelper matchRuleHelper = new MatchRuleHelper();

    public void validate(ExtendedDataEntity[] dataEntityArr) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntityArr) {
            if (!this.checkBeforeSave(extendedDataEntity)) break;
        }
    }

    private boolean checkBeforeSave(ExtendedDataEntity extendedDataEntity) {
        String number;
        boolean verify;
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        Map<Long, Dimension> dimensionMap = this.getDimensionMap(dataEntity);
        if (Objects.isNull(dimensionMap) || dimensionMap.isEmpty()) {
            DynamicObject bodySys = dataEntity.getDynamicObject("bodysys");
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u4f53\u7cfb\u201c%s\u201d\u5bf9\u5e94\u7684\u7ef4\u5ea6\u6216\u660e\u7ec6\u5b57\u6bb5\u4e3a\u7a7a\u3002", (String)"MatchRuleSaveValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), bodySys.get("name")));
            return false;
        }
        DynamicObject businessBillObj = dataEntity.getDynamicObject("businessbill");
        String linkEntity = dataEntity.getString("linkentity");
        if (Objects.nonNull(businessBillObj) && StringUtils.isNotEmpty((CharSequence)linkEntity) && !(verify = FpmGlobalConfigHelper.getBooleanConfigByKey((String)"verifyagentpaybillentry")) && StringUtils.equals((CharSequence)(number = businessBillObj.getString("number")), (CharSequence)"cas_agentpaybill") && StringUtils.equals((CharSequence)linkEntity, (CharSequence)"entry")) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u57fa\u4e8e\u4e2a\u4eba\u9690\u79c1\u4fdd\u62a4\u7684\u8981\u6c42\uff0c\u7cfb\u7edf\u4e0d\u652f\u6301\u4ece\u4ee3\u53d1\u5904\u7406\uff08cas_agentpaybill\uff09\u7684\u4ee3\u53d1\u201c\u5206\u5f55entry\u201d\u5b9e\u4f53\u53d6\u6570\uff0c\u8bf7\u4fee\u6539\u53d6\u6570\u5173\u8054\u5b9e\u4f53\u3002", (String)"MatchRuleSaveValidator_12", (String)"tmc-fpm-business", (Object[])new Object[0]));
            return false;
        }
        return this.checkRequireInputs(extendedDataEntity, dimensionMap) && this.checkPlanAmountEntryIfOtherSelectedEntry(extendedDataEntity, dimensionMap) && this.checkDimensionBusinessBillFieldDuplicate(extendedDataEntity, dimensionMap);
    }

    private boolean checkDimensionBusinessBillFieldDuplicate(ExtendedDataEntity extendedDataEntity, Map<Long, Dimension> dimensionMap) {
        DynamicObjectCollection entryEntity = extendedDataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
        for (DynamicObject dynamicObject : entryEntity) {
            if (this.docheckMulitRowsSame("entry_businessbillfield", dynamicObject, extendedDataEntity, dimensionMap)) continue;
            return false;
        }
        return true;
    }

    private boolean docheckMulitRowsSame(String fieldName, DynamicObject dynamicObject, ExtendedDataEntity extendedDataEntity, Map<Long, Dimension> dimensionMap) {
        String value = dynamicObject.getString("entry_businessbillfield");
        if (Objects.isNull(value)) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)value)) {
            return true;
        }
        DynamicObjectCollection entryEntityCollection = extendedDataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
        Dimension currentDimension = this.getDimension(dynamicObject, dimensionMap);
        StringBuilder stringBuilder = new StringBuilder(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u7ef4\u5ea6\u4e0e\u4e1a\u52a1\u5355\u636e\u7684\u6620\u5c04\u5173\u7cfb\u4e0d\u5141\u8bb8\u51fa\u73b0\u591a\u5bf9\u4e00\uff0c\u8bf7\u68c0\u67e5\u6620\u5c04\u5173\u7cfb\u3002", (String)"MatchRuleSaveValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
        stringBuilder.append("\u3010").append(currentDimension.getName()).append("\u3011");
        boolean showMessage = false;
        for (int i = 0; i < entryEntityCollection.size(); ++i) {
            DynamicObject entryDynamicObject = (DynamicObject)entryEntityCollection.get(i);
            if (dynamicObject == entryDynamicObject || !value.equals(entryDynamicObject.get(fieldName))) continue;
            Dimension dimension = this.getDimension(entryDynamicObject, dimensionMap);
            stringBuilder.append("\u3001").append("\u3010").append(dimension.getName()).append("\u3011");
            showMessage = true;
        }
        if (!showMessage) {
            return true;
        }
        stringBuilder.append(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u4e1a\u52a1\u5355\u636e\u5b57\u6bb5\u914d\u7f6e", (String)"MatchRuleSaveValidator_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
        this.addErrorMessage(extendedDataEntity, stringBuilder.toString());
        return false;
    }

    private Dimension getDimension(DynamicObject dynamicObject, Map<Long, Dimension> dimensionMap) {
        Long dimesionOrDetailId = (Long)dynamicObject.getDynamicObject("entry_dimensiondetail").getPkValue();
        return dimensionMap.get(dimesionOrDetailId);
    }

    private boolean checkPlanAmountEntryIfOtherSelectedEntry(ExtendedDataEntity extendedDataEntity, Map<Long, Dimension> dimensionMap) {
        DynamicObject planAmountDynamicObject = null;
        boolean flag = false;
        DynamicObjectCollection dynamicObjectCollection = extendedDataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            Long dimesionOrDetailId;
            Dimension dimension;
            if (Objects.isNull(planAmountDynamicObject) && (dimension = dimensionMap.get(dimesionOrDetailId = (Long)dynamicObject.getDynamicObject("entry_dimensiondetail").getPkValue())).getDetailDimType() == DetailDimType.PLAN_AMOUNT) {
                planAmountDynamicObject = dynamicObject;
                if (!flag) continue;
                break;
            }
            String businessBillField = dynamicObject.getString("entry_businessbillfield");
            if (StringUtils.indexOf((CharSequence)businessBillField, (CharSequence)".") == -1) continue;
            flag = true;
            if (!Objects.nonNull(planAmountDynamicObject)) continue;
            break;
        }
        if (!flag) {
            return true;
        }
        if (planAmountDynamicObject != null && StringUtils.indexOf((CharSequence)planAmountDynamicObject.getString("entry_businessbillfield"), (CharSequence)".") == -1) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u5f53\u524d\u5176\u4ed6\u4e1a\u52a1\u5355\u636e\u5b57\u6bb5\u914d\u7f6e\u9879\u4e2d\u51fa\u73b0\u4e86\u5206\u5f55\u5b57\u6bb5\u503c\u3002\u8981\u6c42\u201c\u8ba1\u5212\u989d\u5ea6\u201d\u5bf9\u5e94\u7684\u4e1a\u52a1\u5355\u636e\u5b57\u6bb5\u5fc5\u987b\u4e3a\u5206\u5f55\u4e0a\u7684\u5b57\u6bb5\u3002", (String)"MatchRuleSaveValidator_3", (String)"tmc-fpm-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkRequireInputs(ExtendedDataEntity extendedDataEntity, Map<Long, Dimension> dimensionMap) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        DynamicObject businessBillObject = (DynamicObject)dataEntity.get("businessbill");
        String businessBill = businessBillObject.getString("number");
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("entryentity");
        DynamicObject bodySys = dataEntity.getDynamicObject("bodysys");
        String bodySysName = bodySys.getString("name");
        if (Objects.isNull(dimensionMap) || dimensionMap.isEmpty()) {
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u4f53\u7cfb\u201c%s\u201d\u5bf9\u5e94\u7684\u7ef4\u5ea6\u6216\u660e\u7ec6\u5b57\u6bb5\u4e3a\u7a7a\u3002", (String)"MatchRuleSaveValidator_4", (String)"tmc-fpm-business", (Object[])new Object[0]), bodySysName));
            return false;
        }
        StringBuilder sb = new StringBuilder(500);
        StringBuilder sencondBillCheckMessage = new StringBuilder(500);
        StringBuilder dimesionTypeCheckMessageMain = new StringBuilder(500);
        StringBuilder typeCheckMessageMain = new StringBuilder(500);
        StringBuilder typeCheckMessageSecond = new StringBuilder(500);
        StringBuilder dimesionMemberMap = new StringBuilder(100);
        boolean isPlanGetData = MatchRuleFetchPurposeEnum.PLAN_REPORT.getCode().equals(dataEntity.getString("fetchpurpose"));
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            Object dimensionMemberId;
            DynamicObject dimensionMember;
            IDataEntityProperty fieldType;
            String businessBillField = dynamicObject.getString("entry_businessbillfield");
            String secondBusinessBillField = dynamicObject.getString("entry_secondbusinessbill");
            Long dimesionOrDetailId = (Long)dynamicObject.getDynamicObject("entry_dimensiondetail").getPkValue();
            Dimension dimension = dimensionMap.get(dimesionOrDetailId);
            if (Objects.isNull(dimension)) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u4f53\u7cfb\u201c%1$s\u201d\u4e2d\u4e0d\u5b58\u5728\u7ef4\u5ea6\u6216\u660e\u7ec6\u5b57\u6bb5\u201c%2$s\u201d\u3002", (String)"MatchRuleSaveValidator_5", (String)"tmc-fpm-business", (Object[])new Object[0]), bodySysName));
                return false;
            }
            if (StringUtils.isNotEmpty((CharSequence)businessBillField)) {
                fieldType = this.matchRuleHelper.getFieldType(businessBillField, businessBill);
                this.checkType(dimension, dimesionTypeCheckMessageMain, fieldType, isPlanGetData);
                this.checkBaseDataTypeIsSame(dimension, fieldType, null, typeCheckMessageMain, dynamicObject);
            }
            if (StringUtils.isNotEmpty((CharSequence)secondBusinessBillField)) {
                fieldType = this.matchRuleHelper.getFieldType(businessBillField, businessBill);
                IDataEntityProperty secondFieldType = this.matchRuleHelper.getFieldType(secondBusinessBillField, businessBill);
                this.checkBaseDataTypeIsSame(dimension, fieldType, secondFieldType, typeCheckMessageSecond, dynamicObject);
            }
            DynamicObject entryDimensionMemberMap = dynamicObject.getDynamicObject("entry_dimensionmembermap");
            if (StringUtils.isNotBlank((CharSequence)secondBusinessBillField)) {
                if (!Objects.isNull(entryDimensionMemberMap)) continue;
                sencondBillCheckMessage.append("\u3010").append(dimension.getName()).append("\u3011").append("\u3001");
                continue;
            }
            if (Objects.nonNull(entryDimensionMemberMap) && (dimensionMember = TmcDataServiceHelper.loadSingle((Object)(dimensionMemberId = entryDimensionMemberMap.get("id")), (String)"fpm_dimensionmember")).getBoolean("useassistbasedata") && StringUtils.isBlank((CharSequence)secondBusinessBillField)) {
                dimesionMemberMap.append("\u3010").append(dimension.getName()).append("\u3011").append("\u3001");
            }
            if (StringUtils.isEmpty((CharSequence)businessBillField) && (MatchRuleHelper.SYSTEM_DEFINE_DIMENSION_DIMENSION_TYPE_SET.contains((Object)dimension.getDimType()) || MatchRuleHelper.CUSTOMER_DEFINE_DIMENSION_DIMENSION_TYPE_SET.contains((Object)dimension.getDimType()))) {
                sb.append("\u3010").append(dimension.getName()).append("\u3011").append("\u3001");
                continue;
            }
            if (!StringUtils.isEmpty((CharSequence)businessBillField) || dimension.getDimType() != DimensionType.DETAILDIM || dimension.getDetailDimType() != DetailDimType.PLAN_AMOUNT) continue;
            sb.append("\u3010").append(dimension.getName()).append("\u3011").append("\u3001");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u8bf7\u586b\u5199%s\u7ef4\u5ea6\u6216\u660e\u7ec6\u5b57\u6bb5\u6620\u5c04\u5339\u914d\u7684\u4e1a\u52a1\u5355\u636e\u5b57\u6bb5\u3002", (String)"MatchRuleSaveValidator_6", (String)"tmc-fpm-business", (Object[])new Object[0]), sb.toString()));
            return false;
        }
        if (dimesionMemberMap.length() > 0) {
            dimesionMemberMap.deleteCharAt(dimesionMemberMap.length() - 1);
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u7ef4\u5ea6\u6216\u660e\u7ec6\u5b57\u6bb5%s\u7684\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u5df2\u542f\u7528\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\uff0c\u5bf9\u5e94\u7684\u4e1a\u52a1\u5355\u636e\u8f85\u52a9\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MatchRuleSaveValidator_7", (String)"tmc-fpm-business", (Object[])new Object[0]), dimesionMemberMap.toString()));
            return false;
        }
        if (sencondBillCheckMessage.length() > 0) {
            sencondBillCheckMessage.deleteCharAt(sencondBillCheckMessage.length() - 1);
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u7ef4\u5ea6%s\u542f\u7528\u8f85\u52a9\u4e1a\u52a1\u5355\u636e\u5b57\u6bb5\u5339\u914d\uff0c\u4f46\u5176\u5bf9\u5e94\u7684\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u65b9\u6848\u4e3a\u7a7a\u3002", (String)"MatchRuleSaveValidator_8", (String)"tmc-fpm-business", (Object[])new Object[0]), sencondBillCheckMessage.toString()));
            return false;
        }
        if (dimesionTypeCheckMessageMain.length() > 0) {
            dimesionTypeCheckMessageMain.deleteCharAt(dimesionTypeCheckMessageMain.length() - 1);
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u8bf7\u68c0\u67e5%s\u5bf9\u5e94\u7684\u4e1a\u52a1\u5355\u636e\u5b57\u6bb5\u914d\u7f6e\uff0c\u786e\u4fdd\u7ef4\u5ea6\u53ca\u660e\u7ec6\u8ba1\u5212\u5b57\u6bb5\u5bf9\u5e94\u7684\u6570\u636e\u7c7b\u578b\u4e00\u81f4\u3002", (String)"MatchRuleSaveValidator_9", (String)"tmc-fpm-business", (Object[])new Object[0]), dimesionTypeCheckMessageMain.toString()));
            return false;
        }
        if (typeCheckMessageMain.length() > 0) {
            typeCheckMessageMain.deleteCharAt(typeCheckMessageMain.length() - 1);
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u4e1a\u52a1\u5355\u636e\u5b57\u6bb5\u7684\u6570\u636e\u7c7b\u578b\u4e3a\u57fa\u7840\u8d44\u6599\u65f6\uff0c\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u7684\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u9700\u8981\u4e0e\u4e1a\u52a1\u5355\u636e\u5b57\u6bb5\u7684\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5%1$s\u5bf9\u5e94\u7684\u4e1a\u52a1\u5355\u636e\u5b57\u6bb5\u4e0e\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u7684\u914d\u7f6e\u3002", (String)"MatchRuleSaveValidator_10", (String)"tmc-fpm-business", (Object[])new Object[0]), typeCheckMessageMain.toString()));
            return false;
        }
        if (typeCheckMessageSecond.length() > 0) {
            typeCheckMessageSecond.deleteCharAt(typeCheckMessageSecond.length() - 1);
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u4e1a\u52a1\u5355\u636e\u5b57\u6bb5\u7684\u6570\u636e\u7c7b\u578b\u4e3a\u57fa\u7840\u8d44\u6599\u65f6\uff0c\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u7684\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u9700\u8981\u4e0e\u8f85\u52a9\u4e1a\u52a1\u5355\u636e\u5b57\u6bb5\u7684\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5%1$s\u5bf9\u5e94\u7684\u8f85\u52a9\u4e1a\u52a1\u5355\u636e\u5b57\u6bb5\u4e0e\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u7684\u914d\u7f6e\u3002", (String)"MatchRuleSaveValidator_11", (String)"tmc-fpm-business", (Object[])new Object[0]), typeCheckMessageSecond.toString()));
            return false;
        }
        return true;
    }

    private void checkBaseDataTypeIsSame(Dimension dimension, IDataEntityProperty dataProperty, IDataEntityProperty secondDataProperty, StringBuilder typeCheckMessage, DynamicObject dynamicObject) {
        String assistBizData;
        String businessBillBaseType;
        if (Objects.isNull(dataProperty)) {
            return;
        }
        if (!BasedataProp.class.isAssignableFrom(dataProperty.getClass())) {
            return;
        }
        DynamicObject entryDimensionMemberMap = dynamicObject.getDynamicObject("entry_dimensionmembermap");
        if (Objects.isNull(entryDimensionMemberMap)) {
            return;
        }
        BasedataProp basedataProp = (BasedataProp)dataProperty;
        DynamicObject dimensionMemberMap = this.getDynamicObject((Long)entryDimensionMemberMap.getPkValue(), "fpm_dimensionmember");
        String bizDataType = dimensionMemberMap.getDynamicObject("bizbasedata").getString("number");
        if (!StringUtils.equals((CharSequence)bizDataType, (CharSequence)(businessBillBaseType = basedataProp.getBaseEntityId()))) {
            typeCheckMessage.append("\u3010").append(dimension.getName()).append("\u3011").append("\u3001");
            return;
        }
        if (Objects.isNull(secondDataProperty)) {
            return;
        }
        if (!BasedataProp.class.isAssignableFrom(secondDataProperty.getClass())) {
            typeCheckMessage.append("\u3010").append(dimension.getName()).append("\u3011").append("\u3001");
            return;
        }
        BasedataProp secondBaseDataProp = (BasedataProp)secondDataProperty;
        String secondBaseEntityId = secondBaseDataProp.getBaseEntityId();
        if (!StringUtils.equals((CharSequence)secondBaseEntityId, (CharSequence)(assistBizData = dimensionMemberMap.getDynamicObject("assistbizbasedata").getString("number")))) {
            typeCheckMessage.append("\u3010").append(dimension.getName()).append("\u3011").append("\u3001");
            return;
        }
    }

    private void checkType(Dimension dimension, StringBuilder typeCheckMessage, IDataEntityProperty fieldType, boolean isPlanGetData) {
        Class<? extends IDataEntityProperty> dataPropertyClass = this.getDataType(dimension);
        if (Objects.isNull(dataPropertyClass) || Objects.isNull(fieldType) || TextProp.class.isAssignableFrom(dataPropertyClass)) {
            return;
        }
        boolean checkFailure = false;
        if (!dataPropertyClass.isAssignableFrom(fieldType.getClass())) {
            checkFailure = true;
            if (isPlanGetData && (dimension.getDimType() == DimensionType.PERIOD && TextProp.class.isAssignableFrom(fieldType.getClass()) || dimension.getDimType() == DimensionType.PERIOD && BasedataProp.class.isAssignableFrom(fieldType.getClass()))) {
                checkFailure = false;
            }
        }
        if (checkFailure) {
            typeCheckMessage.append("\u3010").append(dimension.getName()).append("\u3011").append("\u3001");
        }
    }

    private Class<? extends IDataEntityProperty> getDataType(Dimension dimension) {
        if (dimension.getDimType() != DimensionType.DETAILDIM) {
            DimsionEnums dimsionByNumber = DimsionEnums.getDimsionByNumber((String)dimension.getNumber());
            MatchRuleDimensionDataTypeEnum matchRuleDimensionDataTypeEnum = MatchRuleDimensionDataTypeEnum.getMatchRuleDimensionDataTypeEnum((String)dimsionByNumber.getNumber());
            return matchRuleDimensionDataTypeEnum.getDataPropertyClass();
        }
        Long id = dimension.getId();
        DynamicObject dynamicObject = this.getDynamicObject(id, "fpm_detailplanfields");
        String dataType = dynamicObject.getString("datatype");
        MatchRuleDetailFieldDataTypeEnum matchRuleDetailFieldDataTypeEnum = MatchRuleDetailFieldDataTypeEnum.getMatchRuleDetailFieldDataTypeEnum((String)dataType);
        if (Objects.isNull(matchRuleDetailFieldDataTypeEnum)) {
            return null;
        }
        Class dataEntityPropertyClass = matchRuleDetailFieldDataTypeEnum.getDataEntityPropertyClass();
        if (!AmountProp.class.isAssignableFrom(dataEntityPropertyClass)) {
            return TextProp.class;
        }
        return dataEntityPropertyClass;
    }

    private DynamicObject getDynamicObject(Long id, String entityName) {
        DynamicObject dynamicObject = TmcDataServiceHelper.loadSingleFromCache((Object)id, (String)entityName);
        if (Objects.isNull(dynamicObject)) {
            dynamicObject = TmcDataServiceHelper.loadSingle((Object)id, (String)entityName);
        }
        return dynamicObject;
    }

    private Map<Long, Dimension> getDimensionMap(DynamicObject dataEntity) {
        DynamicObject bodySys = dataEntity.getDynamicObject("bodysys");
        Object pkValue = bodySys.getPkValue();
        if (Objects.isNull(pkValue)) {
            return new HashMap<Long, Dimension>(2);
        }
        DimensionRepository dimensionRepository = new DimensionRepository();
        FundPlanSystem fundPlanSystem = dimensionRepository.loadSystem((Long)pkValue);
        return fundPlanSystem.getDimList().stream().collect(Collectors.toMap(Dimension::getId, Function.identity()));
    }
}

