/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.basesetting;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fpm.business.domain.model.index.BitMap;
import kd.tmc.fpm.business.utils.ListHelper;

public class ReportPreparationEnableValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bodysysmanage");
        selector.add("orgreporttype");
        selector.add("enable");
        selector.add("number");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        HashSet<Long> systemIds = new HashSet<Long>(2);
        HashSet<Long> reportTypeIds = new HashSet<Long>(2);
        for (ExtendedDataEntity entity : dataEntity) {
            DynamicObject dyObj = entity.getDataEntity();
            systemIds.add((Long)dyObj.getDynamicObject("bodysysmanage").getPkValue());
            reportTypeIds.add((Long)dyObj.getDynamicObject("orgreporttype").getPkValue());
        }
        QFilter qFilter1 = new QFilter("bodysysmanage", "in", systemIds);
        QFilter qFilter2 = new QFilter("orgreporttype", "in", reportTypeIds);
        QFilter qFilter3 = new QFilter("enable", "=", (Object)"1");
        String selectFields = String.join((CharSequence)",", "id", "number", "bodysysmanage", "orgreporttype");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fpm_reportpreparation", (String)selectFields, (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
        BitMap<Long, DynamicObject> bitMap = new BitMap<Long, DynamicObject>(16);
        for (DynamicObject dynamicObject : query) {
            bitMap.addValue(ListHelper.asSet(dynamicObject.getLong("bodysysmanage"), dynamicObject.getLong("orgreporttype")), dynamicObject);
        }
        for (ExtendedDataEntity entity : dataEntity) {
            DynamicObject dyObj = entity.getDataEntity();
            String enable = dyObj.getString("enable");
            if (StringUtils.equals((CharSequence)enable, (CharSequence)"1")) continue;
            Long systemId = (Long)dyObj.getDynamicObject("bodysysmanage").getPkValue();
            Long reportTypeId = (Long)dyObj.getDynamicObject("orgreporttype").getPkValue();
            Set<Long> keys = ListHelper.asSet(systemId, reportTypeId);
            DynamicObject existObj = (DynamicObject)bitMap.findOne(keys);
            if (existObj != null) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u7f16\u7801%s\u8bb0\u5f55\u5df2\u542f\u7528\uff0c\u540c\u4e00\u4e2a\u4f53\u7cfb+\u7f16\u62a5\u7c7b\u578b\u4e0b\u7684\u7f16\u62a5\u51c6\u5907\u8bb0\u5f55\u4ec5\u53ef\u5b58\u5728\u4e00\u6761\u3002\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\u3002", (String)"ReportPreparationEnableValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), existObj.getString("number")));
                continue;
            }
            bitMap.addValue(keys, dyObj);
        }
    }
}

