/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.basesetting;

import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fpm.business.domain.enums.FixedFrequencyType;

public class ReportPreparationSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("contrlevelstopreptime");
        selector.add("defaultstopreptime");
        selector.add("isaccreportsubdefine");
        selector.add("fixedfrequency");
        selector.add("fixedfrequencystarttype");
        selector.add("fixedfrequencystartdate");
        selector.add("fixedfrequencyendtype");
        selector.add("fixedfrequencyenddate");
        selector.add("fixedfrequencyendtime");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity entity : dataEntity) {
            DynamicObject dyObj = entity.getDataEntity();
            boolean fixFrequency = dyObj.getBoolean("fixedfrequency");
            if (fixFrequency) {
                this.checkFixFrequency(entity);
                continue;
            }
            int defaultStopRepTime = dyObj.getInt("defaultstopreptime");
            int contrLevelStopRepTime = dyObj.getInt("contrlevelstopreptime");
            dyObj.getBoolean("isaccreportsubdefine");
            if (defaultStopRepTime >= contrLevelStopRepTime) continue;
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u53d7\u63a7\u5c42\u7ea7\u505c\u62a5\u65f6\u95f4\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u9ed8\u8ba4\u505c\u62a5\u65f6\u95f4", (String)"ReportPreparationSaveValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
    }

    private void checkFixFrequency(ExtendedDataEntity entity) {
        int endTime;
        DynamicObject dataEntity = entity.getDataEntity();
        String fixedFrequencyStartDate = dataEntity.getString("fixedfrequencystartdate");
        String fixedFrequencyEndDate = dataEntity.getString("fixedfrequencyenddate");
        String fixedFrequencyStartType = dataEntity.getString("fixedfrequencystarttype");
        String fixedFrequencyEndType = dataEntity.getString("fixedfrequencyendtype");
        if (Objects.equals(fixedFrequencyStartType, FixedFrequencyType.CURRENT_MONTH.getNumber()) && Objects.equals(fixedFrequencyEndType, FixedFrequencyType.LAST_MONTH.getNumber())) {
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u671f\u95f4\u586b\u62a5\u5f00\u59cb\u6708\u4e3a\u5f53\u6708\uff0c\u671f\u95f4\u586b\u62a5\u7ed3\u675f\u6708\u4e0d\u5141\u8bb8\u4e3a\u4e0a\u6708\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ReportPreparationSaveValidator_5", (String)"tmc-fpm-business", (Object[])new Object[0]));
            return;
        }
        if (!Objects.equals(fixedFrequencyStartType, fixedFrequencyEndType)) {
            return;
        }
        if (Integer.parseInt(fixedFrequencyStartDate) > Integer.parseInt(fixedFrequencyEndDate)) {
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u56fa\u5b9a\u586b\u62a5\u7ed3\u675f\u65f6\u95f4\u9700\u5927\u4e8e\u7b49\u4e8e\u56fa\u5b9a\u586b\u62a5\u5f00\u59cb\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ReportPreparationSaveValidator_6", (String)"tmc-fpm-business", (Object[])new Object[0]));
            return;
        }
        if (!dataEntity.getBoolean("isaccreportsubdefine")) {
            return;
        }
        int subLevelStopTime = dataEntity.getInt("contrlevelstopreptime");
        if (subLevelStopTime > (endTime = dataEntity.getInt("fixedfrequencyendtime"))) {
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u53d7\u63a7\u5c42\u7ea7\u505c\u62a5\u65f6\u95f4\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u56fa\u5b9a\u586b\u62a5\u7ed3\u675f\u65f6\u95f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ReportPreparationSaveValidator_7", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
    }
}

