/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.basesetting;

import java.util.Collection;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fpm.common.enums.DimsionEnums;

public class ReportVerifyRuleDimensionConfirmValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntityArr) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntityArr) {
            if (this.handleDimensionConfirmValid(extendedDataEntity.getDataEntity())) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u7ef4\u5ea6\u6210\u5458\u5b57\u6bb5\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ReportVerifyRuleDimensionEdit_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                break;
            }
            if (!this.handleMembersConfirmValid(extendedDataEntity.getDataEntity())) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u5e01\u79cd\u7ef4\u5ea6\u4e0b\u7ef4\u5ea6\u6210\u5458\u4e0d\u5141\u8bb8\u591a\u9009\u3002", (String)"ReportVerifyRuleDimensionEdit_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            break;
        }
    }

    private boolean handleDimensionConfirmValid(DynamicObject dynamicObject) {
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return false;
        }
        for (DynamicObject row : entryEntity) {
            DynamicObjectCollection mulmembers;
            DynamicObject item = row.getDynamicObject("dimension");
            if (item == null || !CollectionUtils.isEmpty((Collection)(mulmembers = row.getDynamicObjectCollection("mulmembers")))) continue;
            return true;
        }
        return false;
    }

    private boolean handleMembersConfirmValid(DynamicObject dynamicObject) {
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return false;
        }
        for (DynamicObject row : entryEntity) {
            DynamicObjectCollection members;
            DynamicObject dimension = row.getDynamicObject("dimension");
            if (Objects.isNull(dimension) || !DimsionEnums.CURRENCY.getNumber().equals(dimension.get("number")) || !CollectionUtils.isNotEmpty((Collection)(members = row.getDynamicObjectCollection("mulmembers"))) || members.size() <= 1) continue;
            return true;
        }
        return false;
    }
}

