/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.basesetting;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fpm.business.domain.enums.ReportVerifyCheckTypeEnum;
import kd.tmc.fpm.business.domain.model.report.ReportVerifyRuleDimension;
import kd.tmc.fpm.common.enums.DimsionEnums;
import org.apache.commons.lang3.StringUtils;

public class ReportVerifyRuleSaveValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntityArr) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntityArr) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            if (!this.handleCheckDimensionContainSubject(dataEntity)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u6821\u9a8c\u9879\u914d\u7f6e\u4e2d\u5e94\u542b\u6240\u9700\u6821\u9a8c\u7684\u8ba1\u5212\u79d1\u76ee\uff0c\u6216\u8005\u5728\u9002\u7528\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\u4e2d\u914d\u7f6e\u8ba1\u5212\u79d1\u76ee\u7684\u8303\u56f4\u3002\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c", (String)"ReportVerifyRuleSaveValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
                break;
            }
            if (!this.handleCheckReportType(dataEntity)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5f53\u524d\u6821\u9a8c\u7c7b\u578b\u4e3a\u8868\u95f4\u6570\u636e\u6821\u9a8c\uff0c\u9002\u7528\u7f16\u62a5\u7c7b\u578b\u4e0d\u652f\u6301\u591a\u9009\u3002\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c", (String)"ReportVerifyRuleSaveValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
                break;
            }
            DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)entryEntity)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7ef4\u5ea6\u6210\u5458\u9002\u7528\u8303\u56f4\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\u3002\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c", (String)"ReportVerifyRuleSaveValidator_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
                break;
            }
            boolean hasOrg = entryEntity.stream().map(item -> item.getDynamicObject("dimension")).filter(Objects::nonNull).anyMatch(item -> DimsionEnums.ORG.getNumber().equals(item.get("number")));
            if (hasOrg) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7ef4\u5ea6\u6210\u5458\u9002\u7528\u8303\u56f4\u4e0d\u53ef\u4ee5\u7f3a\u5c11\u7f16\u62a5\u4e3b\u4f53\u3002\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c", (String)"ReportVerifyRuleSaveValidator_3", (String)"tmc-fpm-business", (Object[])new Object[0]));
            break;
        }
    }

    private boolean handleCheckDimensionContainSubject(DynamicObject dataEntity) {
        boolean result;
        List reportVerifyRuleDimensionParams;
        String checkDimensionJson;
        List reportVerifyRuleDimensionParams2;
        boolean checkDimension = false;
        boolean checkedDimension = false;
        String checkedDimensionJson = (String)dataEntity.get("checkeddimensionvalue_tag");
        if (StringUtils.isNotEmpty((CharSequence)checkedDimensionJson) && !CollectionUtils.isEmpty((Collection)(reportVerifyRuleDimensionParams2 = JSON.parseArray((String)checkedDimensionJson, ReportVerifyRuleDimension.class)))) {
            checkedDimension = reportVerifyRuleDimensionParams2.stream().map(ReportVerifyRuleDimension::getDimensionName).anyMatch(item -> item.equals(DimsionEnums.SUBJECT.getName()));
        }
        if (StringUtils.isNotEmpty((CharSequence)(checkDimensionJson = (String)dataEntity.get("checkdimensionvalue_tag"))) && !CollectionUtils.isEmpty((Collection)(reportVerifyRuleDimensionParams = JSON.parseArray((String)checkDimensionJson, ReportVerifyRuleDimension.class)))) {
            checkDimension = reportVerifyRuleDimensionParams.stream().map(ReportVerifyRuleDimension::getDimensionName).anyMatch(item -> item.equals(DimsionEnums.SUBJECT.getName()));
        }
        boolean bl = result = checkDimension && checkedDimension;
        if (result) {
            return true;
        }
        DynamicObjectCollection dimList = dataEntity.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)dimList)) {
            return false;
        }
        result = dimList.stream().map(item -> item.getDynamicObject("dimension")).anyMatch(item -> DimsionEnums.SUBJECT.getNumber().equals(item.get("number")));
        if (!result) {
            return false;
        }
        for (DynamicObject entry : dimList) {
            DynamicObject dynamicObject = entry.getDynamicObject("dimension");
            if (!Objects.nonNull(dynamicObject) || !DimsionEnums.SUBJECT.getNumber().equals(dynamicObject.get("number"))) continue;
            result = !CollectionUtils.isEmpty((Collection)entry.getDynamicObjectCollection("mulmembers"));
        }
        return result;
    }

    private boolean handleCheckReportType(DynamicObject dataEntity) {
        ReportVerifyCheckTypeEnum checkType = ReportVerifyCheckTypeEnum.getByCode(dataEntity.getString("checktype"));
        DynamicObjectCollection reportType = dataEntity.getDynamicObjectCollection("reporttype");
        if (Objects.nonNull((Object)checkType) && ReportVerifyCheckTypeEnum.BETWEEN_TABLE == checkType) {
            return reportType.size() <= 1;
        }
        return true;
    }
}

