/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.basesetting;

import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.common.enums.GetValueTypeEnum;
import kd.tmc.fpm.common.helper.FpmGlobalConfigHelper;
import org.apache.commons.lang3.StringUtils;

public class SmartCollectPlanSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selectors = super.getSelector();
        selectors.add("valtype");
        selectors.add("sync");
        selectors.add("syncprop");
        selectors.add("entry_syncopkey");
        return selectors;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity data : extendedDataEntities) {
            String number;
            boolean verify;
            DynamicObject dataEntity = data.getDataEntity();
            DynamicObject businessBillObj = dataEntity.getDynamicObject("sourcebill");
            String linkEntity = dataEntity.getString("linkentity");
            if (Objects.nonNull(businessBillObj) && StringUtils.isNotEmpty((CharSequence)linkEntity) && !(verify = FpmGlobalConfigHelper.getBooleanConfigByKey((String)"verifyagentpaybillentry")) && StringUtils.equals((CharSequence)(number = businessBillObj.getString("number")), (CharSequence)"cas_agentpaybill") && StringUtils.equals((CharSequence)linkEntity, (CharSequence)"entry")) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u57fa\u4e8e\u4e2a\u4eba\u9690\u79c1\u4fdd\u62a4\u7684\u8981\u6c42\uff0c\u7cfb\u7edf\u4e0d\u652f\u6301\u4ece\u4ee3\u53d1\u5904\u7406\uff08cas_agentpaybill\uff09\u7684\u4ee3\u53d1\u201c\u5206\u5f55entry\u201d\u5b9e\u4f53\u53d6\u6570\uff0c\u8bf7\u4fee\u6539\u53d6\u6570\u5173\u8054\u5b9e\u4f53\u3002", (String)"SmartCollectPlanSaveValidator_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
            DynamicObjectCollection entryList = dataEntity.getDynamicObjectCollection("entry_fieldmapping");
            boolean hasSyncProp = false;
            for (int i = 0; i < entryList.size(); ++i) {
                String syncProp;
                DynamicObject dynamicObject = (DynamicObject)entryList.get(i);
                String valType = dynamicObject.getString("valtype");
                boolean isFormula = GetValueTypeEnum.CALC_FORMULA.getValue().equals(valType);
                boolean sync = dynamicObject.getBoolean("sync");
                if (sync) {
                    hasSyncProp = true;
                }
                if (!isFormula || !sync || !EmptyUtil.isEmpty((String)(syncProp = dynamicObject.getString("syncprop")))) continue;
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\u5355\u636e\u4f53\u7b2c%d\u884c\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u914d\u7f6e\u5df2\u5f00\u542f\u6e90\u5355\u5b57\u6bb5\u503c\u53d8\u5316\u76d1\u542c\u5bf9\u5e94\u7684\u3010\u76d1\u542c\u6e90\u5355\u5b57\u6bb5\u3011\u503c", (String)"SmartCollectPlanSaveValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), i + 1));
            }
            DynamicObjectCollection strategyList = dataEntity.getDynamicObjectCollection("entry_syncstrategy");
            boolean hasSyncOp = strategyList.stream().anyMatch(o -> !EmptyUtil.isEmpty((String)o.getString("entry_syncopkey")));
            if (!hasSyncOp || hasSyncProp) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u542f\u7528\u6570\u636e\u81ea\u52a8\u66f4\u65b0\u76d1\u542c\u64cd\u4f5c\u540e\uff0c\u8bf7\u5f00\u542f\u9700\u8981\u76d1\u542c\u6e90\u5355\u5b57\u6bb5\u53d8\u5316\u53ca\u76d1\u542c\u6e90\u5355\u5b57\u6bb5\u8303\u56f4\uff0c\u4fbf\u4e8e\u6570\u636e\u540c\u6b65\u66f4\u65b0\u5904\u7406\u3002", (String)"SmartCollectPlanSaveValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
    }
}

