/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.basesetting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.common.enums.DimsionEnums;

public class SubjectCancelConfigConfirmValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        if (EmptyUtil.isEmpty((Object[])dataEntity)) {
            return;
        }
        DynamicObject dataDy = dataEntity[0].getDataEntity();
        Long bodySysId = dataDy.getLong("bodysysid");
        String parentIdProp = String.join((CharSequence)".", "parent", "id");
        String selectFields = String.join((CharSequence)",", "id", "level", "name", parentIdProp);
        DynamicObject[] load = TmcDataServiceHelper.load((String)"fpm_member", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", (Object)bodySysId).and("dimtype", "=", (Object)DimsionEnums.SUBJECT.getNumber())});
        Map<Long, SubjectInfo> subjectInfoToMap = SubjectInfo.getSubjectInfoToMap(load);
        if (subjectInfoToMap.isEmpty()) {
            return;
        }
        for (ExtendedDataEntity entity : dataEntity) {
            DynamicObject entityDataEntity = entity.getDataEntity();
            DynamicObjectCollection dynamicObjectCollection = entityDataEntity.getDynamicObjectCollection("entryentity");
            HashMap<Object, Integer> exists = new HashMap<Object, Integer>(dynamicObjectCollection.size());
            ArrayList<SubjectInfo> subjectInfoList = new ArrayList<SubjectInfo>(dynamicObjectCollection.size());
            for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                DynamicObject entry = (DynamicObject)dynamicObjectCollection.get(i);
                DynamicObject dynamicObject = entry.getDynamicObject("subjectid");
                if (EmptyUtil.isEmpty((DynamicObject)dynamicObject)) continue;
                Object pkValue = dynamicObject.getPkValue();
                if (exists.containsKey(pkValue)) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u7b2c\u3010%1$s\u3011\u884c\u4e0e\u7b2c\u3010%2$s\u3011\u79d1\u76ee\u91cd\u590d\uff0c\u8bf7\u786e\u8ba4", (String)"SubjectCancelConfigConfirmValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), exists.get(pkValue), i));
                    continue;
                }
                exists.put(pkValue, i);
                SubjectInfo subjectInfo = subjectInfoToMap.get(pkValue);
                SubjectInfo result = subjectInfo.hasSameParentNotSameLevel(subjectInfoList);
                if (!EmptyUtil.isEmpty((Object)result)) {
                    String message = subjectInfo.getParentIds().size() > result.getParentIds().size() ? result.getName() + ";" + subjectInfo.getName() : subjectInfo.getName() + ";" + result.getName();
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u540c\u4e00\u4e2a\u5206\u652f\u7684\u4e0a\u4e0b\u7ea7\u8ba1\u5212\u79d1\u76ee\u3010%1$s\u3011", (String)"SubjectCancelConfigConfirmValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]), message));
                    continue;
                }
                subjectInfoList.add(subjectInfo);
            }
        }
    }

    static class SubjectInfo {
        private Long id;
        private String name;
        private int level;
        private Long parentId;
        private Set<Long> parentIds;

        public SubjectInfo() {
            this(0L, "", 0);
        }

        public SubjectInfo(Long id, String name, int level) {
            this(id, name, level, 0L);
        }

        public SubjectInfo(Long id, String name, int level, Long parentId) {
            this.id = id;
            this.name = name;
            this.level = level;
            this.parentId = parentId;
            this.parentIds = new HashSet<Long>(8);
            if (EmptyUtil.isNoEmpty((Long)parentId)) {
                this.parentIds.add(parentId);
            }
        }

        public void addParentId(Long parentId) {
            if (EmptyUtil.isNoEmpty((Long)parentId)) {
                this.parentIds.add(parentId);
            }
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public Long getParentId() {
            return this.parentId;
        }

        public void setParentId(Long parentId) {
            this.parentId = parentId;
        }

        public Set<Long> getParentIds() {
            return this.parentIds;
        }

        public void setParentIds(Set<Long> parentIds) {
            this.parentIds = parentIds;
        }

        public static SubjectInfo getSubjectInfoByDynamicObject(DynamicObject subject) {
            String parentIdProp = String.join((CharSequence)".", "parent", "id");
            return new SubjectInfo((Long)subject.getPkValue(), subject.getString("name"), subject.getInt("level"), subject.getLong(parentIdProp));
        }

        public boolean hasSameParentNotSameLevel(SubjectInfo subjectInfo) {
            if (this.level == subjectInfo.level) {
                return false;
            }
            return this.parentIds.contains(subjectInfo.getId()) || subjectInfo.getParentIds().contains(this.id);
        }

        public SubjectInfo hasSameParentNotSameLevel(List<SubjectInfo> subjectInfoList) {
            if (EmptyUtil.isEmpty(subjectInfoList)) {
                return null;
            }
            Optional<SubjectInfo> first = subjectInfoList.stream().filter(info -> this.hasSameParentNotSameLevel((SubjectInfo)info)).findFirst();
            if (first.isPresent()) {
                return first.get();
            }
            return null;
        }

        public static Map<Long, SubjectInfo> getSubjectInfoToMap(DynamicObject[] dynamicObjects) {
            if (EmptyUtil.isEmpty((Object[])dynamicObjects)) {
                return Collections.emptyMap();
            }
            List subjects = Arrays.stream(dynamicObjects).sorted(Comparator.comparing(dy -> dy.getInt("level"))).collect(Collectors.toList());
            HashMap<Long, SubjectInfo> subjectInfoMap = new HashMap<Long, SubjectInfo>(dynamicObjects.length);
            for (DynamicObject subject : subjects) {
                SubjectInfo subjectInfo = SubjectInfo.getSubjectInfoByDynamicObject(subject);
                Long id = subjectInfo.getId();
                subjectInfoMap.put(id, subjectInfo);
                Long parentId = subjectInfo.getParentId();
                if (EmptyUtil.isEmpty((Long)parentId)) continue;
                SubjectInfo.addAllParentId(subjectInfo, parentId, subjectInfoMap);
            }
            return subjectInfoMap;
        }

        private static void addAllParentId(SubjectInfo subjectInfo, Long parentId, Map<Long, SubjectInfo> subjectInfoMap) {
            if (EmptyUtil.isEmpty((Long)parentId)) {
                return;
            }
            if (!subjectInfoMap.containsKey(parentId)) {
                return;
            }
            SubjectInfo parent = subjectInfoMap.get(parentId);
            subjectInfo.addParentId(parent.getId());
            parentId = parent.getParentId();
            SubjectInfo.addAllParentId(subjectInfo, parentId, subjectInfoMap);
        }
    }
}

