/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.basesetting;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.common.enums.ReportPlanStatusEnum;
import kd.tmc.fpm.common.enums.ReportPlanTypeEnum;

public class SummaryConfigDisableValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bodysys");
        selector.add("sumreporttype");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        if (EmptyUtil.isEmpty((Object[])dataEntity)) {
            return;
        }
        Long systemId = (Long)dataEntity[0].getDataEntity().getDynamicObject("bodysys").getPkValue();
        Set reportTypeSet = Arrays.stream(dataEntity).map(ExtendedDataEntity::getDataEntity).map(dy -> dy.getDynamicObjectCollection("sumreporttype")).flatMap(Collection::stream).map(dy -> dy.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).map(Long.class::cast).collect(Collectors.toSet());
        String reportTypeProp = String.join((CharSequence)".", "reportperiod", "reporttype");
        String selectFields = String.join((CharSequence)",", "id", "reportperiod");
        Object[] load = TmcDataServiceHelper.load((String)"fpm_report", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("bodysys", "=", (Object)systemId).and(reportTypeProp, "in", reportTypeSet).and("planstatus", "!=", (Object)ReportPlanStatusEnum.EFFECTIVE.getValue()).and("reportplantype", "=", (Object)ReportPlanTypeEnum.SUMPLAN.getValue())});
        if (EmptyUtil.isEmpty((Object[])load)) {
            return;
        }
        Map<Object, List<DynamicObject>> reportTypeMap = Arrays.stream(load).map(dy -> dy.getDynamicObject("reportperiod")).collect(Collectors.groupingBy(dy -> dy.getDynamicObject("reporttype").getPkValue()));
        block0: for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject entity = extendedDataEntity.getDataEntity();
            DynamicObjectCollection dynamicObjectCollection = entity.getDynamicObjectCollection("sumreporttype");
            for (DynamicObject reportType : dynamicObjectCollection) {
                List<DynamicObject> dynamicObjectList;
                Object pkValue;
                DynamicObject dynamicObject = reportType.getDynamicObject("fbasedataid");
                if (EmptyUtil.isEmpty((DynamicObject)dynamicObject) || !reportTypeMap.containsKey(pkValue = dynamicObject.getPkValue()) || !EmptyUtil.isNoEmpty(dynamicObjectList = reportTypeMap.get(pkValue))) continue;
                DynamicObject period = dynamicObjectList.get(0);
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7981\u7528\u5931\u8d25\uff0c\u5f53\u524d\u4f53\u7cfb\u4e0b\u5bf9\u5e94\u7f16\u62a5\u7c7b\u578b\u3010%1$s\u3011/\u3010%2$s\u3011\u6b63\u5904\u4e8e\u4e0a\u62a5\u6d41\u7a0b\u4e2d\uff0c\u5b58\u5728\u5728\u9014\u5355\u636e\uff0c\u6682\u4e0d\u5141\u8bb8\u7981\u7528\u5904\u7406\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"SummaryConfigDisableValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), period.getDynamicObject("reporttype").getString("name"), period.getString("name")));
                continue block0;
            }
        }
    }
}

