/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.basesetting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.common.enums.ReportPlanStatusEnum;
import kd.tmc.fpm.common.enums.ReportPlanTypeEnum;

public class SummaryConfigEnableValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bodysys");
        selector.add("sumreporttype");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        if (EmptyUtil.isEmpty((Object[])dataEntity)) {
            return;
        }
        Long systemId = (Long)dataEntity[0].getDataEntity().getDynamicObject("bodysys").getPkValue();
        Set reportTypeSet = Arrays.stream(dataEntity).map(ExtendedDataEntity::getDataEntity).map(dy -> dy.getDynamicObjectCollection("sumreporttype")).flatMap(Collection::stream).map(dy -> dy.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).map(Long.class::cast).collect(Collectors.toSet());
        String reportTypeProp = String.join((CharSequence)".", "reportperiod", "reporttype");
        String selectFields = String.join((CharSequence)",", "id", "reportperiod");
        Object[] load = TmcDataServiceHelper.load((String)"fpm_report", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("bodysys", "=", (Object)systemId).and(reportTypeProp, "in", reportTypeSet).and("planstatus", "!=", (Object)ReportPlanStatusEnum.EFFECTIVE.getValue()).and("reportplantype", "=", (Object)ReportPlanTypeEnum.SUMPLAN.getValue())});
        Map<String, List<DynamicObject>> exists = this.getAllEnabledSumConfigGroupByReportType(dataEntity);
        if (EmptyUtil.isEmpty((Object[])load) && CollectionUtils.isEmpty(exists)) {
            return;
        }
        Map<Object, List<DynamicObject>> reportTypeMap = Arrays.stream(load).map(dy -> dy.getDynamicObject("reportperiod")).collect(Collectors.groupingBy(dy -> dy.getDynamicObject("reporttype").getPkValue()));
        block0: for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject entity = extendedDataEntity.getDataEntity();
            DynamicObject bodySys = entity.getDynamicObject("bodysys");
            DynamicObjectCollection dynamicObjectCollection = entity.getDynamicObjectCollection("sumreporttype");
            for (DynamicObject reportType : dynamicObjectCollection) {
                List<DynamicObject> dynamicObjectList;
                Object pkValue;
                DynamicObject summaryConfig;
                Optional<DynamicObject> first;
                List<DynamicObject> summaryConfigList;
                DynamicObject dynamicObject = reportType.getDynamicObject("fbasedataid");
                if (EmptyUtil.isEmpty((DynamicObject)dynamicObject)) continue;
                String key = String.join((CharSequence)"_", bodySys.getPkValue().toString(), dynamicObject.getPkValue().toString());
                if (exists.containsKey(key) && EmptyUtil.isNoEmpty(summaryConfigList = exists.get(key)) && (first = (summaryConfig = summaryConfigList.get(0)).getDynamicObjectCollection("sumreporttype").stream().map(rt -> rt.getDynamicObject("fbasedataid")).filter(dy -> Objects.equals(dy.getPkValue(), dynamicObject.getPkValue())).findFirst()).isPresent()) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\uff0c\u4f53\u7cfb\u4e0b\u540c\u4e00\u4e2a\u7f16\u62a5\u7c7b\u578b\u4e0d\u5141\u8bb8\u540c\u65f6\u5b58\u5728\u591a\u7b14\u53ef\u7528\u72b6\u6001\u7684\u53c2\u6570\uff0c\u5f53\u524d\u3010%1$s\u3011\u5df2\u5b58\u5728\u53ef\u7528\u72b6\u6001\u4e0b\u7684\u6c47\u603b\u53c2\u6570\u8bb0\u5f55\u3010%2$s\u3011\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"SummaryConfigEnableValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), first.get().getString("name"), summaryConfig.getString("name")));
                }
                if (!reportTypeMap.containsKey(pkValue = dynamicObject.getPkValue()) || !EmptyUtil.isNoEmpty(dynamicObjectList = reportTypeMap.get(pkValue))) continue;
                DynamicObject period = dynamicObjectList.get(0);
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\u3002\u5f53\u524d\u4f53\u7cfb\u4e0b\uff0c\u5bf9\u5e94\u7f16\u62a5\u7c7b\u578b\u201c%1$s\u201d\u3001\u201c%2$s\u201d\u6b63\u5904\u4e8e\u4e0a\u62a5\u6d41\u7a0b\u4e2d\uff0c\u5b58\u5728\u5728\u9014\u5355\u636e\u3002\u6682\u4e0d\u5141\u8bb8\u542f\u7528\u6c47\u603b\u53c2\u6570\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"SummaryConfigEnableValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]), period.getDynamicObject("reporttype").getString("name"), period.getString("name")));
                continue block0;
            }
        }
    }

    private Map<String, List<DynamicObject>> getAllEnabledSumConfigGroupByReportType(ExtendedDataEntity[] dataEntity) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(dataEntity.length);
        for (ExtendedDataEntity entity : dataEntity) {
            DynamicObject dynamicObject = entity.getDataEntity();
            DynamicObject bodySys = dynamicObject.getDynamicObject("bodysys");
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("sumreporttype");
            Set reportTypeIdSet = dynamicObjectCollection.stream().map(dy -> dy.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
            String reportTypeProp = String.join((CharSequence)".", "sumreporttype", "fbasedataid", "id");
            qFilterList.add(new QFilter(String.join((CharSequence)".", "bodysys", "id"), "=", bodySys.getPkValue()).and(reportTypeProp, "in", reportTypeIdSet).and("enable", "=", (Object)"1"));
        }
        HashMap<String, List<DynamicObject>> exists = new HashMap<String, List<DynamicObject>>(16);
        if (!qFilterList.isEmpty()) {
            QFilter first = (QFilter)qFilterList.get(0);
            for (QFilter qFilter : qFilterList) {
                if (first == qFilter) continue;
                first = first.or(qFilter);
            }
            String bodySysIdProp = String.join((CharSequence)".", "bodysys", "id");
            String selectFields = String.join((CharSequence)",", "id", "number", "name", bodySysIdProp, "sumreporttype");
            DynamicObject[] load = TmcDataServiceHelper.load((String)"fpm_summaryconfig", (String)selectFields, (QFilter[])new QFilter[]{first});
            if (load != null && load.length != 0) {
                for (DynamicObject dynamicObject : load) {
                    String bodySysId = dynamicObject.getString(bodySysIdProp);
                    DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("sumreporttype");
                    for (DynamicObject reportType : dynamicObjectCollection) {
                        String reportTypeId = String.valueOf(reportType.getDynamicObject("fbasedataid").getPkValue());
                        List dynamicObjectList = exists.computeIfAbsent(String.join((CharSequence)"_", bodySysId, reportTypeId), key -> new ArrayList(2));
                        dynamicObjectList.add(dynamicObject);
                    }
                }
            }
        }
        return exists;
    }
}

