/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.basesetting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class SummaryConfigSaveValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(dataEntity.length);
        for (ExtendedDataEntity entity : dataEntity) {
            DynamicObject dynamicObject = entity.getDataEntity();
            DynamicObject[] bodySys = dynamicObject.getDynamicObject("bodysys");
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("sumreporttype");
            Set reportTypeIdSet = dynamicObjectCollection.stream().map(dy -> dy.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
            String reportTypeProp = String.join((CharSequence)".", "sumreporttype", "fbasedataid", "id");
            qFilterList.add(new QFilter(String.join((CharSequence)".", "bodysys", "id"), "=", bodySys.getPkValue()).and(reportTypeProp, "in", reportTypeIdSet).and("enable", "=", (Object)"1"));
        }
        HashMap<String, List> exists = new HashMap<String, List>(16);
        if (!qFilterList.isEmpty()) {
            QFilter first = (QFilter)qFilterList.get(0);
            for (QFilter qFilter : qFilterList) {
                if (first == qFilter) continue;
                first = first.or(qFilter);
            }
            String bodySysIdProp = String.join((CharSequence)".", "bodysys", "id");
            String selectFields = String.join((CharSequence)",", "id", "number", "name", bodySysIdProp, "sumreporttype");
            DynamicObject[] load = TmcDataServiceHelper.load((String)"fpm_summaryconfig", (String)selectFields, (QFilter[])new QFilter[]{first});
            if (load != null && load.length != 0) {
                for (DynamicObject dynamicObject : load) {
                    String bodySysId = dynamicObject.getString(bodySysIdProp);
                    DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("sumreporttype");
                    for (DynamicObject reportType : dynamicObjectCollection) {
                        String reportTypeId = String.valueOf(reportType.getDynamicObject("fbasedataid").getPkValue());
                        List dynamicObjectList = exists.computeIfAbsent(String.join((CharSequence)"_", bodySysId, reportTypeId), key -> new ArrayList(2));
                        dynamicObjectList.add(dynamicObject);
                    }
                }
            }
        }
        for (ExtendedDataEntity entity : dataEntity) {
            DynamicObject dynamicObject = entity.getDataEntity();
            DynamicObject bodySys = dynamicObject.getDynamicObject("bodysys");
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("sumreporttype");
            for (DynamicObject reportType : dynamicObjectCollection) {
                DynamicObject reportTypeObj = reportType.getDynamicObject("fbasedataid");
                String key2 = String.join((CharSequence)"_", bodySys.getPkValue().toString(), reportTypeObj.getPkValue().toString());
                if (exists.containsKey(key2)) {
                    List summaryConfigList = (List)exists.get(key2);
                    for (DynamicObject summaryConfig : summaryConfigList) {
                        Optional<DynamicObject> first;
                        if (Objects.equals(summaryConfig.getPkValue(), dynamicObject.getPkValue()) || !dynamicObject.getBoolean("enable") || !(first = summaryConfig.getDynamicObjectCollection("sumreporttype").stream().map(rt -> rt.getDynamicObject("fbasedataid")).filter(dy -> Objects.equals(dy.getPkValue(), reportTypeObj.getPkValue())).findFirst()).isPresent()) continue;
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u4f53\u7cfb\u201c%1$s\u201d\u4e0b\u7684\u6c47\u603b\u7f16\u62a5\u7c7b\u578b\u201c%2$s\u201d\u5df2\u5b58\u5728\u53c2\u6570\u914d\u7f6e\u8bb0\u5f55\u201c%3$s\u201d\u3002\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\u3002", (String)"SummaryConfigSaveValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), bodySys.getString("name"), first.get().getString("name"), summaryConfig.getString("name")));
                    }
                }
                List dynamicObjectList = exists.computeIfAbsent(key2, k -> new ArrayList(2));
                if (!dynamicObject.getBoolean("enable")) continue;
                dynamicObjectList.add(dynamicObject);
            }
        }
    }

    public boolean isAddBillNoForContent() {
        return true;
    }
}

