/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.dimension;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.common.enums.MetricMemberTypeEnum;

public class MemberDeleteValidator
extends AbstractTmcBizOppValidator {
    private final Map<Long, String> falseMsgIdMap = new HashMap<Long, String>(16);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("id");
        selector.add("name");
        selector.add("parent");
        selector.add("bodysystem.id");
        selector.add("dimtype");
        selector.add("level");
        selector.add("dimension");
        selector.add("preset");
        selector.add("metrictype");
        selector.add("reporttype.id");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        if (extendedDataEntities.length == 0) {
            return;
        }
        List<Long> memberIdList = Arrays.stream(extendedDataEntities).map(ExtendedDataEntity::getDataEntity).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        long systemId = extendedDataEntities[0].getDataEntity().getLong("bodysystem.id");
        DynamicObject dutyOrgInfo = QueryServiceHelper.queryOne((String)"fpm_bodysysmanage", (String)"id,org.name,org.number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)systemId)});
        String dutyOrgName = dutyOrgInfo.getString("org.name");
        String dutyOrgNumber = dutyOrgInfo.getString("org.number");
        String dimType = extendedDataEntities[0].getDataEntity().getString("dimtype");
        Map<Long, DynamicObject> refMap = this.getTemplateRefMap("fpm_template", memberIdList, systemId);
        Map<Long, DynamicObject> templateBakRefMap = this.getTemplateRefMap("fpm_template_bak", memberIdList, systemId);
        Map<Object, Object> templateRefMetricMap = new HashMap(16);
        Map<Object, Object> templateRefPosMetricMap = new HashMap(16);
        HashMap refPeriodTemplateMap = Maps.newHashMapWithExpectedSize((int)0);
        HashMap refPeriodTemplateBakMap = Maps.newHashMapWithExpectedSize((int)0);
        if (DimensionType.METRIC.getNumber().equals(dimType)) {
            String metricProp = "metricentry.newmetrictype";
            String remarkSelectProp = String.join((CharSequence)",", "id", "number", "name", metricProp);
            DynamicObjectCollection metricLoad = QueryServiceHelper.query((String)"fpm_template", (String)remarkSelectProp, (QFilter[])new QFilter(metricProp, "in", memberIdList).toArray());
            templateRefMetricMap = metricLoad.stream().collect(Collectors.groupingBy(d -> d.getLong(metricProp), Collectors.mapping(o -> o.getString("number") + o.getString("name"), Collectors.joining("\u3011\u3010"))));
            String posBDProp = String.join((CharSequence)".", "reporttypeentry", "newreferencepos", "fbasedataid");
            String posSelectProp = String.join((CharSequence)",", "id", "number", "name", posBDProp);
            DynamicObjectCollection posLoad = QueryServiceHelper.query((String)"fpm_template", (String)posSelectProp, (QFilter[])new QFilter(posBDProp, "in", memberIdList).toArray());
            templateRefPosMetricMap = posLoad.stream().collect(Collectors.groupingBy(d -> d.getLong(posBDProp), Collectors.mapping(o -> o.getString("number") + o.getString("name"), Collectors.joining("\u3011\u3010"))));
        } else if (DimensionType.PERIOD.getNumber().equals(dimType)) {
            this.fillRefPeriodTemplateMap(extendedDataEntities, refPeriodTemplateMap, refPeriodTemplateBakMap);
        }
        Arrays.sort(extendedDataEntities, (o1, o2) -> {
            Long level1 = o1.getDataEntity().getLong("level");
            Long level2 = o2.getDataEntity().getLong("level");
            return level1.compareTo(level2);
        });
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            long parentId;
            DynamicObject refTemplateObj;
            String errorInfo;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            long memberId = dataEntity.getLong("id");
            String memberName = dataEntity.getString("name");
            String memberNumber = dataEntity.getString("number");
            String dimensionName = dataEntity.getString("dimension.name");
            if (DimensionType.ORG.getNumber().equals(dimType)) {
                if (Objects.equals(memberName, dutyOrgName) && Objects.equals(memberNumber, dutyOrgNumber)) {
                    errorInfo = String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u4e3a\u672c\u4f53\u7cfb\u7684\u8d23\u4efb\u7ec4\u7ec7\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"MemberDeleteValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]), memberName);
                    this.addFatalErrorMessage(extendedDataEntity, errorInfo);
                }
            } else if (DimensionType.METRIC.getNumber().equals(dimType)) {
                String msg;
                if (dataEntity.getBoolean("preset")) {
                    errorInfo = ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u7cfb\u7edf\u9884\u7f6e\u7684\u5ea6\u91cf\u53ca\u6307\u6807\u8bb0\u5f55\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"MemberDeleteValidator_2", (String)"tmc-fpm-business", (Object[])new Object[0]);
                    this.addFatalErrorMessage(extendedDataEntity, errorInfo);
                }
                if (templateRefMetricMap.containsKey(memberId)) {
                    msg = String.format(ResManager.loadKDString((String)"%1$s\u3010%2$s\u3011\u5df2\u88ab\u3010%3$s\u3011\u6a21\u677f\u5173\u8054\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"MemberDeleteValidator_3", (String)"tmc-fpm-business", (Object[])new Object[0]), Objects.requireNonNull(MetricMemberTypeEnum.getEnumByCode((String)dataEntity.getString("metrictype"))).getName(), dataEntity.get("name"), templateRefMetricMap.get(memberId));
                    this.addFatalErrorMessage(extendedDataEntity, msg);
                }
                if (templateRefPosMetricMap.containsKey(memberId)) {
                    msg = String.format(ResManager.loadKDString((String)"%1$s\u3010%2$s\u3011\u5df2\u88ab\u3010%3$s\u3011\u6a21\u677f\u5173\u8054\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"MemberDeleteValidator_3", (String)"tmc-fpm-business", (Object[])new Object[0]), Objects.requireNonNull(MetricMemberTypeEnum.getEnumByCode((String)dataEntity.getString("metrictype"))).getName(), dataEntity.get("name"), templateRefPosMetricMap.get(memberId));
                    this.addFatalErrorMessage(extendedDataEntity, msg);
                }
            } else if (DimensionType.PERIOD.getNumber().equals(dimType)) {
                Long reportTypeId = dataEntity.getLong("reporttype.id");
                boolean existRefPeriodTemplate = !refPeriodTemplateMap.isEmpty() && refPeriodTemplateMap.containsKey(reportTypeId);
                boolean bl = existRefPeriodTemplate = existRefPeriodTemplate || !refPeriodTemplateBakMap.isEmpty() && refPeriodTemplateBakMap.containsKey(reportTypeId);
                if (existRefPeriodTemplate) {
                    this.addFatalErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e0b\u5df2\u521b\u5efa\u5bf9\u5e94\u7684\u6a21\u677f\uff0c\u4e0d\u5141\u8bb8\u5220\u9664", (String)"MemberDeleteValidator_5", (String)"tmc-fpm-business", (Object[])new Object[0]));
                    continue;
                }
            }
            if (!templateBakRefMap.isEmpty() && templateBakRefMap.containsKey(memberId)) {
                refTemplateObj = templateBakRefMap.get(memberId);
                String errorInfo2 = String.format(ResManager.loadKDString((String)"%1$s\u4e0b\u5b58\u5728\u8ba1\u5212\u5355\u636e\u5f15\u7528\u4e86%2$s\u4e0b\u7684%3$s\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"MemberDeleteValidator_4", (String)"tmc-fpm-business", (Object[])new Object[0]), refTemplateObj.getString("name"), dimensionName, memberName);
                this.addFatalErrorMessage(extendedDataEntity, errorInfo2);
            } else if (!refMap.isEmpty() && refMap.containsKey(memberId)) {
                refTemplateObj = refMap.get(memberId);
                String errorInfo3 = String.format(ResManager.loadKDString((String)"%1$s\u3010%2$s\u3011\u5df2\u88ab\u6a21\u677f\u3010%3$s\u3011\u5f15\u7528\uff0c\u8bf7\u89e3\u9664\u5173\u8054\u540e\u65b9\u53ef\u5220\u9664\u3002", (String)"MemberDeleteValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), dimensionName, memberName, refTemplateObj.getString("name"));
                this.addFatalErrorMessage(extendedDataEntity, errorInfo3);
            }
            DynamicObject parent = dataEntity.getDynamicObject("parent");
            if (parent == null || !this.falseMsgIdMap.containsKey(parentId = parent.getLong("id"))) continue;
            this.addFatalErrorMessage(extendedDataEntity, this.falseMsgIdMap.get(parentId));
        }
    }

    private Map<Long, DynamicObject> getTemplateRefMap(String entity, List<Long> memberIdList, long systemId) {
        String entryBaseDataIdProp = "dimsettingentry.plantemplatemember.fbasedataid";
        QFilter qFilter = new QFilter("model", "=", (Object)systemId);
        qFilter.and(entryBaseDataIdProp, "in", memberIdList);
        String selectProp = String.join((CharSequence)",", "id,name", entryBaseDataIdProp);
        DynamicObjectCollection refColl = QueryServiceHelper.query((String)entity, (String)selectProp, (QFilter[])new QFilter[]{qFilter});
        Map<Long, DynamicObject> refMap = refColl.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong(entryBaseDataIdProp), v -> v, (k1, k2) -> k1));
        return refMap;
    }

    protected void addFatalErrorMessage(ExtendedDataEntity dataEntity, String content) {
        super.addFatalErrorMessage(dataEntity, content);
        Object billPkId = dataEntity.getBillPkId();
        this.falseMsgIdMap.put((Long)billPkId, content);
    }

    private Map<Long, List<DynamicObject>> getRefPeriodTemplateMap(String entity, List<Long> reportTypeIds, long systemId) {
        String entryBaseDataIdProp = "reporttypeentry.e_reporttype.id";
        QFilter qFilter = new QFilter("model", "=", (Object)systemId);
        qFilter.and(entryBaseDataIdProp, "in", reportTypeIds);
        String selectProp = String.join((CharSequence)",", "id", entryBaseDataIdProp);
        DynamicObjectCollection refColl = QueryServiceHelper.query((String)entity, (String)selectProp, (QFilter[])new QFilter[]{qFilter});
        return refColl.stream().collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getLong(entryBaseDataIdProp)));
    }

    private void fillRefPeriodTemplateMap(ExtendedDataEntity[] extendedDataEntities, Map<Long, List<DynamicObject>> templateRefMap, Map<Long, List<DynamicObject>> templateBakRefMap) {
        long systemId = extendedDataEntities[0].getDataEntity().getLong("bodysystem.id");
        List<Long> reportTypeIds = Arrays.stream(extendedDataEntities).map(ExtendedDataEntity::getDataEntity).map(dy -> dy.getLong("reporttype.id")).distinct().collect(Collectors.toList());
        templateRefMap.putAll(this.getRefPeriodTemplateMap("fpm_template", reportTypeIds, systemId));
        templateBakRefMap.putAll(this.getRefPeriodTemplateMap("fpm_template_bak", reportTypeIds, systemId));
    }
}

