/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.dimension;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.MetricMemberTypeEnum;
import kd.tmc.fpm.common.enums.OrgReportTypeCycleEnum;
import kd.tmc.fpm.common.enums.OrgReportTypeEnum;
import kd.tmc.fpm.common.utils.NumberUtils;

public class MemberDisableValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("id");
        selector.add("name");
        selector.add("parent");
        selector.add("bodysystem");
        selector.add("dimtype");
        selector.add("dimension");
        selector.add("reporttype");
        selector.add("preset");
        selector.add("metrictype");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        if (extendedDataEntities.length == 0) {
            return;
        }
        List memberIdList = Arrays.stream(extendedDataEntities).map(ExtendedDataEntity::getDataEntity).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        long systemId = extendedDataEntities[0].getDataEntity().getLong("bodysystem.id");
        String dimType = extendedDataEntities[0].getDataEntity().getString("dimtype");
        String entryBaseDataIdProp = "dimsettingentry.plantemplatemember.fbasedataid";
        QFilter qFilter = new QFilter("model", "=", (Object)systemId);
        qFilter.and("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue());
        String selectProp = String.join((CharSequence)",", "id,name,user.fbasedataid", entryBaseDataIdProp);
        DynamicObjectCollection refColl = QueryServiceHelper.query((String)"fpm_template", (String)selectProp, (QFilter[])new QFilter[]{qFilter});
        HashMap<Long, DynamicObject> orgRefMap = new HashMap<Long, DynamicObject>(refColl.size());
        for (DynamicObject template : refColl) {
            long orgId = template.getLong("user.fbasedataid");
            if (NumberUtils.equalsZero((Long)orgId)) continue;
            orgRefMap.put(orgId, template);
        }
        Map<Long, DynamicObject> refMap = refColl.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong(entryBaseDataIdProp), v -> v, (k1, k2) -> k1));
        Map<Object, Object> refReportPeriodMap = new HashMap(16);
        Map<Object, Object> refReportPeriodMemberMap = new HashMap(16);
        if (DimensionType.PERIOD.getNumber().equals(dimType)) {
            QFilter periodQFilter1 = new QFilter("bodysys", "=", (Object)systemId);
            periodQFilter1.and(new QFilter("reportperiod", "in", memberIdList));
            DynamicObjectCollection refReportByReportPeriodColl = QueryServiceHelper.query((String)"fpm_report", (String)"id,billno,reportperiod", (QFilter[])new QFilter[]{periodQFilter1});
            refReportPeriodMap = refReportByReportPeriodColl.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("reportperiod"), v -> v, (k1, k2) -> k1));
            QFilter periodQFilter2 = new QFilter("bodysys", "=", (Object)systemId);
            periodQFilter1.and(new QFilter("maindimentry.periodmem", "in", memberIdList));
            DynamicObjectCollection refReportByPeriodMemberColl = QueryServiceHelper.query((String)"fpm_report", (String)"id,billno,maindimentry.periodmem", (QFilter[])new QFilter[]{periodQFilter2});
            refReportPeriodMemberMap = refReportByPeriodMemberColl.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("maindimentry.periodmem"), v -> v, (k1, k2) -> k1));
        }
        Map<Object, Object> templateRefMetricMap = new HashMap(16);
        Map<Object, Object> templateRefPosMetricMap = new HashMap(16);
        if (DimensionType.METRIC.getNumber().equals(dimType)) {
            String metricProp = "metricentry.newmetrictype";
            String remarkSelectProp = String.join((CharSequence)",", "id", "number", "name", metricProp);
            DynamicObjectCollection metricLoad = QueryServiceHelper.query((String)"fpm_template", (String)remarkSelectProp, (QFilter[])new QFilter(metricProp, "in", memberIdList).toArray());
            templateRefMetricMap = metricLoad.stream().collect(Collectors.groupingBy(d -> d.getLong(metricProp), Collectors.mapping(o -> o.getString("number") + o.getString("name"), Collectors.joining("\u3011\u3010"))));
            String posBDProp = String.join((CharSequence)".", "reporttypeentry", "newreferencepos", "fbasedataid");
            String posSelectProp = String.join((CharSequence)",", "id", "number", "name", posBDProp);
            DynamicObjectCollection posLoad = QueryServiceHelper.query((String)"fpm_template", (String)posSelectProp, (QFilter[])new QFilter[]{new QFilter(posBDProp, "in", memberIdList), new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue())});
            templateRefPosMetricMap = posLoad.stream().collect(Collectors.groupingBy(d -> d.getLong(posBDProp), Collectors.mapping(o -> o.getString("number") + o.getString("name"), Collectors.joining("\u3011\u3010"))));
        }
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            String errorInfo;
            DynamicObject refTemplateObj;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            long memberId = dataEntity.getLong("id");
            String dimensionName = dataEntity.getString("dimension.name");
            if (DimensionType.PERIOD.getNumber().equals(dimType)) {
                String errorInfo2;
                DynamicObject reportType = dataEntity.getDynamicObject("reporttype");
                String orgReportCycle = reportType.getString("orgreportcycle");
                String orgReportType = reportType.getString("orgreporttype");
                if (Arrays.asList(OrgReportTypeCycleEnum.YEAR.getValue(), OrgReportTypeCycleEnum.HALFYEAR.getValue(), OrgReportTypeCycleEnum.QUARTER.getValue(), OrgReportTypeCycleEnum.MONTH.getValue()).contains(orgReportCycle)) {
                    String errorInfo3 = ResManager.loadKDString((String)"\u671f\u95f4\u3010%s\u3011\u7981\u7528\u5931\u8d25\uff0c\u671f\u95f4\u957f\u5ea6\u5927\u4e8e\u6216\u7b49\u4e8e\u6708\u7684\uff0c\u4e0d\u5141\u8bb8\u7981\u7528\u3002", (String)"MemberDisableValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]);
                    this.addErrorMessage(extendedDataEntity, String.format(errorInfo3, dataEntity.getString("name")));
                }
                List<String> orgReportTypeList = Arrays.asList(OrgReportTypeEnum.TEN.getValue(), OrgReportTypeEnum.WEEK.getValue(), OrgReportTypeEnum.DAY.getValue());
                if (OrgReportTypeCycleEnum.MONTH.getValue().equals(orgReportCycle) && orgReportTypeList.contains(orgReportType) || (OrgReportTypeCycleEnum.TEN.getValue().equals(orgReportCycle) || OrgReportTypeCycleEnum.WEEK.getValue().equals(orgReportCycle)) && OrgReportTypeEnum.DAY.getValue().equals(orgReportType)) {
                    errorInfo2 = ResManager.loadKDString((String)"\u671f\u95f4\u3010%s\u3011\u7981\u7528\u5931\u8d25\uff0c\u660e\u7ec6\u671f\u95f4\u6210\u5458\u4e0d\u5141\u8bb8\u7981\u7528\u3002", (String)"MemberDisableValidator_2", (String)"tmc-fpm-business", (Object[])new Object[0]);
                    this.addFatalErrorMessage(extendedDataEntity, String.format(errorInfo2, dataEntity.getString("name")));
                }
                if (OrgReportTypeCycleEnum.MONTH.getValue().equals(orgReportCycle)) {
                    errorInfo2 = ResManager.loadKDString((String)"\u671f\u95f4\u3010%s\u3011\u7981\u7528\u5931\u8d25\uff0c\u7f16\u62a5\u5468\u671f\u4e3a\u6708\u7684\u671f\u95f4\u6210\u5458\u4e0d\u5141\u8bb8\u7981\u7528\u3002", (String)"MemberDisableValidator_3", (String)"tmc-fpm-business", (Object[])new Object[0]);
                    this.addFatalErrorMessage(extendedDataEntity, String.format(errorInfo2, DimsionEnums.getDimsionByNumber((String)dimType).getName()));
                }
                if (!refReportPeriodMap.isEmpty() && refReportPeriodMap.containsKey(memberId) || !refReportPeriodMemberMap.isEmpty() && refReportPeriodMemberMap.containsKey(memberId)) {
                    errorInfo2 = ResManager.loadKDString((String)"\u671f\u95f4\u3010%s\u3011\u7981\u7528\u5931\u8d25\uff0c\u56e0\u671f\u95f4\u6210\u5458\u5df2\u5173\u8054\u8d44\u91d1\u8ba1\u5212\u7f16\u5236\u5355\u636e\uff0c\u65e0\u6cd5\u7981\u7528\u3002", (String)"MemberDisableValidator_4", (String)"tmc-fpm-business", (Object[])new Object[0]);
                    this.addFatalErrorMessage(extendedDataEntity, String.format(errorInfo2, dataEntity.getString("name")));
                }
            } else if (DimensionType.METRIC.getNumber().equals(dimType)) {
                String msg;
                if (dataEntity.getBoolean("preset")) {
                    String errorInfo4 = ResManager.loadKDString((String)"\u7981\u7528\u5931\u8d25\uff0c\u7cfb\u7edf\u9884\u7f6e\u7684\u5ea6\u91cf\u53ca\u6307\u6807\u8bb0\u5f55\u4e0d\u5141\u8bb8\u7981\u7528\u3002", (String)"MemberDisableValidator_5", (String)"tmc-fpm-business", (Object[])new Object[0]);
                    this.addFatalErrorMessage(extendedDataEntity, errorInfo4);
                }
                if (templateRefMetricMap.containsKey(memberId)) {
                    msg = String.format(ResManager.loadKDString((String)"%1$s\u4e0b\u7684%2$s\u5df2\u88ab%3$s\u5f15\u7528\uff0c\u4ec5\u5f53\u8be5\u6a21\u677f\u4e3a\u7981\u7528\u65f6\uff0c\u624d\u5141\u8bb8\u7981\u7528\u8be5\u7ef4\u5ea6\u6210\u5458\u3002", (String)"MemberDisableValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), Objects.requireNonNull(MetricMemberTypeEnum.getEnumByCode((String)dataEntity.getString("metrictype"))).getName(), dataEntity.get("name"), templateRefMetricMap.get(memberId));
                    this.addFatalErrorMessage(extendedDataEntity, msg);
                }
                if (templateRefPosMetricMap.containsKey(memberId)) {
                    msg = String.format(ResManager.loadKDString((String)"%1$s\u4e0b\u7684%2$s\u5df2\u88ab%3$s\u5f15\u7528\uff0c\u4ec5\u5f53\u8be5\u6a21\u677f\u4e3a\u7981\u7528\u65f6\uff0c\u624d\u5141\u8bb8\u7981\u7528\u8be5\u7ef4\u5ea6\u6210\u5458\u3002", (String)"MemberDisableValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), Objects.requireNonNull(MetricMemberTypeEnum.getEnumByCode((String)dataEntity.getString("metrictype"))).getName(), dataEntity.get("name"), templateRefPosMetricMap.get(memberId));
                    this.addFatalErrorMessage(extendedDataEntity, msg);
                }
            }
            if (DimensionType.ORG.getNumber().equals(dimType)) {
                if (!orgRefMap.containsKey(memberId)) continue;
                refTemplateObj = (DynamicObject)orgRefMap.get(memberId);
                errorInfo = ResManager.loadKDString((String)"%1$s\u4e0b\u7684%2$s\u5df2\u88ab%3$s\u5f15\u7528\uff0c\u4ec5\u5f53\u8be5\u6a21\u677f\u4e3a\u7981\u7528\u65f6\uff0c\u624d\u5141\u8bb8\u7981\u7528\u8be5\u7ef4\u5ea6\u6210\u5458\u3002", (String)"MemberDisableValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]);
                this.addFatalErrorMessage(extendedDataEntity, String.format(errorInfo, dimensionName, dataEntity.getString("name"), refTemplateObj.getString("name")));
            }
            if (refMap.isEmpty() || !refMap.containsKey(memberId)) continue;
            refTemplateObj = refMap.get(memberId);
            errorInfo = ResManager.loadKDString((String)"%1$s\u4e0b\u7684%2$s\u5df2\u88ab%3$s\u5f15\u7528\uff0c\u4ec5\u5f53\u8be5\u6a21\u677f\u4e3a\u7981\u7528\u65f6\uff0c\u624d\u5141\u8bb8\u7981\u7528\u8be5\u7ef4\u5ea6\u6210\u5458\u3002", (String)"MemberDisableValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]);
            this.addFatalErrorMessage(extendedDataEntity, String.format(errorInfo, dimensionName, dataEntity.getString("name"), refTemplateObj.getString("name")));
        }
    }
}

