/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.dimension;

import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.FlowType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.common.enums.DimsionEnums;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SubjectMemberSaveValidator
extends AbstractTmcBizOppValidator {
    private IDimensionRepository iDimensionRepository = FpmServiceFactory.getBizService(IDimensionRepository.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("id");
        selector.add("name");
        selector.add("number");
        selector.add("dimtype");
        selector.add("formulavalue");
        selector.add("model");
        selector.add("parent.id");
        selector.add("flow");
        selector.add("ways");
        selector.add("linksubject.id");
        selector.add("linksubject.number");
        selector.add("linksubject.name");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        boolean isSubjectSave = Arrays.stream(extendedDataEntities).map(ExtendedDataEntity::getDataEntity).map(dy -> dy.getString("dimtype")).allMatch(dimType -> DimensionType.SUBJECTS.getNumber().equals(dimType));
        if (!isSubjectSave) {
            return;
        }
        long systemId = this.dataEntities[0].getDataEntity().getLong("bodysystem.id");
        Dimension subjectDim = this.iDimensionRepository.loadMainDimensionBySystemId(systemId, DimensionType.SUBJECTS).get(0);
        List<AccountMember> accountMemberList = subjectDim.getAllDimMemberList(AccountMember.class);
        List subjectObjList = Arrays.stream(extendedDataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        Set cacheSubjectIdSet = Arrays.stream(extendedDataEntities).map(ExtendedDataEntity::getDataEntity).map(dataEntity -> dataEntity.getLong("id")).collect(Collectors.toSet());
        List dbAccountMemberList = accountMemberList.stream().filter(accountMember -> !cacheSubjectIdSet.contains(accountMember.getId())).collect(Collectors.toList());
        subjectObjList.addAll(dbAccountMemberList);
        Map<Long, Object> accountMemberMap = subjectObjList.stream().collect(Collectors.toMap(key -> {
            if (key instanceof DynamicObject) {
                return ((DynamicObject)key).getLong("id");
            }
            return ((AccountMember)key).getId();
        }, Function.identity(), (a, b) -> a));
        Map<Long, List<Object>> parent2AccountMemberMap = subjectObjList.stream().filter(subject -> {
            if (subject instanceof DynamicObject) {
                Long parentId = ((DynamicObject)subject).getLong("parent.id");
                return EmptyUtil.isNoEmpty((Long)parentId);
            }
            Long parentId = ((AccountMember)subject).getParentId();
            return EmptyUtil.isNoEmpty((Long)parentId);
        }).collect(Collectors.groupingBy(key -> {
            if (key instanceof DynamicObject) {
                return ((DynamicObject)key).getLong("parent.id");
            }
            return ((AccountMember)key).getParentId();
        }));
        Set linkSubjectSet = Arrays.stream(this.dataEntities).map(ExtendedDataEntity::getDataEntity).map(i -> i.getLong("linksubject.id")).collect(Collectors.toSet());
        Map<Object, Object> linkSubjectMap = new HashMap(1);
        String prop = String.join((CharSequence)",", "name", "number", "linksubject.id", "linksubject.number", "linksubject.name");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fpm_member", (String)prop, (QFilter[])new QFilter[]{new QFilter("bodysysmanage", "=", (Object)systemId), new QFilter("linksubject", "in", linkSubjectSet)});
        if (!CollectionUtils.isEmpty((Collection)query)) {
            linkSubjectMap = query.stream().collect(Collectors.groupingBy(k -> k.getLong("linksubject.id")));
        }
        for (ExtendedDataEntity dt : extendedDataEntities) {
            DynamicObject dynamicObject;
            String repeatNumber;
            List dynamicObjects;
            boolean hasLinkSubject;
            boolean isNew;
            DynamicObject dataEntity2 = dt.getDataEntity();
            String number = dataEntity2.getString("number");
            String name = dataEntity2.getString("name");
            Long bodySystemId = dataEntity2.getLong("bodysystem.id");
            DynamicObjectCollection queryNumberResult = QueryServiceHelper.query((String)"fpm_member", (String)"number", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)name), new QFilter("dimtype", "=", (Object)DimsionEnums.SUBJECT.getNumber()), new QFilter("bodysystem", "=", (Object)bodySystemId)});
            boolean bl = isNew = !dataEntity2.getDataEntityState().getFromDatabase();
            if (isNew && CollectionUtils.isNotEmpty((Collection)queryNumberResult)) {
                this.addErrorMessage(dt, String.format(ResManager.loadKDString((String)"\u672c\u6b21\u65b0\u589e\u7684%1$s\u79d1\u76ee\u6210\u5458\u4e0e\u7cfb\u7edf\u5df2\u5b58\u5728\u7f16\u7801\u4e3a%2$s\u79d1\u76ee\u6210\u5458\u540d\u79f0\u4e00\u81f4\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u6b21\u64cd\u4f5c\uff01", (String)"SubjectMemberSaveValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]), name, ((DynamicObject)queryNumberResult.get(0)).getString("number")));
                continue;
            }
            long linkSubjectId = dataEntity2.getLong("linksubject.id");
            boolean bl2 = hasLinkSubject = !EmptyUtil.isEmpty((Long)linkSubjectId);
            if (hasLinkSubject && CollectionUtils.isNotEmpty((Collection)(dynamicObjects = (List)linkSubjectMap.get(linkSubjectId))) && !StringUtils.equals((CharSequence)(repeatNumber = (dynamicObject = (DynamicObject)dynamicObjects.get(0)).getString("number")), (CharSequence)number)) {
                String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u671f\u521d\u79d1\u76ee\u201c%1$s\u201d\u5df2\u88ab\u201c%2$s\u201d\u5173\u8054\uff0c\u7cfb\u7edf\u9650\u5236\u540c\u4e00\u4e2a\u671f\u521d\u79d1\u76ee\u4ec5\u5141\u8bb8\u88ab\u4e00\u4e2a\u671f\u672b\u8ba1\u5212\u79d1\u76ee\u5173\u8054\uff0c\u8bf7\u786e\u8ba4\u76f8\u5173\u914d\u7f6e\u3002", (String)"SubjectMemberSaveValidator_4", (String)"tmc-fpm-business", (Object[])new Object[0]);
                String beginName = dynamicObject.getString("linksubject.number") + dynamicObject.getString("linksubject.name");
                String endName = repeatNumber + dynamicObject.getString("name");
                String format = String.format(msg, beginName, endName);
                this.addFatalErrorMessage(dt, format);
                continue;
            }
            boolean isInvalidFlowType = this.isInvalidFlowTypeByParentSubject(dataEntity2, accountMemberMap);
            boolean bl3 = isInvalidFlowType = isInvalidFlowType || this.isInvalidFlowTypeBySubSubject(dataEntity2, parent2AccountMemberMap);
            if (!isInvalidFlowType) continue;
            this.addErrorMessage(dt, ResManager.loadKDString((String)"\u4e0a\u4e0b\u7ea7\u79d1\u76ee\u7684\u6d41\u5411\u4e0d\u80fd\u76f8\u53cd\uff0c\u8bf7\u4fee\u6539", (String)"SubjectMemberSaveValidator_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
    }

    private boolean isInvalidFlowTypeByParentSubject(DynamicObject subjectMember, Map<Long, Object> accountMemberMap) {
        String flow = subjectMember.getString("flow");
        HashSet checkedSubjectIdSet = Sets.newHashSetWithExpectedSize((int)8);
        Long currParentId = subjectMember.getLong("parent.id");
        while (EmptyUtil.isNoEmpty((Long)currParentId) && !checkedSubjectIdSet.contains(currParentId)) {
            Long nextParentId = null;
            if (accountMemberMap.containsKey(currParentId)) {
                String parentFlow;
                Object parentSubjectObj = accountMemberMap.get(currParentId);
                if (parentSubjectObj instanceof DynamicObject) {
                    parentFlow = ((DynamicObject)parentSubjectObj).getString("flow");
                    nextParentId = ((DynamicObject)parentSubjectObj).getLong("parent.id");
                } else {
                    parentFlow = ((AccountMember)parentSubjectObj).getFlowType().getNumber();
                    nextParentId = ((AccountMember)parentSubjectObj).getParentId();
                }
                if (FlowType.isOppositeFlowType(flow, parentFlow)) {
                    return true;
                }
                checkedSubjectIdSet.add(currParentId);
            }
            currParentId = nextParentId;
        }
        return false;
    }

    private boolean isInvalidFlowTypeBySubSubject(DynamicObject subjectMember, Map<Long, List<Object>> parent2AccountMemberMap) {
        Long currSubjectId;
        String flow = subjectMember.getString("flow");
        Long subjectId = subjectMember.getLong("id");
        HashSet checkedSubjectIdSet = Sets.newHashSetWithExpectedSize((int)8);
        ArrayDeque<Long> stack = new ArrayDeque<Long>(10);
        stack.push(subjectId);
        while (!stack.isEmpty() && !checkedSubjectIdSet.contains(currSubjectId = (Long)stack.pop())) {
            checkedSubjectIdSet.add(currSubjectId);
            if (!parent2AccountMemberMap.containsKey(currSubjectId)) continue;
            List<Object> subSubjectList = parent2AccountMemberMap.get(currSubjectId);
            for (Object subSubject : subSubjectList) {
                String subSubjectFlow;
                Long subSubjectId;
                if (subSubject instanceof DynamicObject) {
                    subSubjectId = ((DynamicObject)subSubject).getLong("id");
                    subSubjectFlow = ((DynamicObject)subSubject).getString("flow");
                } else {
                    subSubjectId = ((AccountMember)subSubject).getId();
                    subSubjectFlow = ((AccountMember)subSubject).getFlowType().getNumber();
                }
                if (FlowType.isOppositeFlowType(flow, subSubjectFlow)) {
                    return true;
                }
                stack.push(subSubjectId);
            }
        }
        return false;
    }
}

