/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.inoutpool;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fpm.common.enums.InoutCollectApprovalStatusEnum;
import org.apache.commons.lang3.StringUtils;

public class InoutCollectApprovalValidate
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        return Arrays.asList("id", "billno", "applyorg", "businesstype", "inoutdirection", "approvalstatus", "abandonstatus");
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity entity : dataEntity) {
            DynamicObject dynamicObject = entity.getDataEntity();
            boolean abandon = dynamicObject.getBoolean("abandonstatus");
            if (abandon) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u62a5\u6279\u5931\u8d25\uff0c\u5df2\u4f5c\u5e9f\u5355\u636e\u4e0d\u80fd\u6267\u884c\u62a5\u6279\u64cd\u4f5c\u3002", (String)"InoutCollectApprovalValidate_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
                continue;
            }
            String approvalStatus = dynamicObject.getString("approvalstatus");
            if (StringUtils.equals((CharSequence)approvalStatus, (CharSequence)InoutCollectApprovalStatusEnum.NOT_APPROVAL.getCode())) continue;
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u62a5\u6279\u5931\u8d25\uff0c\u53ea\u6709\u672a\u62a5\u6279\u7684\u5355\u636e\u624d\u53ef\u4ee5\u6267\u884c\u62a5\u6279\u64cd\u4f5c\u3002", (String)"InoutCollectApprovalValidate_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
    }

    public boolean isAddBillNoForContent() {
        return true;
    }
}

