/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.inspection;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class InspectionConfigEnableValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("id");
        selector.add("bodysys");
        selector.add("inspectionscope");
        selector.add("inspectiontype");
        selector.add("number");
        selector.add("name");
        selector.add("enable");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        Set bodySysSet = Arrays.stream(extendedDataEntities).map(ExtendedDataEntity::getDataEntity).map(dy -> dy.getDynamicObject("bodysys").getPkValue()).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("bodysys", "in", bodySysSet);
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        String selectFields = String.join((CharSequence)",", "id", "name", "bodysys", "number", "inspectiontype", "inspectionscope");
        DynamicObject[] enableConfigList = TmcDataServiceHelper.load((String)"fpm_inspection_config", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        Map<String, List<DynamicObject>> enableConfigMap = Arrays.stream(enableConfigList).collect(Collectors.groupingBy(dy -> dy.getLong("bodysys.id") + dy.getString("inspectiontype") + dy.getString("inspectionscope")));
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            if ("1".equals(dataEntity.getString("enable"))) continue;
            String inspectionType = dataEntity.getString("inspectiontype");
            String inspectionScope = dataEntity.getString("inspectionscope");
            DynamicObject bodySys = dataEntity.getDynamicObject("bodysys");
            String key = bodySys.getLong("id") + inspectionType + inspectionScope;
            List<DynamicObject> enableConfigs = enableConfigMap.get(key);
            if (!CollectionUtils.isNotEmpty(enableConfigs)) continue;
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u3010%1$s\u3011\u7684\u914d\u7f6e\u542f\u7528\u5931\u8d25\uff0c\u7cfb\u7edf\u4e0d\u5141\u8bb8\u540c\u65f6\u542f\u7528\u591a\u4e2a\u5de1\u68c0\u7c7b\u578b\u53ca\u68c0\u67e5\u8303\u56f4\u4e00\u81f4\u7684\u914d\u7f6e\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"InspectionConfigEnableValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), dataEntity.getString("number")));
        }
    }
}

