/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.report;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AdjustType;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.report.AdjustAmtInfo;
import kd.tmc.fpm.business.domain.model.report.PlanChangeRecord;
import kd.tmc.fpm.business.domain.model.report.PlanChangeReport;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportChangeData;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.helper.ReportChangeCheckHelper;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.IPlanChangeRepository;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.mvc.repository.impl.PlanChangeRepository;
import kd.tmc.fpm.business.mvc.repository.impl.ReportRepository;
import org.apache.commons.collections.CollectionUtils;

public class ReportChangeSubmitValidator
extends AbstractTmcBizOppValidator {
    private Log logger = LogFactory.getLog(ReportChangeSubmitValidator.class);
    private IPlanChangeRepository repository = new PlanChangeRepository();
    private IReportRepository reportRepository = new ReportRepository();
    private IDimensionRepository dimensionRepository = new DimensionRepository();

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        Set<Long> idSet = Arrays.stream(dataEntity).map(item -> item.getBillPkId()).map(id -> (Long)id).collect(Collectors.toSet());
        List<PlanChangeRecord> records = this.repository.load(idSet, true);
        Map changeRecordMap = records.stream().collect(Collectors.toMap(PlanChangeRecord::getId, Function.identity(), (a, b) -> a));
        Set<Long> mainReportIds = records.stream().flatMap(record -> record.getChangeReportList().stream()).filter(report -> report.getTemplate().isMainTable()).map(PlanChangeReport::getReportId).collect(Collectors.toSet());
        List<Report> reports = this.reportRepository.loadReport(mainReportIds);
        Map<Long, Report> reportMap = reports.stream().collect(Collectors.toMap(Report::getId, Function.identity()));
        HashMap<Long, FundPlanSystem> systemMap = new HashMap<Long, FundPlanSystem>(reports.size());
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            ReportTemplate firstReportTemplate;
            boolean nonExistManualInputIfOnlyAdjustMainTable;
            Object billPkId = extendedDataEntity.getBillPkId();
            PlanChangeRecord planChangeRecord = (PlanChangeRecord)changeRecordMap.get(billPkId);
            boolean bl = nonExistManualInputIfOnlyAdjustMainTable = planChangeRecord.getOriginalReportIdList().size() == 1 && (firstReportTemplate = planChangeRecord.getChangeReportList().get(0).getTemplate()).isMainTable() && firstReportTemplate.getAccountSettings().stream().noneMatch(item -> ReportInputType.MANUAL_INPUT == item.getInputType());
            if (nonExistManualInputIfOnlyAdjustMainTable) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u63d0\u4ea4\u5931\u8d25\uff0c\u4e3b\u8868\u6ca1\u6709\u624b\u5de5\u5f55\u5165\u9879\u8ba1\u5212\u79d1\u76ee\u65f6\uff0c\u4e0d\u53ef\u53ea\u8c03\u6574\u4e3b\u8868\u3002\u8bf7\u5220\u9664\u8ba1\u5212\u8c03\u6574\u5355\u540e\uff0c\u91cd\u65b0\u8c03\u6574\u4e3b\u8868\u548c\u5b50\u8868\u3002", (String)"ReportChangeSubmitValidator_2", (String)"tmc-fpm-business", (Object[])new Object[0]), planChangeRecord.getNumber()));
                continue;
            }
            boolean nonExistAdjustData = planChangeRecord.getChangeReportList().stream().anyMatch(rt -> EmptyUtil.isEmpty(rt.getReportDataList()) || rt.getReportDataList().stream().noneMatch(rd -> !rd.isAuxiliaryInfo()));
            if (nonExistAdjustData) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\u3002\u8bf7\u5148\u5f55\u5165\u672c\u6b21\u8c03\u6574\u989d\u5ea6\u3002", (String)"ReportChangeSubmitValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
                continue;
            }
            if (planChangeRecord.getStatus() == BillStatus.STAGE && this.checkAdjustedAvailableAmt(planChangeRecord, extendedDataEntity, reportMap, systemMap) && this.checkFlowInOrOutSum(planChangeRecord, extendedDataEntity, systemMap)) continue;
        }
    }

    private boolean checkFlowInOrOutSum(PlanChangeRecord planChangeRecord, ExtendedDataEntity extendedDataEntity, Map<Long, FundPlanSystem> systemMap) {
        List<AdjustAmtInfo> adjustAmtInfoList = planChangeRecord.getAdjustAmtInfoList();
        if (CollectionUtils.isEmpty(adjustAmtInfoList)) {
            return true;
        }
        if (planChangeRecord.getAdjustType() != AdjustType.AMOUNT_WITHIN) {
            return true;
        }
        List adjustAmtInfos = adjustAmtInfoList.stream().filter(adjustAmtInfo -> EmptyUtil.isNoEmpty((Long)adjustAmtInfo.getCombinationKey().getCustomPageDimensionMember1())).collect(Collectors.toList());
        FundPlanSystem fundPlanSystem = systemMap.computeIfAbsent(planChangeRecord.getSystemId(), key -> this.dimensionRepository.loadSystem(planChangeRecord.getSystemId()));
        if (CollectionUtils.isEmpty(adjustAmtInfos)) {
            for (AdjustAmtInfo adjustAmtInfo2 : adjustAmtInfoList) {
                if (!this.checkInAndOutAmt(planChangeRecord, extendedDataEntity, adjustAmtInfo2, fundPlanSystem)) continue;
                return false;
            }
            return true;
        }
        for (AdjustAmtInfo adjustAmtInfo3 : adjustAmtInfoList) {
            if (StringUtils.isBlank((CharSequence)planChangeRecord.getPageDimensionType1()) || !this.checkInAndOutAmt(planChangeRecord, extendedDataEntity, adjustAmtInfo3, fundPlanSystem)) continue;
            return false;
        }
        return true;
    }

    private boolean checkInAndOutAmt(PlanChangeRecord planChangeRecord, ExtendedDataEntity extendedDataEntity, AdjustAmtInfo adjustAmtInfo, FundPlanSystem fundPlanSystem) {
        if (!this.isZero(adjustAmtInfo.getAdjustSumAmtIn()) || !this.isZero(adjustAmtInfo.getAdjustSumAmtOut())) {
            String dimensionName = this.getDimensionName(planChangeRecord, adjustAmtInfo.getCombinationKey().getCurrencyId(), fundPlanSystem);
            String errorMessage = String.format(ResManager.loadKDString((String)"\u989d\u5ea6\u5185\u8c03\u5242\u7684\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u8bf7\u786e\u8ba4\u8ba1\u5212\u8c03\u6574\u5355\u201c%1$s\u201d\u3001\u201c%2$s\u201d\u4e0b\u7684\u989d\u5ea6\u8c03\u6574\u4fe1\u606f\uff0c\u786e\u4fdd\u6d41\u5165\u8c03\u6574\u603b\u989d\uff08%3$s\uff09\u3001\u6d41\u51fa\u8c03\u6574\u603b\u989d\uff08%4$s\uff09\u5fc5\u987b\u4e3a0\u3002", (String)"ReportChangeSubmitValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]), planChangeRecord.getNumber(), dimensionName, this.getAmtValue(adjustAmtInfo.getAdjustSumAmtIn()), this.getAmtValue(adjustAmtInfo.getAdjustSumAmtOut()));
            this.addErrorMessage(extendedDataEntity, errorMessage);
            return true;
        }
        return false;
    }

    private String getAmtValue(BigDecimal bigDecimal) {
        if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
            return "0";
        }
        return bigDecimal.divide(BigDecimal.ONE, 2, RoundingMode.HALF_UP).toString();
    }

    private String getDimensionName(PlanChangeRecord planChangeRecord, Long currencyId, FundPlanSystem fundPlanSystem) {
        Dimension dimension;
        Optional<DimMember> first;
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)planChangeRecord.getPageDimensionType1())) {
            sb.append(fundPlanSystem.getMainDimensionByDimType(DimensionType.getDimsionByNumber(planChangeRecord.getPageDimensionType1())).getName());
        }
        if (StringUtils.isNotBlank((CharSequence)planChangeRecord.getPageDimensionType2())) {
            sb.append("/").append(fundPlanSystem.getMainDimensionByDimType(DimensionType.getDimsionByNumber(planChangeRecord.getPageDimensionType2())).getName());
        }
        if ((first = (dimension = fundPlanSystem.getMainDimensionByDimType(DimensionType.CURRENCY)).getMemberList().stream().filter(dimMember -> Objects.equals(dimMember.getId(), currencyId)).findFirst()).isPresent()) {
            if (sb.length() != 0) {
                sb.append("/");
            }
            sb.append(first.get().getName());
        }
        return sb.toString();
    }

    private boolean isZero(BigDecimal bigDecimal) {
        return BigDecimal.ZERO.compareTo(bigDecimal) == 0;
    }

    public boolean isAddBillNoForContent() {
        return false;
    }

    private boolean checkAdjustedAvailableAmt(PlanChangeRecord planChangeRecord, ExtendedDataEntity extendedDataEntity, Map<Long, Report> reportMap, Map<Long, FundPlanSystem> systemMap) {
        FundPlanSystem fundPlanSystem;
        Report report2;
        List<PlanChangeReport> changeReportList = planChangeRecord.getChangeReportList();
        PlanChangeReport planChangeReport = changeReportList.stream().filter(report -> report.getTemplate().isMainTable()).findFirst().get();
        FpmOperateResult<Void> result = ReportChangeCheckHelper.checkAdjustedAvailableAmt(planChangeRecord, planChangeReport, report2 = reportMap.get(planChangeReport.getReportId()), fundPlanSystem = systemMap.computeIfAbsent(report2.getSystemId(), key -> this.dimensionRepository.loadSystem(report2.getSystemId())));
        if (result.isSuccess()) {
            return true;
        }
        this.addErrorMessage(extendedDataEntity, result.getMessageList().stream().collect(Collectors.joining(";")));
        return false;
    }

    public static int getScore(TemplateDim templateDim) {
        switch (templateDim.getDimType()) {
            case SUBJECTS: {
                return 0;
            }
            case CURRENCY: {
                return 1;
            }
            case PERIOD: {
                return 3;
            }
            case COMPANY: {
                return 4;
            }
            case SETTLEMENT_TYPE: {
                return 5;
            }
        }
        return 10;
    }

    public static class ReportCheckData
    extends ReportChangeData {
        public ReportCheckData(ReportData reportChangeData) {
            super(reportChangeData);
        }

        @Override
        public BigDecimal getPlanAmt() {
            return this.getAdjustedPlanAmt();
        }

        @Override
        public Long getId() {
            return this.getOriginalReportDataId();
        }
    }
}

