/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.report;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fpm.business.helper.ReportMutexHelper;
import kd.tmc.fpm.common.enums.ReportPlanTypeEnum;

public class ReportPlanAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("informant");
        selector.add("initflag");
        selector.add("bodysys.id");
        selector.add("reportperiod.reporttype.id");
        selector.add("reportperiod.id");
        selector.add("name");
        selector.add("declaredeadline");
        selector.add("template.templatetype");
        selector.add("template.ismaintable");
        selector.add("reportorg.id");
        selector.add("templatebak.templateid");
        selector.add("reportperiod.id");
        selector.add("reportplantype");
        selector.add("parenttemplate");
        selector.add("billno");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        if (this.isManySystem(extendedDataEntities)) {
            return;
        }
        for (ExtendedDataEntity dataEntity : extendedDataEntities) {
            QFilter qFilter;
            DynamicObject parentReport;
            DynamicObject dy = dataEntity.getDataEntity();
            if (!Objects.equals(ReportPlanTypeEnum.REPORTPLAN.getValue(), dy.getString("reportplantype"))) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5ba1\u6838\u5931\u8d25\uff0c\u62a5\u8868\u3010%1$s\u3011\u4e0d\u662f\u8ba1\u5212\u7f16\u5236\u7c7b\u578b\u3002", (String)"ReportPlanAuditValidator_2", (String)"tmc-fpm-business", (Object[])new Object[0]), dy.getString("billno")));
                continue;
            }
            if (dy.getBoolean("template.ismaintable") || (parentReport = QueryServiceHelper.queryOne((String)"fpm_report", (String)"id,name", (QFilter[])(qFilter = new QFilter("template.id", "=", dy.get("parenttemplate.id")).and("reportperiod.id", "=", dy.get("reportperiod.id")).and("reportorg.id", "=", dy.get("reportorg.id"))).toArray())) == null || !ReportMutexHelper.mainReportLockValidator(parentReport.getLong("id"))) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u6240\u5bf9\u5e94\u7684\u4e3b\u8868\u201c%2$s\u201d\u6b63\u5728\u7f16\u8f91\u4e2d\uff0c\u9000\u51fa\u4e3b\u8868\u7f16\u8f91\u624d\u80fd\u5ba1\u6838\u672c\u62a5\u8868\u3002", (String)"ReportPlanAuditValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), dy.getString("name"), parentReport.getString("name")));
        }
    }

    private boolean isManySystem(ExtendedDataEntity[] extendedDataEntities) {
        Set systemIdSet = Arrays.stream(extendedDataEntities).map(ExtendedDataEntity::getDataEntity).map(dy -> dy.getLong("bodysys.id")).collect(Collectors.toSet());
        if (systemIdSet.size() > 1) {
            for (ExtendedDataEntity dataEntity : extendedDataEntities) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u591a\u4e2a\u62a5\u8868\u5ba1\u6838\u5fc5\u987b\u5904\u4e8e\u540c\u4e00\u4f53\u7cfb\u4e0b\u3002", (String)"ReportPlanAuditValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
            return true;
        }
        return false;
    }
}

