/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.helper.ReportMutexHelper;
import kd.tmc.fpm.business.mvc.repository.impl.DimMemberRepository;
import kd.tmc.fpm.business.mvc.repository.impl.ReportRepository;
import kd.tmc.fpm.business.mvc.repository.impl.SumPlanRepository;
import kd.tmc.fpm.common.enums.ReportPlanTypeEnum;
import kd.tmc.fpm.common.helper.StringHelper;
import org.apache.commons.collections.CollectionUtils;

public class ReportPlanSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("informant");
        selector.add("initflag");
        selector.add("bodysys.id");
        selector.add("reportperiod.reporttype.id");
        selector.add("reportperiod.id");
        selector.add("name");
        selector.add("declaredeadline");
        selector.add("template.templatetype");
        selector.add("template.ismaintable");
        selector.add("reportorg.id");
        selector.add("templatebak.templateid");
        selector.add("reportperiod.id");
        selector.add("reportplantype");
        selector.add("billno");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        if (this.isManySystem(extendedDataEntities)) {
            return;
        }
        DynamicObject reportPlan = extendedDataEntities[0].getDataEntity();
        long systemId = reportPlan.getLong("bodysys.id");
        long reportTypeId = reportPlan.getLong("reportperiod.reporttype.id");
        SumPlanParamConfig sumPlanParamConfig = new SumPlanRepository().loadSumConfigBySystem(systemId, reportTypeId);
        for (ExtendedDataEntity dataEntity : extendedDataEntities) {
            QFilter qFilter;
            boolean isExist;
            QFilter qFilter2;
            DynamicObjectCollection unAuditSubReportList;
            Long parentId;
            DynamicObject dy = dataEntity.getDataEntity();
            if (!Objects.equals(ReportPlanTypeEnum.REPORTPLAN.getValue(), dy.getString("reportplantype"))) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u62a5\u8868\u3010%1$s\u3011\u4e0d\u662f\u8ba1\u5212\u7f16\u5236\u7c7b\u578b\u3002", (String)"ReportPlanSubmitValidator_6", (String)"tmc-fpm-business", (Object[])new Object[0]), dy.getString("billno")));
                continue;
            }
            Date closeDate = dy.getDate("declaredeadline");
            if (closeDate.compareTo(new Date()) < 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5df2\u8d85\u8fc7\u3010%1$s\u3011\u7684\u7533\u62a5\u622a\u6b62\u65f6\u95f4\uff0c\u6682\u4e0d\u5141\u8bb8\u63d0\u4ea4\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u5904\u7406", (String)"ReportPlanSubmitValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]), dy.getString("name")));
                continue;
            }
            boolean isMainTable = dy.getBoolean("template.ismaintable");
            if (!isMainTable && this.mainReportLockValidator(parentId = new ReportRepository().queryParentReportId(dy.getLong("id"))).booleanValue()) {
                String reportName = dy.getString("name");
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"fpm_report", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)parentId)});
                String userName = ReportMutexHelper.getMutexUserNameByOpKey(StringHelper.getStringValue((Object)parentId), "lockMainReport", "fpm_report");
                String mainReportName = dynamicObject == null ? "" : dynamicObject.getString("name");
                String message = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u6240\u5bf9\u5e94\u7684\u4e3b\u8868\u201c%2$s\u201d\u6b63\u5728\u7f16\u8f91\u4e2d\uff0c\u9000\u51fa\u4e3b\u8868\u7f16\u8f91\u624d\u80fd\u63d0\u4ea4\u672c\u62a5\u8868\u3002", (String)"ReportPlanSubmitValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), dy.getString("name"), mainReportName);
                if (EmptyUtil.isNoEmpty((String)userName)) {
                    message = String.format(ResManager.loadKDString((String)"\u7528\u6237\u3010%1$s\u3011\u6b63\u5728\u7f16\u8f91\u3010%2$s\u3011\u6240\u5bf9\u5e94\u7684\u4e3b\u8868\u3010%3$s\u3011\uff0c\u9000\u51fa\u4e3b\u8868\u7f16\u8f91\u65b9\u53ef\u63d0\u4ea4\u672c\u62a5\u8868\uff01", (String)"ReportPlanSubmitValidator_4", (String)"tmc-fpm-business", (Object[])new Object[0]), userName, reportName, mainReportName);
                }
                this.addErrorMessage(dataEntity, message);
                continue;
            }
            if (dy.getBoolean("template.ismaintable") && !EmptyUtil.isEmpty((DynamicObjectCollection)(unAuditSubReportList = QueryServiceHelper.query((String)"fpm_report", (String)"name", (QFilter[])(qFilter2 = new QFilter("parenttemplate.id", "=", dy.get("templatebak.templateid")).and("reportperiod", "=", dy.get("reportperiod.id")).and("reportorg", "=", dy.get("reportorg.id")).and("billstatus", "!=", (Object)BillStatus.AUDITED.getNumber())).toArray())))) {
                String subNameList = unAuditSubReportList.stream().map(o -> o.getString("name")).collect(Collectors.joining(","));
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u6240\u5bf9\u5e94\u7684%2$s\u5c1a\u672a\u5ba1\u6838\uff0c\u8bf7\u786e\u8ba4\u6240\u6709\u5b50\u8868\u5747\u5df2\u5ba1\u6838\u540e\uff0c\u65b9\u53ef\u63d0\u4ea4\u672c\u62a5\u8868\uff01", (String)"ReportPlanSubmitValidator_2", (String)"tmc-fpm-business", (Object[])new Object[0]), dy.getString("name"), subNameList));
                continue;
            }
            if (sumPlanParamConfig == null) continue;
            List<SumPlanParamConfigInfo> configInfoList = sumPlanParamConfig.getConfigInfoList();
            Map<Long, Boolean> configInfoMap = configInfoList.stream().collect(Collectors.toMap(SumPlanParamConfigInfo::getOrgMemberId, SumPlanParamConfigInfo::isSumAuditNode));
            Long reportOrgId = dy.getLong("reportorg.id");
            OrgMember reportOrg = (OrgMember)new DimMemberRepository().getOrgDimMembers(Collections.singletonList(reportOrgId)).get(reportOrgId);
            List<DimMember> allParentMember = reportOrg.getAllParentMember();
            List parentMemberIdList = allParentMember.stream().filter(item -> (Boolean)configInfoMap.get(item.getId())).map(DimMember::getId).collect(Collectors.toList());
            if (!CollectionUtils.isNotEmpty(parentMemberIdList) || !(isExist = QueryServiceHelper.exists((String)"fpm_report", (QFilter[])(qFilter = new QFilter("reportorg", "in", parentMemberIdList).and("reportperiod", "=", (Object)dy.getLong("reportperiod.id")).and("reportplantype", "=", (Object)dy.getString("reportplantype")).and("billstatus", "=", (Object)BillStatus.COMMITTED.getNumber())).toArray()))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0a\u7ea7\u6c47\u603b\u5355\u636e\u5df2\u63d0\u4ea4\uff0c\u4e0b\u7ea7\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"ReportPlanSubmitValidator_3", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean mainReportLockValidator(Long mainReportId) {
        ArrayList<String> reportIdS = new ArrayList<String>(1);
        ArrayList<String> requestSuccessIds = new ArrayList<String>(1);
        ArrayList<String> requestFailIds = new ArrayList<String>(1);
        reportIdS.add(mainReportId.toString());
        try {
            Map request = MutexServiceHelper.batchRequest(reportIdS, (String)"fpm_report", (String)"lockMainReport");
            for (Map.Entry entry : request.entrySet()) {
                String key = (String)entry.getKey();
                if (((Boolean)entry.getValue()).booleanValue()) {
                    requestSuccessIds.add(key);
                    continue;
                }
                requestFailIds.add(key);
            }
            if (requestFailIds.size() > 0) {
                Boolean bl = true;
                return bl;
            }
        }
        finally {
            MutexServiceHelper.batchRelease(requestSuccessIds, (String)"fpm_report", (String)"lockMainReport");
        }
        return false;
    }

    private boolean isManySystem(ExtendedDataEntity[] extendedDataEntities) {
        Set systemIdSet = Arrays.stream(extendedDataEntities).map(ExtendedDataEntity::getDataEntity).map(dy -> dy.getLong("bodysys.id")).collect(Collectors.toSet());
        if (systemIdSet.size() > 1) {
            for (ExtendedDataEntity dataEntity : extendedDataEntities) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u591a\u4e2a\u62a5\u8868\u63d0\u4ea4\u5fc5\u987b\u5904\u4e8e\u540c\u4e00\u4f53\u7cfb\u4e0b\u3002", (String)"ReportPlanSubmitValidator_5", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
            return true;
        }
        return false;
    }
}

