/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.report;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.enums.ReportProcessStatus;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.helper.ReportMutexHelper;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.common.enums.BillStatusEnum;
import kd.tmc.fpm.common.enums.ReportPlanChangeStatusEnum;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTracer;
import org.apache.commons.collections4.CollectionUtils;

public class ReportPlanUnAuditValidator
extends AbstractTmcBizOppValidator {
    private IDimensionRepository dimensionRepository = FpmServiceFactory.getBizService(IDimensionRepository.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("id");
        selector.add("changestatus");
        selector.add("reportperiod");
        selector.add("bodysys");
        selector.add("billno");
        selector.add("reportorg");
        selector.add("templatebak");
        selector.add("declaredeadline");
        selector.add("name");
        selector.add("parenttemplate.id");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        try (IFpmTracer tracer = IFpmTracer.getInstance();){
            try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan(ReportPlanUnAuditValidator.class.getSimpleName());){
                span.addTag("UnAuditValidator-getSumPlanMap");
                Map<String, Long> sumMap = this.getSumPlanMap(extendedDataEntities);
                List reportId = Arrays.stream(extendedDataEntities).map(i -> i.getDataEntity().getLong("id")).collect(Collectors.toList());
                Set existExecIdSet = null;
                DynamicObjectCollection existExecId = QueryServiceHelper.query((String)"fpm_execbiasanalys", (String)"sourcebill", (QFilter[])new QFilter[]{new QFilter("sourcebill", "in", reportId)});
                if (CollectionUtils.isNotEmpty((Collection)existExecId)) {
                    existExecIdSet = existExecId.stream().map(item -> item.getLong("sourcebill")).collect(Collectors.toSet());
                }
                HashMap map = new HashMap(16);
                HashMap dimensionMap = Maps.newHashMapWithExpectedSize((int)4);
                for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
                    DynamicObject templateObj;
                    DimMember dimMemberByDimId;
                    String errorMessage;
                    span.addTag("UnAuditValidator-forI");
                    DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                    String changeStatus = dataEntity.getString("changestatus");
                    if (ReportPlanChangeStatusEnum.CHANGING.getValue().equals(changeStatus)) {
                        errorMessage = ResManager.loadKDString((String)"\u8ba1\u5212\u8c03\u6574\u4e2d\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"ReportPlanUnAuditValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]);
                        this.addErrorMessage(extendedDataEntity, errorMessage);
                    }
                    if (CollectionUtils.isNotEmpty(existExecIdSet) && existExecIdSet.contains(dataEntity.getLong("id"))) {
                        errorMessage = ResManager.loadKDString((String)"\u5df2\u751f\u6210\u6267\u884c\u8ba1\u5212\u504f\u5dee\u5206\u6790\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"ReportPlanUnAuditValidator_4", (String)"tmc-fpm-business", (Object[])new Object[0]);
                        this.addErrorMessage(extendedDataEntity, errorMessage);
                    }
                    span.addTag("UnAuditValidator-loadDimension");
                    Dimension orgDim = dimensionMap.computeIfAbsent(dataEntity.getLong("reportorg.dimension.id"), val -> this.dimensionRepository.loadDimension(dataEntity.getLong("reportorg.dimension.id"), DimensionType.ORG));
                    ArrayList list = new ArrayList(16);
                    if (orgDim != null && (dimMemberByDimId = orgDim.getDimMemberByDimId(DimMember.class, dataEntity.getLong("reportorg.id"))) != null) {
                        dimMemberByDimId.getAllParentMember().forEach(e -> {
                            String string = dataEntity.getString("reportperiod.id") + "." + e.getId();
                            if (null != sumMap.get(string)) {
                                list.add(sumMap.get(string));
                            }
                        });
                    }
                    if (CollectionUtils.isEmpty(list) || !Objects.nonNull(templateObj = dataEntity.getDynamicObject("templatebak"))) continue;
                    TemplateType templateType = TemplateType.getByNumber(templateObj.getString("templatetype"));
                    Boolean isMainTable = templateObj.getBoolean("ismaintable");
                    if (!Objects.nonNull((Object)templateType) || !templateType.isFixed() || !isMainTable.booleanValue()) continue;
                    map.put(extendedDataEntity, list);
                }
                if (map.size() > 0) {
                    span.addTag("UnAuditValidator-loadSumReport");
                    ArrayList list = new ArrayList(16);
                    map.entrySet().stream().forEach(e -> list.addAll((Collection)e.getValue()));
                    QFilter qFilter = new QFilter("originalreportids", "in", list.stream().map(String::valueOf).collect(Collectors.toList()));
                    DynamicObjectCollection load = QueryServiceHelper.query((String)"fpm_reportplansum", (String)String.join((CharSequence)",", "id", "originalreportids", "billno", "billstatus"), (QFilter[])qFilter.toArray());
                    Map<Long, String> sumReportBillNoMap = load.stream().filter(e -> !BillStatusEnum.STAGE.getCode().equals(e.getString("billstatus"))).collect(Collectors.toMap(e -> e.getLong("originalreportids"), e1 -> e1.getString("billno")));
                    Map<Long, Long> originIdMap = load.stream().collect(Collectors.toMap(e -> e.getLong("originalreportids"), e1 -> e1.getLong("id")));
                    for (Map.Entry data : map.entrySet()) {
                        ArrayList collect = new ArrayList();
                        ((List)data.getValue()).forEach(e -> {
                            if (sumReportBillNoMap.containsKey(e)) {
                                collect.add(sumReportBillNoMap.get(e));
                            }
                        });
                        if (CollectionUtils.isNotEmpty(collect)) {
                            this.addErrorMessage((ExtendedDataEntity)data.getKey(), String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8ba1\u5212\u7f16\u5236\u5355\u636e\u201c%1$s\u201d\u6240\u5173\u8054\u7684\u4e0a\u7ea7\u6c47\u603b\u5355\u636e\u201c%2$s\u201d\u5b58\u5728\u975e\u6682\u5b58\u72b6\u6001\uff0c\u6682\u4e0d\u5141\u8bb8\u8fdb\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"ReportPlanUnAuditValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]), ((ExtendedDataEntity)data.getKey()).getDataEntity().getString("billno"), collect));
                            continue;
                        }
                        List idList = ((List)data.getValue()).stream().map(originIdMap::get).collect(Collectors.toList());
                        QFilter approvedFilter = new QFilter("reportid", "in", idList);
                        if (!TmcDataServiceHelper.exists((String)"fpm_approvedplanquota", (QFilter[])new QFilter[]{approvedFilter})) continue;
                        String errorMessage = ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u4e0a\u7ea7\u6c47\u603b\u7f16\u62a5\u4e3b\u4f53\u672c\u671f\u5df2\u8fdb\u884c\u4e86\u4e0b\u7ea7\u8ba1\u5212\u989d\u5ea6\u7684\u6838\u5b9a\u4fee\u6539\uff0c\u6682\u4e0d\u652f\u6301\u53cd\u5ba1\u6838\u5904\u7406\uff0c\u8bf7\u786e\u8ba4\u3002\u5176\u4e2d\uff0c\u82e5\u9700\u8981\u8c03\u6574\u4e0a\u62a5\u989d\u5ea6\uff0c\u53ef\u5728\u4e0a\u7ea7\u6c47\u603b\u5c42\u7ea7\u8fdb\u884c\u76f4\u63a5\u6838\u5b9a\u4fee\u6539\u3002", (String)"ReportPlanUnAuditValidator_2", (String)"tmc-fpm-business", (Object[])new Object[0]);
                        this.addErrorMessage((ExtendedDataEntity)data.getKey(), errorMessage);
                    }
                }
                this.validatePositiveTxLock(extendedDataEntities);
                this.validateOther(extendedDataEntities);
            }
            tracer.print();
        }
    }

    private void validateOther(ExtendedDataEntity[] extendedDataEntities) {
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            if (this.getFalseDataEntities().contains(extendedDataEntity)) continue;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            Date closeDate = dataEntity.getDate("declaredeadline");
            if (closeDate.compareTo(new Date()) < 0) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u65f6\u95f4\u5df2\u8d85\u8fc7\u8d44\u91d1\u8ba1\u5212\u5355\u636e\u7684\u7533\u62a5\u622a\u6b62\u65f6\u95f4\uff0c\u975e\u201d\u53ef\u7533\u62a5\u201c\u72b6\u6001\u4e0b\u8d44\u91d1\u8ba1\u5212\u8bb0\u5f55\u6682\u4e0d\u652f\u6301\u53cd\u5ba1\u6838\u64cd\u4f5c\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\uff01", (String)"ReportPlanUnAuditValidator_11", (String)"tmc-fpm-business", (Object[])new Object[0]));
                continue;
            }
            boolean mainTable = dataEntity.getBoolean(String.join((CharSequence)".", "templatebak", "ismaintable"));
            if (!mainTable) {
                Report mainReport = this.getMainReport(dataEntity);
                if (mainReport == null) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u62a5\u8868\u3010%1$s\u3011\u7684\u4e3b\u8868\u6570\u636e\u5df2\u5220\u9664\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ReportPlanUnAuditValidator_10", (String)"tmc-fpm-business", (Object[])new Object[0]), dataEntity.getString("name")));
                    continue;
                }
                String message = this.subReportUnAuditCheck(dataEntity, mainReport);
                if (EmptyUtil.isNoEmpty((String)message)) {
                    this.addErrorMessage(extendedDataEntity, message);
                    continue;
                }
            }
            long reportId = dataEntity.getLong("id");
            try (DataSet dataSet = DB.queryDataSet((String)"validateControlRecordExists", (DBRoute)DBRouteConst.TMC, (String)"select top 1 a.fid from t_fpm_executeplan a where exists (select fentryid from t_fpm_reportdatamain b where a.freportdataid=b.fentryid and b.fid=?) and a.fdeleteflag='0'", (Object[])new Object[]{reportId});){
                if (!dataSet.hasNext()) continue;
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u62a5\u8868\u5df2\u5b58\u5728\u9884\u5360\u6216\u5b9e\u5360\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"ReportPlanUnAuditValidator_12", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
        }
    }

    private String subReportUnAuditCheck(DynamicObject dataEntity, Report mainReport) {
        String reportName = dataEntity.getString("name");
        if (ReportMutexHelper.mainReportLockValidator(mainReport.getId())) {
            return String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u6240\u5bf9\u5e94\u7684%2$s\u4e3b\u8868\u6b63\u5728\u7f16\u8f91\u4e2d\uff0c\u9000\u51fa\u4e3b\u8868\u7f16\u8f91\u65b9\u53ef\u53cd\u5ba1\u6838\u672c\u62a5\u8868\uff01", (String)"ReportPlanUnAuditValidator_13", (String)"tmc-fpm-business", (Object[])new Object[0]), reportName, mainReport.getName());
        }
        if (mainReport.getProcessStatus() == ReportProcessStatus.SUBMIT || mainReport.getProcessStatus() == ReportProcessStatus.AUDIT) {
            return String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u6240\u5173\u8054\u7684\u4e3b\u8868\u3010%2$s\u3011\u5df2\u63d0\u4ea4/\u5df2\u5ba1\u6838\uff0c\u8bf7\u5148\u64a4\u9500\u5bf9\u5e94\u7684\u4e3b\u8868\u540e\uff0c\u518d\u505a\u53cd\u5ba1\u6838\u5904\u7406\u3002", (String)"ReportPlanUnAuditValidator_14", (String)"tmc-fpm-business", (Object[])new Object[0]), reportName, mainReport.getName());
        }
        if (mainReport.getReportStatus() == ReportStatus.ENABLE) {
            return String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u6240\u5173\u8054\u7684\u4e3b\u8868\u3010%2$s\u3011\u8ba1\u5212\u72b6\u6001\u4e3a\u201c\u5df2\u751f\u6548\u201d\uff0c\u8bf7\u5148\u53cd\u5ba1\u6838\u5bf9\u5e94\u7684\u4e3b\u8868\u540e\uff0c\u518d\u505a\u53cd\u5ba1\u6838\u5904\u7406\u3002", (String)"ReportPlanUnAuditValidator_15", (String)"tmc-fpm-business", (Object[])new Object[0]), reportName, mainReport.getName());
        }
        return "";
    }

    private Report getMainReport(DynamicObject dataEntity) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(3);
        qFilterList.add(new QFilter("reportorg.id", "=", (Object)dataEntity.getLong("reportorg.id")));
        qFilterList.add(new QFilter("reportperiod.id", "=", (Object)dataEntity.getLong("reportperiod.id")));
        qFilterList.add(new QFilter("template.id", "=", (Object)dataEntity.getLong("parenttemplate.id")));
        String selectFields = String.join((CharSequence)",", "id", "billstatus", "planstatus", "name");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"fpm_report", (String)selectFields, (QFilter[])qFilterList.toArray(new QFilter[0]));
        if (dynamicObject == null) {
            return null;
        }
        Report mainReport = new Report();
        mainReport.setId(dynamicObject.getLong("id"));
        mainReport.setReportStatus(ReportStatus.getByVal(dynamicObject.getString("planstatus")));
        mainReport.setProcessStatus(ReportProcessStatus.getStatusByVal(dynamicObject.getString("billstatus")));
        mainReport.setName(dynamicObject.getString("name"));
        return mainReport;
    }

    private Map<String, Long> getSumPlanMap(ExtendedDataEntity[] extendedDataEntities) {
        Set collect = Arrays.stream(extendedDataEntities).map(e -> e.getDataEntity().getLong("reportperiod.id")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("bodysys", "=", (Object)extendedDataEntities[0].getDataEntity().getLong("bodysys.id"));
        qFilter.and("reportperiod", "in", collect);
        qFilter.and(new QFilter("reportplantype", "=", (Object)ReportPlanType.SUMPLAN.getNumber()));
        DynamicObjectCollection load = QueryServiceHelper.query((String)"fpm_report_process", (String)String.join((CharSequence)",", "id", "reportperiod.id", "reportorg.id"), (QFilter[])qFilter.toArray());
        HashMap<String, Long> map = new HashMap<String, Long>(16);
        for (DynamicObject dy : load) {
            String string = dy.getString("reportperiod.id") + "." + dy.getString("reportorg.id");
            map.put(string, dy.getLong("id"));
        }
        return map;
    }

    private void validatePositiveTxLock(ExtendedDataEntity[] extendedDataEntities) {
        List businessIdList = Arrays.stream(extendedDataEntities).map(ExtendedDataEntity::getDataEntity).map(dataEntity -> dataEntity.getLong("id")).map(String::valueOf).collect(Collectors.toList());
        if (businessIdList.isEmpty()) {
            return;
        }
        List lockBusinessIds = TxCheckUtil.loadUnfinishedTx(businessIdList);
        if (!lockBusinessIds.isEmpty()) {
            HashSet lockBusinessIdSet = new HashSet(lockBusinessIds);
            for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
                DynamicObject dataEntity2 = extendedDataEntity.getDataEntity();
                Long reportId = dataEntity2.getLong("id");
                if (!lockBusinessIdSet.contains(String.valueOf(reportId))) continue;
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8ba1\u5212\u7f16\u5236\u5355\u636e %1$s \u8fd8\u5728\u5206\u5e03\u5f0f\u4e8b\u52a1\u4e2d\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"ReportPlanUnAuditValidator_3", (String)"tmc-fpm-business", (Object[])new Object[0]), dataEntity2.getString("billno")));
            }
        }
    }
}

