/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.report;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.business.domain.enums.ReportProcessStatus;
import kd.tmc.fpm.common.enums.DimsionEnums;
import org.apache.commons.collections.CollectionUtils;

public class ReportProcessDeleteValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billno");
        selector.add("billstatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity data : extendedDataEntities) {
            List<String> nonSavaSameLevelReportBillNos;
            String errorMsg;
            DynamicObject reportProcess = data.getDataEntity();
            String billNo = reportProcess.getString("billno");
            String billStatus = reportProcess.getString("billstatus");
            if (!ReportProcessStatus.SAVE.getValue().equals(billStatus)) {
                String errorMsg2 = String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u5355\u636e\u201c%s\u201d\u4e0d\u662f\u6682\u5b58\u72b6\u6001\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"ReportProcessDeleteValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), billNo);
                this.addErrorMessage(data, errorMsg2);
                continue;
            }
            DynamicObject reportPlan = TmcDataServiceHelper.loadSingle((Object)reportProcess.getPkValue(), (String)"fpm_report");
            List<String> nonSaveSubReportBillNos = this.getNonSaveSubReportBillNos(reportPlan);
            if (nonSaveSubReportBillNos != null && nonSaveSubReportBillNos.size() > 0) {
                String nonSaveSubReportBillNoStr = String.join((CharSequence)"\uff0c", nonSaveSubReportBillNos);
                String errorMsg3 = String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u672c\u6b21\u64cd\u4f5c\u5c06\u4f1a\u8054\u52a8\u5220\u9664\u540c\u4e00\u7f16\u62a5\u4e3b\u4f53\u4e0b\u7684\u4e3b\u5b50\u8868\u5173\u8054\u5355\u636e\u3002\u5355\u636e\u201c%1$s\u201d\u5173\u8054\u7684\u4e3b\u8868/\u5b50\u8868\u5355\u636e\u201c%2$s\u201d\u975e\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ReportProcessDeleteValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]), billNo, nonSaveSubReportBillNoStr);
                this.addErrorMessage(data, errorMsg3);
                continue;
            }
            List<String> nonSaveParentReportBillNos = this.getNonSaveParentReportBillNo(reportPlan);
            if (nonSaveParentReportBillNos != null && nonSaveParentReportBillNos.size() > 0) {
                String nonSaveParentReportBillNoStr = String.join((CharSequence)"\uff0c", nonSaveParentReportBillNos);
                errorMsg = String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u672c\u6b21\u64cd\u4f5c\u5c06\u4f1a\u8054\u52a8\u5220\u9664\u540c\u4e00\u7f16\u62a5\u4e3b\u4f53\u4e0b\u7684\u4e3b\u5b50\u8868\u5173\u8054\u5355\u636e\uff0c\u800c\u5355\u636e\u3010%1$s\u3011\u5173\u8054\u7684\u4e3b\u8868/\u5b50\u8868\u5355\u636e\u3010%2$s\u3011\u975e\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ReportProcessDeleteValidator_2", (String)"tmc-fpm-business", (Object[])new Object[0]), billNo, nonSaveParentReportBillNoStr);
                this.addErrorMessage(data, errorMsg);
            }
            if (!CollectionUtils.isNotEmpty(nonSavaSameLevelReportBillNos = this.getNonSavaSameLevelReportBillNos(reportPlan))) continue;
            errorMsg = String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u672c\u6b21\u64cd\u4f5c\u5c06\u4f1a\u8054\u52a8\u5220\u9664\u540c\u4e00\u7f16\u62a5\u4e3b\u4f53\u4e0b\u7684\u4e3b\u5b50\u8868\u5173\u8054\u5355\u636e\uff0c\u800c\u5355\u636e\u3010%1$s\u3011\u5173\u8054\u7684\u4e3b\u8868/\u5b50\u8868\u5355\u636e\u3010%2$s\u3011\u975e\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ReportProcessDeleteValidator_3", (String)"tmc-fpm-business", (Object[])new Object[0]), billNo, String.join((CharSequence)"\uff0c", nonSavaSameLevelReportBillNos));
            this.addErrorMessage(data, errorMsg);
        }
    }

    private List<String> getNonSaveSubReportBillNos(DynamicObject reportMain) {
        DynamicObject bodySysDy = reportMain.getDynamicObject("bodysys");
        DynamicObject templateDy = reportMain.getDynamicObject("templatebak");
        if (Objects.isNull(bodySysDy) || Objects.isNull(templateDy)) {
            return null;
        }
        Long reportOrgId = reportMain.getLong("reportorg.id");
        DynamicObject reportOrg = TmcDataServiceHelper.loadSingle((Object)reportOrgId, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_member"));
        if (Objects.isNull(reportOrg)) {
            return null;
        }
        DynamicObjectCollection periodObjColl = reportMain.getDynamicObjectCollection("periodlist");
        List periodObjArr = periodObjColl.stream().map(item -> item.get("fbasedataid.id")).collect(Collectors.toList());
        DynamicObject[] periodMemberIdArr = TmcDataServiceHelper.load((String)DimsionEnums.PERIOD.getMetadata(), (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", periodObjArr), new QFilter("dimtype", "=", (Object)DimsionEnums.PERIOD.getNumber()), new QFilter("bodysystem", "=", bodySysDy.getPkValue())});
        Object[] memIdArr = Arrays.stream(periodMemberIdArr).map(DataEntityBase::getPkValue).toArray();
        DynamicObject[] periodMemberArr = TmcDataServiceHelper.load((Object[])memIdArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)DimsionEnums.PERIOD.getMetadata()));
        Optional<DynamicObject> optional = Arrays.stream(periodMemberArr).min(Comparator.comparing(ReportProcessDeleteValidator::getPeriodCompareDate));
        if (!optional.isPresent()) {
            return null;
        }
        DynamicObject periodDy = optional.get();
        DynamicObject[] ids = TmcDataServiceHelper.load((String)"fpm_report", (String)"billno", (QFilter[])new QFilter[]{new QFilter("parenttemplate.id", "=", (Object)templateDy.getLong("templateid")), new QFilter("reportperiod", "=", periodDy.getPkValue()), new QFilter("reportorg", "=", reportOrg.getPkValue()), new QFilter("billstatus", "<>", (Object)ReportProcessStatus.SAVE.getValue())});
        if (Objects.isNull(ids) || ids.length < 1) {
            return null;
        }
        return Arrays.stream(ids).map(id -> id.getString("billno")).collect(Collectors.toList());
    }

    private List<String> getNonSaveParentReportBillNo(DynamicObject reportMain) {
        DynamicObject bodySysDy = reportMain.getDynamicObject("bodysys");
        DynamicObject parentTemplateDy = reportMain.getDynamicObject("parenttemplate");
        if (Objects.isNull(bodySysDy) || Objects.isNull(parentTemplateDy)) {
            return null;
        }
        Long reportOrgId = reportMain.getLong("reportorg.id");
        DynamicObject reportOrg = TmcDataServiceHelper.loadSingle((Object)reportOrgId, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_member"));
        if (Objects.isNull(reportOrg)) {
            return null;
        }
        DynamicObjectCollection periodObjColl = reportMain.getDynamicObjectCollection("periodlist");
        List periodObjArr = periodObjColl.stream().map(item -> item.get("fbasedataid.id")).collect(Collectors.toList());
        DynamicObject[] periodMemberIdArr = TmcDataServiceHelper.load((String)DimsionEnums.PERIOD.getMetadata(), (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", periodObjArr), new QFilter("dimtype", "=", (Object)DimsionEnums.PERIOD.getNumber()), new QFilter("bodysystem", "=", bodySysDy.getPkValue())});
        Object[] memIdArr = Arrays.stream(periodMemberIdArr).map(DataEntityBase::getPkValue).toArray();
        DynamicObject[] periodMemberArr = TmcDataServiceHelper.load((Object[])memIdArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)DimsionEnums.PERIOD.getMetadata()));
        Optional<DynamicObject> optional = Arrays.stream(periodMemberArr).min(Comparator.comparing(ReportProcessDeleteValidator::getPeriodCompareDate));
        if (!optional.isPresent()) {
            return null;
        }
        DynamicObject periodDy = optional.get();
        DynamicObject[] ids = TmcDataServiceHelper.load((String)"fpm_report", (String)"billno", (QFilter[])new QFilter[]{new QFilter("template.id", "=", (Object)parentTemplateDy.getLong("id")), new QFilter("reportperiod", "=", periodDy.getPkValue()), new QFilter("reportorg", "=", reportOrg.getPkValue()), new QFilter("billstatus", "<>", (Object)ReportProcessStatus.SAVE.getValue())});
        if (Objects.isNull(ids) || ids.length < 1) {
            return null;
        }
        return Arrays.stream(ids).map(id -> id.getString("billno")).collect(Collectors.toList());
    }

    private List<String> getNonSavaSameLevelReportBillNos(DynamicObject reportMain) {
        DynamicObject bodySysDy = reportMain.getDynamicObject("bodysys");
        DynamicObject parentTemplateDy = reportMain.getDynamicObject("parenttemplate");
        if (Objects.isNull(bodySysDy) || Objects.isNull(parentTemplateDy)) {
            return null;
        }
        Long reportOrgId = reportMain.getLong("reportorg.id");
        DynamicObject reportOrg = TmcDataServiceHelper.loadSingle((Object)reportOrgId, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_member"));
        if (Objects.isNull(reportOrg)) {
            return null;
        }
        DynamicObjectCollection periodObjColl = reportMain.getDynamicObjectCollection("periodlist");
        List periodObjArr = periodObjColl.stream().map(item -> item.get("fbasedataid.id")).collect(Collectors.toList());
        DynamicObject[] periodMemberIdArr = TmcDataServiceHelper.load((String)DimsionEnums.PERIOD.getMetadata(), (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", periodObjArr), new QFilter("dimtype", "=", (Object)DimsionEnums.PERIOD.getNumber()), new QFilter("bodysystem", "=", bodySysDy.getPkValue())});
        Object[] memIdArr = Arrays.stream(periodMemberIdArr).map(DataEntityBase::getPkValue).toArray();
        DynamicObject[] periodMemberArr = TmcDataServiceHelper.load((Object[])memIdArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)DimsionEnums.PERIOD.getMetadata()));
        Optional<DynamicObject> optional = Arrays.stream(periodMemberArr).min(Comparator.comparing(ReportProcessDeleteValidator::getPeriodCompareDate));
        if (!optional.isPresent()) {
            return null;
        }
        DynamicObject periodDy = optional.get();
        DynamicObject[] ids = TmcDataServiceHelper.load((String)"fpm_report", (String)"billno", (QFilter[])new QFilter("parenttemplate", "=", (Object)parentTemplateDy.getLong("id")).and("reportperiod", "=", periodDy.getPkValue()).and("reportorg", "=", reportOrg.getPkValue()).and("billstatus", "<>", (Object)ReportProcessStatus.SAVE.getValue()).toArray());
        if (Objects.isNull(ids) || ids.length < 1) {
            return null;
        }
        return Arrays.stream(ids).map(id -> id.getString("billno")).collect(Collectors.toList());
    }

    private static Date getPeriodCompareDate(DynamicObject dynamicObject) {
        return dynamicObject.getDate("startdate");
    }
}

