/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanRecord;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.repository.ISumPlanRepository;
import kd.tmc.fpm.business.mvc.repository.dto.ReportQDTO;
import kd.tmc.fpm.business.mvc.repository.impl.ReportRepository;
import kd.tmc.fpm.business.mvc.repository.impl.SumPlanRepository;
import kd.tmc.fpm.business.mvc.service.ISumPlanBizService;
import kd.tmc.fpm.business.mvc.service.impl.SumPlanBizServiceImpl;

public class ReportSumPlanAuditValidator
extends AbstractTmcBizOppValidator {
    private ISumPlanRepository repository = new SumPlanRepository();
    private IReportRepository reportRepository = new ReportRepository();
    private ISumPlanBizService sumPlanBizService = new SumPlanBizServiceImpl();

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bodysys");
        selector.add("id");
        selector.add("reportorg");
        selector.add("reportperiod");
        selector.add("reporttype");
        selector.add("originalreportids");
        selector.add("offsetornot");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity data : extendedDataEntities) {
            Map<Long, String> orgMap;
            List<SumPlanRecord> parentRecords;
            List collect;
            DynamicObject sumPlanDO = data.getDataEntity();
            Long systemId = (Long)sumPlanDO.getDynamicObject("bodysys").getPkValue();
            Long reportType = (Long)sumPlanDO.getDynamicObject("reporttype").getPkValue();
            Long reportPeriodId = (Long)sumPlanDO.getDynamicObject("reportperiod").getPkValue();
            SumPlanRecord sumPlanRecord = this.getSumPlanRecord(sumPlanDO);
            this.sumPlanBizService.getSumPlanReports(null, sumPlanRecord, null);
            List currReportList = sumPlanRecord.getSumPlanReportList().stream().map(item -> item).collect(Collectors.toList());
            if (EmptyUtil.isEmpty(currReportList)) continue;
            OrgMember reportOrg = ((Report)currReportList.get(0)).getCompanyMemberList().get(0);
            List<DimMember> allParentMember = reportOrg.getAllParentMember();
            ArrayList<OrgMember> sumOrgMemberList = new ArrayList<OrgMember>();
            if (!EmptyUtil.isEmpty(allParentMember)) {
                SumPlanParamConfig sumPlanParamConfig = this.repository.loadSumConfigBySystem(systemId, reportType);
                List<SumPlanParamConfigInfo> configInfoList = sumPlanParamConfig.getConfigInfoList();
                Map<Long, Boolean> configInfoMap = configInfoList.stream().collect(Collectors.toMap(SumPlanParamConfigInfo::getOrgMemberId, SumPlanParamConfigInfo::isSumAuditNode));
                for (DimMember currParentMember : allParentMember) {
                    if (!configInfoMap.get(currParentMember.getId()).booleanValue()) continue;
                    OrgMember sumOrgMember = (OrgMember)currParentMember;
                    ReportQDTO reportQDTO = new ReportQDTO();
                    reportQDTO.setReportOrgId(sumOrgMember.getId());
                    reportQDTO.setReportPeriodId(reportPeriodId);
                    reportQDTO.setReportPlanType(ReportPlanType.SUMPLAN);
                    Set<Long> reportList = this.reportRepository.loadReportIdsByParam(reportQDTO);
                    if (EmptyUtil.isEmpty(reportList)) continue;
                    sumOrgMemberList.add(sumOrgMember);
                }
            }
            if (EmptyUtil.isEmpty(sumOrgMemberList) || EmptyUtil.isEmpty(collect = (parentRecords = this.repository.loadSumPlanRecord(new ArrayList<Long>((orgMap = sumOrgMemberList.stream().collect(Collectors.toMap(DimMember::getId, DimMember::getName))).keySet()), reportPeriodId)).stream().filter(record -> record.getStatus() != BillStatus.STAGE).map(SumPlanRecord::getOrgId).collect(Collectors.toList()))) continue;
            String join = collect.stream().filter(orgMap::containsKey).map(orgMap::get).collect(Collectors.joining("\u3001"));
            String errorMessage = String.format(ResManager.loadKDString((String)"\u6c47\u603b\u5904\u7406\u5355\u201c%1$s\u201d\u6240\u5173\u8054\u7684\u4e0a\u7ea7\u6c47\u603b\u4e3b\u4f53\u201c%2$s\u201d\u5df2\u63d0\u4ea4\u5ba1\u6838\uff0c\u5bfc\u81f4\u5f53\u524d\u6c47\u603b\u8282\u70b9\u65e0\u6cd5\u8fdb\u884c\u5ba1\u6838\u3002", (String)"ReportSumPlanAuditValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), sumPlanRecord.getNumber(), join);
            this.addFatalErrorMessage(data, errorMessage);
        }
    }

    private SumPlanRecord getSumPlanRecord(DynamicObject sumPlanDO) {
        Long id = sumPlanDO.getLong("id");
        String reportIds = sumPlanDO.getString("originalreportids");
        List<Long> originalReportIdList = EmptyUtil.isEmpty((String)reportIds) ? Collections.emptyList() : Arrays.stream(reportIds.split(",")).map(Long::parseLong).collect(Collectors.toList());
        SumPlanRecord sumPlanRecord = new SumPlanRecord();
        sumPlanRecord.setId(id);
        sumPlanRecord.setOriginalReportIdList(originalReportIdList);
        sumPlanRecord.setInnerCancel(sumPlanDO.getBoolean("offsetornot"));
        sumPlanRecord.setNumber(sumPlanDO.getString("billno"));
        return sumPlanRecord;
    }
}

