/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.report;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.FlowType;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigSnapshot;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanRecord;
import kd.tmc.fpm.business.helper.SumPlanRelationHelper;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.ISumPlanRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.mvc.repository.impl.SumPlanRepository;
import kd.tmc.fpm.business.mvc.service.ISumPlanBizService;
import kd.tmc.fpm.business.mvc.service.impl.SumPlanBizServiceImpl;
import kd.tmc.fpm.business.service.sumreport.service.ISummaryConfigService;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.common.enums.ReportPlanChangeStatusEnum;
import kd.tmc.fpm.common.property.SummaryConfigSnapshotProp;
import kd.tmc.fpm.common.utils.MD5Utils;
import org.apache.commons.collections4.CollectionUtils;

public class ReportSumPlanUnAuditValidator
extends AbstractTmcBizOppValidator {
    private ISumPlanRepository repository = new SumPlanRepository();
    private ISumPlanBizService sumPlanBizService = new SumPlanBizServiceImpl();
    private IDimensionRepository dimensionRepository = new DimensionRepository();
    private ISummaryConfigService iSummaryConfigService = FpmServiceFactory.getBizService(ISummaryConfigService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bodysys");
        selector.add("id");
        selector.add("billno");
        selector.add("reportorg");
        selector.add("reportperiod");
        selector.add("reporttype");
        selector.add("originalreportids");
        selector.add("planstatus");
        selector.add("offsetornot");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        if (extendedDataEntities.length == 0) {
            return;
        }
        Long systemId = (Long)extendedDataEntities[0].getDataEntity().getDynamicObject("bodysys").getPkValue();
        FundPlanSystem fundPlanSystem = this.dimensionRepository.loadSystem(systemId);
        Dimension subject = fundPlanSystem.getMainDimensionByDimType(DimensionType.SUBJECTS);
        Set periodBeginningSet = subject.getAllDimMemberList().stream().map(AccountMember.class::cast).filter(accountMember -> Objects.nonNull((Object)accountMember.getFlowType()) && accountMember.getFlowType() == FlowType.BALANCE).map(DimMember::getId).collect(Collectors.toSet());
        Set<String> positiveTxLockedBillIdSet = this.loadPositiveTxLockedBillIdSet(extendedDataEntities);
        List reportId = Arrays.stream(extendedDataEntities).map(i -> i.getDataEntity().getLong("id")).collect(Collectors.toList());
        Set existExecIdSet = null;
        DynamicObjectCollection existExecId = QueryServiceHelper.query((String)"fpm_execbiasanalys", (String)"sourcebill", (QFilter[])new QFilter[]{new QFilter("sourcebill", "in", reportId)});
        if (CollectionUtils.isNotEmpty((Collection)existExecId)) {
            existExecIdSet = existExecId.stream().map(item -> item.getLong("sourcebill")).collect(Collectors.toSet());
        }
        for (ExtendedDataEntity data : extendedDataEntities) {
            String errorMessage;
            DynamicObject sumPlanDO = data.getDataEntity();
            Long id = sumPlanDO.getLong("id");
            SumPlanRecord sumPlanRecord = this.getSumPlanRecord(sumPlanDO);
            this.sumPlanBizService.getSumPlanReports(null, sumPlanRecord, null);
            List currReportList = sumPlanRecord.getSumPlanReportList().stream().map(item -> item).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(currReportList)) continue;
            if (positiveTxLockedBillIdSet.contains(String.valueOf(id))) {
                errorMessage = String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6c47\u603b\u5904\u7406\u5355\u3010%1$s\u3011\u8fd8\u5728\u5206\u5e03\u5f0f\u4e8b\u52a1\u4e2d\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"ReportSumPlanUnAuditValidator_4", (String)"tmc-fpm-business", (Object[])new Object[0]), sumPlanRecord.getNumber());
                this.addFatalErrorMessage(data, errorMessage);
            }
            if (CollectionUtils.isNotEmpty(existExecIdSet) && existExecIdSet.contains(sumPlanDO.getLong("id"))) {
                errorMessage = ResManager.loadKDString((String)"\u5df2\u751f\u6210\u6267\u884c\u8ba1\u5212\u504f\u5dee\u5206\u6790\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"ReportSumPlanUnAuditValidator_7", (String)"tmc-fpm-business", (Object[])new Object[0]);
                this.addFatalErrorMessage(data, errorMessage);
                continue;
            }
            OrgMember reportOrg = ((Report)currReportList.get(0)).getCompanyMemberList().get(0);
            long sum = ((Report)currReportList.get(0)).getReportDataList().stream().filter(rd -> this.isBeginningSubject((ReportData)rd, periodBeginningSet)).mapToLong(reportData -> reportData.getActAmt().abs().add(reportData.getLockAmt().abs()).longValue()).sum();
            if (sum != 0L) {
                String errorMessage2 = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u5f53\u524d\u62a5\u8868\u5df2\u6709\u5b9e\u9645\u6570/\u9884\u5360\u6570\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u53cd\u5ba1\u6838\u3002", (String)"ReportSumPlanUnAuditValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]);
                this.addFatalErrorMessage(data, errorMessage2);
                continue;
            }
            Long reportPeriodId = (Long)sumPlanDO.getDynamicObject("reportperiod").getPkValue();
            SumPlanParamConfig sumPlanParamConfig = this.iSummaryConfigService.getSummaryParamConfig(Long.valueOf(sumPlanDO.getString("originalreportids")));
            SumPlanParamConfig newestParamConfig = this.getNewestEnableSummaryParamConfig(sumPlanParamConfig, sumPlanDO);
            if (newestParamConfig == null) {
                String errorMessage3 = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5f53\u524d\u7f16\u62a5\u7c7b\u578b\u4e0b\u6ca1\u6709\u201c\u53ef\u7528\u201d\u72b6\u6001\u7684\u6c47\u603b\u53c2\u6570\u914d\u7f6e\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u53cd\u5ba1\u6838\uff0c\u8bf7\u5148\u542f\u7528\u6c47\u603b\u53c2\u6570\u914d\u7f6e\u518d\u64cd\u4f5c\u3002", (String)"ReportSumPlanUnAuditValidator_6", (String)"tmc-fpm-business", (Object[])new Object[0]);
                this.addFatalErrorMessage(data, errorMessage3);
                continue;
            }
            Map<Long, SumPlanParamConfigInfo> configMap = sumPlanParamConfig.getConfigInfoList().stream().collect(Collectors.toMap(SumPlanParamConfigInfo::getOrgMemberId, v -> v, (k1, k2) -> k1));
            Optional<String> errorMsgOpt = this.isSumPlanParamConfigChanged(sumPlanDO, sumPlanParamConfig, configMap, newestParamConfig);
            if (errorMsgOpt.isPresent()) {
                this.addFatalErrorMessage(data, errorMsgOpt.get());
                continue;
            }
            List subPlanOrgList = configMap.get(reportOrg.getId()).getAllChildren().stream().filter(item -> !item.isSumAuditNode()).collect(Collectors.toList());
            List idList = subPlanOrgList.stream().map(SumPlanParamConfigInfo::getOrgMemberId).collect(Collectors.toList());
            QFilter qFilter = new QFilter("reportperiod", "=", (Object)reportPeriodId).and("reportorg", "in", idList).and("reportplantype", "=", (Object)ReportPlanType.REPORTPLAN.getNumber()).and(new QFilter("changestatus", "=", (Object)ReportPlanChangeStatusEnum.CHANGING.getValue()).or("changestatus", "=", (Object)ReportPlanChangeStatusEnum.CHANGED.getValue()));
            if (TmcDataServiceHelper.exists((String)"fpm_report", (QFilter[])new QFilter[]{qFilter})) {
                String errorMessage4 = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4e0b\u7ea7\u7f16\u62a5\u4e3b\u4f53\u672c\u671f\u5df2\u4ea7\u751f\u8ba1\u5212\u8c03\u6574\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u53cd\u5ba1\u6838\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ReportSumPlanUnAuditValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]);
                this.addFatalErrorMessage(data, errorMessage4);
                continue;
            }
            List<Long> sumOrgMemberIdList = SumPlanRelationHelper.listAllParentSumOrgId(reportOrg.getId(), sumPlanParamConfig);
            if (CollectionUtils.isNotEmpty(sumOrgMemberIdList)) {
                QFilter parentSumOrgReportFilter = new QFilter("reportorg", "in", sumOrgMemberIdList).and("reportperiod", "=", (Object)reportPeriodId).and("reportplantype", "=", (Object)ReportPlanType.SUMPLAN.getNumber());
                DynamicObjectCollection parentSumOrgReportDyColl = QueryServiceHelper.query((String)"fpm_report", (String)"id,reportorg.id", (QFilter[])parentSumOrgReportFilter.toArray());
                sumOrgMemberIdList = parentSumOrgReportDyColl.stream().map(dy -> dy.getLong("reportorg.id")).collect(Collectors.toList());
            }
            if (CollectionUtils.isEmpty(sumOrgMemberIdList)) continue;
            List<SumPlanRecord> parentRecords = this.repository.loadSumPlanRecord(sumOrgMemberIdList, reportPeriodId);
            List collect = parentRecords.stream().filter(record -> record.getStatus() != BillStatus.STAGE).map(SumPlanRecord::getNumber).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)) {
                String join = String.join((CharSequence)"\u3011\u3010", collect);
                String errorMessage5 = String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u6c47\u603b\u5904\u7406\u5355\u201c%1$s\u201d\u5173\u8054\u7684\u4e0a\u7ea7\u6c47\u603b\u5355\u636e\u201c%2$s\u201d\u5904\u4e8e\u975e\u6682\u5b58\u72b6\u6001\uff0c\u6682\u65f6\u65e0\u6cd5\u8fdb\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"ReportSumPlanUnAuditValidator_2", (String)"tmc-fpm-business", (Object[])new Object[0]), sumPlanRecord.getNumber(), join);
                this.addFatalErrorMessage(data, errorMessage5);
                continue;
            }
            List recordIds = parentRecords.stream().map(SumPlanRecord::getId).collect(Collectors.toList());
            QFilter approvedFilter = new QFilter("reportid", "in", recordIds);
            int approvedCount = TmcDataServiceHelper.count((String)"fpm_approvedplanquota", (QFilter[])new QFilter[]{approvedFilter});
            if (approvedCount <= 0) continue;
            String errorMessage6 = ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\u3002\u4e0a\u7ea7\u6c47\u603b\u7f16\u62a5\u4e3b\u4f53\u672c\u671f\u5df2\u5bf9\u4e0b\u7ea7\u8ba1\u5212\u989d\u5ea6\u8fdb\u884c\u4e86\u6838\u5b9a\u4fee\u6539\uff0c\u6682\u4e0d\u652f\u6301\u53cd\u5ba1\u6838\u5904\u7406\u3002\u5982\u9700\u8c03\u6574\u4e0a\u62a5\u989d\u5ea6\uff0c\u8bf7\u76f4\u63a5\u5728\u4e0a\u7ea7\u6c47\u603b\u5c42\u7ea7\u8fdb\u884c\u6838\u5b9a\u4fee\u6539\u3002", (String)"ReportSumPlanUnAuditValidator_3", (String)"tmc-fpm-business", (Object[])new Object[0]);
            this.addFatalErrorMessage(data, errorMessage6);
        }
    }

    private boolean isBeginningSubject(ReportData rd, Set<Long> periodBeginningSet) {
        if (CollectionUtils.isEmpty(periodBeginningSet)) {
            return true;
        }
        Long subjectMem = (Long)rd.getDimValByDimType(DimensionType.SUBJECTS, null);
        return !periodBeginningSet.contains(subjectMem);
    }

    private Set<String> loadPositiveTxLockedBillIdSet(ExtendedDataEntity[] extendedDataEntities) {
        List businessIdList = Arrays.stream(extendedDataEntities).map(ExtendedDataEntity::getDataEntity).map(dataEntity -> dataEntity.getLong("id")).map(String::valueOf).collect(Collectors.toList());
        if (businessIdList.isEmpty()) {
            return new HashSet<String>(2);
        }
        List lockBusinessIds = TxCheckUtil.loadUnfinishedTx(businessIdList);
        if (!lockBusinessIds.isEmpty()) {
            return new HashSet<String>(lockBusinessIds);
        }
        return new HashSet<String>(2);
    }

    private Optional<String> isSumPlanParamConfigChanged(DynamicObject sumPlanDO, SumPlanParamConfig sumPlanParamConfigSnapshot, Map<Long, SumPlanParamConfigInfo> configMap, SumPlanParamConfig newestEnableConfig) {
        Long reportOrgId = (Long)sumPlanDO.getDynamicObject("reportorg").getPkValue();
        ReportStatus reportStatus = ReportStatus.getByVal(sumPlanDO.getString("planstatus"));
        if (!(sumPlanParamConfigSnapshot instanceof SumPlanParamConfigSnapshot && configMap.containsKey(reportOrgId) && configMap.get(reportOrgId).isSumAuditNode() && reportStatus == ReportStatus.ENABLE)) {
            return Optional.empty();
        }
        String errorMessage = String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5f53\u524d\u62a5\u8868\u7684\u7ec4\u7ec7\u6c47\u603b\u5c42\u7ea7\u5173\u7cfb\u4e0e\u5bf9\u5e94\u7f16\u62a5\u7c7b\u578b\u4e0b\u7684\u201c\u53ef\u7528\u201d\u72b6\u6001\u7684\u6c47\u603b\u53c2\u6570\u914d\u7f6e\u8bb0\u5f55\u3010%1$s\u3011\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u53cd\u5ba1\u6838\uff0c\u8bf7\u5148\u542f\u7528\u539f\u6c47\u603b\u53c2\u6570\u914d\u7f6e\u518d\u64cd\u4f5c\u3002", (String)"ReportSumPlanUnAuditValidator_5", (String)"tmc-fpm-business", (Object[])new Object[0]), newestEnableConfig.getNumber());
        Set snapSumAuditNodeOrgIdSet = sumPlanParamConfigSnapshot.getConfigInfoList().stream().filter(SumPlanParamConfigInfo::isSumAuditNode).map(SumPlanParamConfigInfo::getOrgMemberId).collect(Collectors.toSet());
        Set sumAuditNodeOrgIdSet = newestEnableConfig.getConfigInfoList().stream().filter(SumPlanParamConfigInfo::isSumAuditNode).map(SumPlanParamConfigInfo::getOrgMemberId).collect(Collectors.toSet());
        boolean conflict = snapSumAuditNodeOrgIdSet.stream().anyMatch(orgId -> !sumAuditNodeOrgIdSet.contains(orgId));
        if (conflict) {
            return Optional.of(errorMessage);
        }
        if (Objects.equals(newestEnableConfig.getId(), ((SumPlanParamConfigSnapshot)sumPlanParamConfigSnapshot).getSummaryConfigId())) {
            return Optional.empty();
        }
        SimplePropertyPreFilter filter = new SimplePropertyPreFilter(new String[0]);
        filter.getIncludes().addAll(SummaryConfigSnapshotProp.CALCULATE_MD5_PROPS);
        SerializeFilter[] filters = new SerializeFilter[]{filter};
        String newestConfigInfoJson = JSON.toJSONString(newestEnableConfig.getConfigInfoList(), (SerializeFilter[])filters, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        String newestConfigInfoMD5 = MD5Utils.getMD5Code((String)newestConfigInfoJson);
        boolean nonChanged = Objects.equals(newestConfigInfoMD5, ((SumPlanParamConfigSnapshot)sumPlanParamConfigSnapshot).getConfigInfoListMD5());
        if (nonChanged) {
            return Optional.empty();
        }
        return Optional.of(errorMessage);
    }

    private SumPlanParamConfig getNewestEnableSummaryParamConfig(SumPlanParamConfig sumPlanParamConfig, DynamicObject sumPlanDO) {
        if (sumPlanParamConfig != null && !(sumPlanParamConfig instanceof SumPlanParamConfigSnapshot)) {
            return sumPlanParamConfig;
        }
        Long systemId = (Long)sumPlanDO.getDynamicObject("bodysys").getPkValue();
        Long reportTypeId = (Long)sumPlanDO.getDynamicObject("reporttype").getPkValue();
        return this.iSummaryConfigService.getNewestEnableSummaryParamConfig(systemId, reportTypeId);
    }

    private SumPlanRecord getSumPlanRecord(DynamicObject sumPlanDO) {
        Long id = sumPlanDO.getLong("id");
        String reportIds = sumPlanDO.getString("originalreportids");
        List<Long> originalReportIdList = EmptyUtil.isEmpty((String)reportIds) ? Collections.emptyList() : Arrays.stream(reportIds.split(",")).map(Long::parseLong).collect(Collectors.toList());
        SumPlanRecord sumPlanRecord = new SumPlanRecord();
        sumPlanRecord.setId(id);
        sumPlanRecord.setOriginalReportIdList(originalReportIdList);
        sumPlanRecord.setInnerCancel(sumPlanDO.getBoolean("offsetornot"));
        sumPlanRecord.setNumber(sumPlanDO.getString("billno"));
        return sumPlanRecord;
    }
}

