/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.report;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.SunReportSumStatus;
import kd.tmc.fpm.common.helper.StringHelper;

public class SumPlanSubmitCheckSubReportValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("originalreportids");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        Set allowSubmitIds = Arrays.stream(StringHelper.split((String)this.getOption().getVariableValue("allowSubmitIds"), (String[])new String[0])).map(Long::parseLong).collect(Collectors.toSet());
        List extendedDataEntityList = Arrays.stream(dataEntity).filter(extendedDataEntity -> allowSubmitIds.contains((Long)extendedDataEntity.getBillPkId())).collect(Collectors.toList());
        Set sumReportIds = extendedDataEntityList.stream().map(ExtendedDataEntity::getDataEntity).map(dy -> dy.getString("originalreportids")).map(Long::parseLong).collect(Collectors.toSet());
        String subReportIdProp = String.join((CharSequence)".", "sumentry", "sumorgreportid");
        String subReportSumStatusProp = String.join((CharSequence)".", "sumentry", "sumstatus");
        String selectFields = String.join((CharSequence)",", "id", subReportIdProp);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fpm_report", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", sumReportIds).and(new QFilter(subReportSumStatusProp, "=", (Object)SunReportSumStatus.SUM.getNumber()))});
        String errorMsg = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4e0b\u7ea7\u7f16\u62a5\u4e3b\u4f53\u5c1a\u672a\u8fdb\u884c\u8ba1\u5212\u989d\u5ea6\u4e0a\u62a5\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"SumPlanSubmitCheckSubReportValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)query)) {
            for (ExtendedDataEntity extendedDataEntity2 : extendedDataEntityList) {
                this.addErrorMessage(extendedDataEntity2, errorMsg);
            }
            return;
        }
        Map sumReportMap = query.stream().collect(Collectors.groupingBy(dy -> dy.getLong("id"), Collectors.mapping(dy -> dy.getLong(subReportIdProp), Collectors.toList())));
        for (ExtendedDataEntity extendedDataEntity3 : extendedDataEntityList) {
            String originalReportId = extendedDataEntity3.getDataEntity().getString("originalreportids");
            long sumReportId = Long.parseLong(originalReportId);
            List summedSubChildReport = sumReportMap.getOrDefault(sumReportId, Collections.emptyList());
            if (!EmptyUtil.isEmpty(summedSubChildReport)) continue;
            this.addErrorMessage(extendedDataEntity3, errorMsg);
        }
    }
}

