/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.template;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.ReportInputType;

public class AccountPropSettingConfirmValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("account.ways");
        return selector;
    }

    public void validate(ExtendedDataEntity[] ExtendedDataEntitys) throws KDBizException {
        String isMainTable = this.getOption().getVariables().getOrDefault("ismaintable", "fale");
        for (ExtendedDataEntity dataEntity : ExtendedDataEntitys) {
            String errorMsg = "";
            DynamicObject accountPropSetting = dataEntity.getDataEntity();
            DynamicObjectCollection entrys = accountPropSetting.getDynamicObjectCollection("entry");
            boolean isLegal = true;
            List subTempList = entrys.stream().map(item -> item.get("template")).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (subTempList.size() > 10) {
                isLegal = false;
                errorMsg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u4e3b\u8868\u6a21\u677f\u6700\u591a\u53ef\u5173\u805410\u4e2a\u5b50\u8868\u6a21\u677f\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\u3002", (String)"AccountPropSettingConfirmValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]);
            }
            for (DynamicObject entry : entrys) {
                DynamicObject account = entry.getDynamicObject("account");
                boolean isLeaf = !entrys.stream().filter(item -> item.get("pid").equals(entry.getPkValue())).findFirst().isPresent();
                String ways = entry.getString("ways");
                if (EmptyUtil.isEmpty((String)ways)) {
                    isLegal = false;
                    errorMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u8bf7\u586b\u5199\u586b\u62a5\u65b9\u5f0f\u3002", (String)"AccountPropSettingConfirmValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]), account.getString("number"));
                }
                String formula = entry.getString("formula");
                if (ReportInputType.FORMULA.getNumber().equals(ways) && EmptyUtil.isEmpty((String)formula)) {
                    isLegal = false;
                    errorMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u8bf7\u586b\u5199\u9002\u7528\u516c\u5f0f\u3002", (String)"AccountPropSettingConfirmValidator_2", (String)"tmc-fpm-business", (Object[])new Object[0]), account.getString("number"));
                }
                DynamicObject template = entry.getDynamicObject("template");
                if (ReportInputType.DETAIL_INPUT.getNumber().equals(ways) && EmptyUtil.isEmpty((DynamicObject)template) && "true".equals(isMainTable)) {
                    isLegal = false;
                    errorMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u8bf7\u586b\u5199\u5173\u8054\u5b50\u6a21\u677f\u3002", (String)"AccountPropSettingConfirmValidator_3", (String)"tmc-fpm-business", (Object[])new Object[0]), account.getString("number"));
                }
                if (ReportInputType.SUMMARY.getNumber().equals(ways) && EmptyUtil.isEmpty((String)formula) && isLeaf) {
                    isLegal = false;
                    errorMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u53f6\u5b50\u8282\u70b9\u4e0d\u80fd\u4e3a\u6c47\u603b\u9879\u3002", (String)"AccountPropSettingConfirmValidator_4", (String)"tmc-fpm-business", (Object[])new Object[0]), account.getString("number"));
                }
                account = TmcDataServiceHelper.loadSingle((Object)account.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)account.getDataEntityType().getName()));
                String accountWays = account.getString("ways");
                String flow = account.getString("flow");
                if ("true".equals(isMainTable) && !"A".equals(flow) && (accountWays.equals(ReportInputType.MANUAL_INPUT.getNumber()) || accountWays.equals(ReportInputType.DETAIL_INPUT.getNumber())) && ways.equals(ReportInputType.SUMMARY.getNumber())) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s:\u6a21\u677f\u4e3a\u4e3b\u8868\uff0c\u79d1\u76ee\u6d41\u5411\u975e\u4f59\u989d\u5bf9\u5e94\u5728\u79d1\u76ee\u6811\u4e2d\u7684\u586b\u62a5\u65b9\u5f0f\u4e3a\u201c\u624b\u5de5\u5f55\u5165/\u660e\u7ec6\u586b\u62a5\u201d,\u586b\u62a5\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u6c47\u603b\u9879", (String)"AccountPropSettingConfirmValidator_5", (String)"tmc-fpm-business", (Object[])new Object[0]), account.getString("number")));
                }
                if ("A".equals(flow) && accountWays.equals(ReportInputType.MANUAL_INPUT.getNumber()) && !ways.equals(ReportInputType.MANUAL_INPUT.getNumber()) && !ways.equals(ReportInputType.FORMULA.getNumber()) && !ways.equals(ReportInputType.DETAIL_INPUT.getNumber())) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s:\u79d1\u76ee\u6d41\u5411\u4e3a\u4f59\u989d\u79d1\u76ee\u5bf9\u5e94\u586b\u62a5\u65b9\u5f0f\u4e3a\u201d\u624b\u5de5\u5f55\u5165\u201c\uff0c\u586b\u62a5\u65b9\u5f0f\u5e94\u4e3a\u624b\u5de5\u5f55\u5165\u6216\u516c\u5f0f\u9879", (String)"AccountPropSettingConfirmValidator_6", (String)"tmc-fpm-business", (Object[])new Object[0]), account.getString("number")));
                }
                if (!"false".equals(isMainTable) || !ways.equals(ReportInputType.DETAIL_INPUT.getNumber())) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s:\u6a21\u677f\u4e3a\u5b50\u8868\uff0c\u586b\u62a5\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u660e\u7ec6\u586b\u62a5", (String)"AccountPropSettingConfirmValidator_7", (String)"tmc-fpm-business", (Object[])new Object[0]), account.getString("number")));
            }
            if (isLegal) continue;
            this.addErrorMessage(dataEntity, errorMsg);
        }
    }
}

