/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.template;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fpm.common.enums.TemplateUsesEnum;
import org.apache.commons.collections4.CollectionUtils;

public class AnalysisTemplateReleaseValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selectors = super.getSelector();
        selectors.add("releasestatus");
        selectors.add("enable");
        selectors.add("id");
        selectors.add("model");
        selectors.add("templateuses");
        selectors.add("name");
        selectors.add("number");
        selectors.add("user");
        return selectors;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        List filterList = Arrays.stream(extendedDataEntities).filter(item -> TemplateUsesEnum.ANALYSIS.getValue().equals(item.getDataEntity().getString("templateuses")) || TemplateUsesEnum.STATISTIC.getValue().equals(item.getDataEntity().getString("templateuses"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(filterList)) {
            return;
        }
        List ids = filterList.stream().map(item -> item.getDataEntity().getLong("id")).collect(Collectors.toList());
        String statTemplate = String.join((CharSequence)".", "statanalysistemplate", "fbasedataid", "id");
        QFilter qFilter = new QFilter(statTemplate, "in", ids);
        String fields = String.join((CharSequence)",", "id", "name", statTemplate);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fpm_template", (String)fields, (QFilter[])new QFilter[]{qFilter});
        HashMap relateMap = new HashMap();
        query.forEach(dynamicObject -> {
            Long accId = dynamicObject.getLong(statTemplate);
            String mainTplName = dynamicObject.getString("name");
            if (relateMap.containsKey(accId)) {
                String names = (String)relateMap.get(accId);
                names = names + "\u3001\u3010" + mainTplName + "\u3011";
                relateMap.put(accId, names);
            } else {
                relateMap.put(accId, "\u3010" + mainTplName + "\u3011");
            }
        });
        for (ExtendedDataEntity dataEntity : filterList) {
            DynamicObject entity = dataEntity.getDataEntity();
            boolean isEnable = entity.getBoolean("enable");
            if (!isEnable) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7981\u7528\u7684\u6a21\u677f\u4e0d\u80fd\u53d1\u5e03\u3002", (String)"AnalysisTemplateReleaseValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
                continue;
            }
            boolean isRelease = entity.getBoolean("releasestatus");
            if (isRelease) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u53d1\u5e03\u7684\u6a21\u677f\u4e0d\u80fd\u518d\u53d1\u5e03\u3002", (String)"AnalysisTemplateReleaseValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
                continue;
            }
            Long id = (Long)entity.getPkValue();
            if (!relateMap.containsKey(id) || TemplateUsesEnum.ANALYSIS.getValue().equals(entity.getString("templateuses"))) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53d1\u5e03\u5931\u8d25\uff0c\u7531\u4e8e\u5f53\u524d\u6a21\u677f\u3010%1$s\u3011\u4e0e\u6c47\u603b\u7f16\u5236\u6a21\u677f%2$s\u5b58\u5728\u5173\u8054\u5f15\u7528\u5173\u7cfb\uff0c\u6a21\u677f\u7528\u9014\u5e94\u5305\u542b\u201c\u6c47\u603b\u7f16\u62a5\u9644\u8868\u201d\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\u3002", (String)"AnalysisTemplateReleaseValidator_2", (String)"tmc-fpm-business", (Object[])new Object[0]), entity.getString("name"), relateMap.get(id)));
        }
    }
}

