/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.template;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fpm.common.enums.ReportPlanStatusEnum;
import kd.tmc.fpm.common.enums.TemplateUsesEnum;

public class TemplateCancelReleaseValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selectors = super.getSelector();
        selectors.add("releasestatus");
        selectors.add("ismaintable");
        selectors.add("templateuses");
        selectors.add("name");
        return selectors;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        if (extendedDataEntities.length > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u64a4\u9500\u53d1\u5e03\u3002", (String)"TemplateCancelReleaseValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            if (!dataEntity.getBoolean("releasestatus")) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u672a\u53d1\u5e03\u7684\u6a21\u677f\u4e0d\u80fd\u64a4\u9500\u53d1\u5e03\u3002", (String)"TemplateCancelReleaseValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
            if (dataEntity.getBoolean("ismaintable")) {
                boolean existsUnData = QueryServiceHelper.exists((String)"fpm_report", (QFilter[])new QFilter[]{new QFilter("template.id", "=", (Object)dataEntity.getLong("id")), new QFilter("planstatus", "!=", (Object)ReportPlanStatusEnum.EFFECTIVE.getValue())});
                if (!existsUnData) continue;
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u6240\u5173\u8054\u7684\u8ba1\u5212\u7f16\u5236\u6216\u6c47\u603b\u7f16\u5236\u5355\u636e\u5b58\u5728\u975e\u751f\u6548\u72b6\u6001\uff0c\u6682\u4e0d\u5141\u8bb8\u64a4\u9500\u53d1\u5e03\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"TemplateCancelReleaseValidator_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
                continue;
            }
            if (TemplateUsesEnum.ANALYSIS.getValue().equals(dataEntity.getString("templateuses"))) {
                String statTemplate = String.join((CharSequence)".", "statanalysistemplate", "fbasedataid", "id");
                QFilter qFilter = new QFilter(statTemplate, "in", dataEntity.get("id")).and("releasestatus", "=", (Object)"1");
                String fields = String.join((CharSequence)",", "id", "name", "number");
                DynamicObjectCollection mainTpl = QueryServiceHelper.query((String)"fpm_template", (String)fields, (QFilter[])new QFilter[]{qFilter});
                if (CollectionUtils.isEmpty((Collection)mainTpl)) continue;
                List numbers = mainTpl.stream().map(item -> item.getString("number") + "(" + item.getString("name") + ")").distinct().collect(Collectors.toList());
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u64a4\u9500\u53d1\u5e03\u5931\u8d25\uff0c\u8bf7\u5148\u89e3\u9664\u5f53\u524d\u6a21\u677f\u201c%1$s\u201d\u4e0e\u6c47\u603b\u7f16\u5236\u6a21\u677f\u201c%2$s\u201d\u7684\u5173\u8054\u5f15\u7528\u5173\u7cfb\u540e\u518d\u64cd\u4f5c\u3002", (String)"TemplateCancelReleaseValidator_3", (String)"tmc-fpm-business", (Object[])new Object[0]), dataEntity.getString("name"), String.join((CharSequence)";", numbers)));
                continue;
            }
            DynamicObjectCollection mainTableColl = QueryServiceHelper.query((String)"fpm_template", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("subjecttentry.subtemplate.id", "=", (Object)dataEntity.getLong("id")), new QFilter("releasestatus", "=", (Object)"1")});
            if (CollectionUtils.isEmpty((Collection)mainTableColl)) continue;
            List numberList = mainTableColl.stream().map(i -> i.getString("number") + "(" + i.getString("name") + ")").distinct().collect(Collectors.toList());
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u6240\u5173\u8054\u7684\u4e3b\u8868\u3010%1$s\u3011\u4e3a\u53d1\u5e03\u72b6\u6001\uff0c\u6682\u4e0d\u5141\u8bb8\u64a4\u9500\u53d1\u5e03\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"TemplateCancelReleaseValidator_4", (String)"tmc-fpm-business", (Object[])new Object[0]), String.join((CharSequence)";", numberList)));
        }
    }
}

