/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.common.enums.DimLevelEnum;
import kd.tmc.fpm.common.enums.DimensionMemberScopeEnum;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.TemplateTypeEnum;
import kd.tmc.fpm.common.enums.TemplateUsesEnum;
import kd.tmc.fpm.common.helper.TemplateHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TemplateInfoSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("ismaintable");
        selector.add("model");
        selector.add("user");
        selector.add("reporttype");
        selector.add("subjectmember");
        selector.add("currencymember");
        selector.add("subject");
        selector.add("templateuses");
        selector.add("dimbd");
        selector.add("templatetype");
        selector.add("dfquerytpl");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        ExtendedDataEntity dataEntity = extendedDataEntities[0];
        DynamicObject dO = dataEntity.getDataEntity();
        String templateUses = dO.getString("templateuses");
        if (StringUtils.isEmpty((CharSequence)templateUses)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u7528\u9014\u3002", (String)"TemplateInfoSaveValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
            return;
        }
        if (TemplateUsesEnum.ANALYSIS.getValue().equals(templateUses) || TemplateUsesEnum.STATISTIC.getValue().equals(templateUses)) {
            this.checkAnalysisTemplate(dataEntity, dO);
        }
    }

    private void checkAnalysisTemplate(ExtendedDataEntity dataEntity, DynamicObject dO) {
        this.checkDefaultTemplate(dataEntity, dO);
        this.checkBaseInfo(dataEntity, dO);
        DynamicObjectCollection dimSets = dO.getDynamicObjectCollection("dimsettingentry");
        ArrayList<DynamicObject> rowList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> colList = new ArrayList<DynamicObject>();
        String templateType = dO.getString("templatetype");
        String templateUses = dO.getString("templateuses");
        boolean hasCol = false;
        boolean hasRow = false;
        for (DynamicObject entry : dimSets) {
            DimLocation dimLocation = DimLocation.getByNumber(entry.getString("type"));
            if (Objects.isNull((Object)dimLocation)) continue;
            if (DimLocation.COL == dimLocation) {
                hasCol = true;
                continue;
            }
            if (DimLocation.ROW != dimLocation) continue;
            hasRow = true;
        }
        if (!hasRow && TemplateTypeEnum.FIXED.getValue().equals(templateType) || !hasCol) {
            String name = !hasRow ? ResManager.loadKDString((String)"\u884c\u7ef4", (String)"TemplateInfoSaveValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5217\u7ef4", (String)"TemplateInfoSaveValidator_2", (String)"tmc-fpm-business", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u3010\u7ef4\u5ea6\u5e03\u5c40\u3011%1$s\u6700\u5c11\u9700\u8bbe\u7f6e1\u4e2a\u7ef4\u5ea6\u6210\u5458", (String)"TemplateInfoSaveValidator_3", (String)"tmc-fpm-business", (Object[])new Object[0]), name));
            return;
        }
        for (DynamicObject dimSet : dimSets) {
            String memberScope = dimSet.getString("dimmemberscope");
            DynamicObjectCollection templateMembers = dimSet.getDynamicObjectCollection("plantemplatemember");
            String dimType = dimSet.getString("type");
            if (StringUtils.isEmpty((CharSequence)dimType)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u3010\u7ef4\u5ea6\u5e03\u5c40\u3011\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"TemplateInfoSaveValidator_4", (String)"tmc-fpm-business", (Object[])new Object[0]));
                return;
            }
            if (DimensionMemberScopeEnum.FIXED_MEMBER.getValue().equals(memberScope) && CollectionUtils.isEmpty((Collection)templateMembers)) {
                String dimName = dimSet.getString("dimbd.name");
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u3010%1$s\u3011\u3010\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\u9009\u9879\u3011\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"TemplateInfoSaveValidator_5", (String)"tmc-fpm-business", (Object[])new Object[0]), dimName));
            }
            String number = dimSet.getString("dimnumber");
            if (TemplateTypeEnum.FIXED.getValue().equals(templateType) && number.equals(DimensionType.SUBJECTS.getNumber()) && dimType.equals(DimLocation.PAGE.getNumber())) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u6a21\u677f\u4e3a\u56fa\u5b9a\u6a21\u677f\u65f6\uff0c\u79d1\u76ee\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u4f5c\u4e3a\u9875\u9762\u8fc7\u6ee4\u6761\u4ef6", (String)"TemplateInfoSaveValidator_6", (String)"tmc-fpm-business", (Object[])new Object[0]));
                return;
            }
            if (dimType.equals(DimLocation.ROW.getNumber()) && DimLevelEnum.THREE.getValue().equals(dimSet.getInt("level"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u884c\u7ef4\u7ea7\u522b\u4e0d\u53ef\u8bbe\u7f6e\u4e3a\u4e09\u7ea7\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"TemplateInfoSaveValidator_7", (String)"tmc-fpm-business", (Object[])new Object[0]));
                return;
            }
            if (dimType.equals(DimLocation.ROW.getNumber()) && number.equals(DimensionType.PERIOD.getNumber())) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u671f\u95f4\u4e0d\u5141\u8bb8\u4f5c\u4e3a\u884c\u7ef4\u3002", (String)"TemplateInfoSaveValidator_8", (String)"tmc-fpm-business", (Object[])new Object[0]));
                return;
            }
            if (TemplateUsesEnum.STATISTIC.getValue().equals(templateUses) && Arrays.asList(DimensionType.SUBJECTS.getNumber(), DimensionType.ORG.getNumber(), DimensionType.PERIOD.getNumber(), DimensionType.CURRENCY.getNumber()).contains(number) && !dimSet.getBoolean("dimfilterdim")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7efc\u5408\u7edf\u8ba1\u67e5\u8be2\u6a21\u677f\u4e2d\u7684\u201c\u7f16\u62a5\u4e3b\u4f53\u3001\u5e01\u79cd\u3001\u671f\u95f4\u3001\u8ba1\u5212\u79d1\u76ee\u201d\u5fc5\u987b\u8bbe\u7f6e\u4f5c\u4e3a\u8fc7\u6ee4\u6761\u4ef6\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"TemplateInfoSaveValidator_9", (String)"tmc-fpm-business", (Object[])new Object[0]));
                return;
            }
            DimLocation dimLocation = DimLocation.getByNumber(dimSet.getString("type"));
            if (Objects.isNull((Object)dimLocation)) continue;
            if (DimLocation.ROW.getNumber().equals(dimType)) {
                rowList.add(dimSet);
                continue;
            }
            if (!DimLocation.COL.getNumber().equals(dimType)) continue;
            colList.add(dimSet);
        }
        if (TemplateTypeEnum.DETAIL.getValue().equals(templateType)) {
            this.detailValidator(dataEntity, colList, dO.getString("templateuses"));
        } else if (TemplateTypeEnum.FIXED.getValue().equals(templateType)) {
            this.fixValidator(dataEntity, colList, rowList);
        }
    }

    private void checkBaseInfo(ExtendedDataEntity dataEntity, DynamicObject dO) {
        String templateUses = dO.getString("templateuses");
        if (TemplateUsesEnum.STATISTIC.getValue().equals(templateUses)) {
            String billStatus;
            String queryableReportStatus = dO.getString("queryablerpts");
            if (StringUtils.isEmpty((CharSequence)queryableReportStatus)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53ef\u67e5\u8be2\u7684\u8ba1\u5212\u72b6\u6001\u3002", (String)"TemplateInfoSaveValidator_10", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((CharSequence)(billStatus = dO.getString("queryablebs")))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53ef\u67e5\u8be2\u7684\u8ba1\u5212\u7f16\u5236\u5355\u636e\u72b6\u6001\u3002", (String)"TemplateInfoSaveValidator_11", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
        }
    }

    private void checkDefaultTemplate(ExtendedDataEntity dataEntity, DynamicObject dO) {
        DynamicObject bodySystem;
        DynamicObject defaultTemplateExist;
        boolean isDefaultQueryTpl;
        String templateUses = dO.getString("templateuses");
        if (TemplateUsesEnum.STATISTIC.getValue().equals(templateUses) && (isDefaultQueryTpl = dO.getBoolean("dfquerytpl")) && (defaultTemplateExist = TemplateHelper.getDefaultTemplateExist((Object)(bodySystem = dO.getDynamicObject("model")).getPkValue())) != null && !Objects.equals(defaultTemplateExist.getLong("id"), dataEntity.getBillPkId())) {
            String number = defaultTemplateExist.getString("number");
            String name = defaultTemplateExist.getString("name");
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u4f53\u7cfb\u4e0b\u7684\u53ef\u7528\u72b6\u6001\u6a21\u677f\u3010%1$s\u3011\u5df2\u5f00\u542f\u4f5c\u4e3a\u9ed8\u8ba4\u67e5\u8be2\u6a21\u677f\uff0c\u4e0d\u5141\u8bb8\u6709\u591a\u4e2a\u9ed8\u8ba4\u6a21\u677f\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"TemplateInfoSaveValidator_12", (String)"tmc-fpm-business", (Object[])new Object[0]), number + " " + name));
        }
    }

    private void detailValidator(ExtendedDataEntity dataEntity, List<DynamicObject> colList, String templateUses) {
        List defaultSortItemList;
        List isOpenList = colList.stream().filter(col -> col.getBoolean("isopen")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(isOpenList)) {
            if (isOpenList.size() > 1) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u4e14\u4ec5\u6709\u4e00\u4e2a\u7ef4\u5ea6\u652f\u6301\u6210\u5458\u5e73\u94fa\u5c55\u5f00\u3002", (String)"TemplateInfoSaveValidator_13", (String)"tmc-fpm-business", (Object[])new Object[0]));
                return;
            }
            DynamicObject openDim = (DynamicObject)isOpenList.get(0);
            String dimName = openDim.getString("dimbd.name");
            DynamicObjectCollection memberList = openDim.getDynamicObjectCollection("plantemplatemember");
            String baseData = openDim.getString("dimbd.basedata");
            if (!DimsionEnums.PERIOD.getNumber().equals(baseData)) {
                if (memberList.size() == 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u5458\u5e73\u94fa\u5c55\u5f00\u65f6\u5c55\u5f00\u6210\u5458\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TemplateInfoSaveValidator_14", (String)"tmc-fpm-business", (Object[])new Object[0]));
                } else if (memberList.size() > 100) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u9884\u89c8\u5931\u8d25\uff0c\u5217\u7ef4\u3010%1$s\u3011\u6210\u5458\u6570\u91cf\u4e0d\u53ef\u8d85\u8fc7100\u4e2a\uff0c\u8bf7\u786e\u8ba4\u6210\u5458\u8303\u56f4\u3002", (String)"TemplateInfoSaveValidator_15", (String)"tmc-fpm-business", (Object[])new Object[0]), dimName));
                }
            }
        }
        if (TemplateUsesEnum.STATISTIC.getValue().equals(templateUses) && CollectionUtils.isEmpty(defaultSortItemList = colList.stream().filter(col -> col.getBoolean("isdfsortitem")).collect(Collectors.toList()))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9ed8\u8ba4\u6392\u5e8f\u9879\u3002", (String)"TemplateInfoSaveValidator_16", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
    }

    private void fixValidator(ExtendedDataEntity dataEntity, List<DynamicObject> colList, List<DynamicObject> rowList) {
        if (CollectionUtils.isNotEmpty(colList)) {
            if (colList.stream().anyMatch(item -> item.getInt("level") == 0)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ef4\u5ea6\u5e03\u5c40\u4e3a\u884c\u7ef4\u6216\u5217\u7ef4\u65f6\u884c\u5217\u7ef4\u7ea7\u522b\u5fc5\u586b\u3002", (String)"TemplateInfoSaveValidator_17", (String)"tmc-fpm-business", (Object[])new Object[0]));
                return;
            }
            if (colList.size() > 3) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ef4\u5ea6\u5e03\u5c40\u4fdd\u5b58\u5931\u8d25\uff0c\u5217\u7ef4\u6570\u91cf\u4e0d\u53ef\u8d85\u8fc73\u4e2a\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\u3002", (String)"TemplateInfoSaveValidator_18", (String)"tmc-fpm-business", (Object[])new Object[0]));
                return;
            }
            if (colList.size() > 1) {
                HashMap<Integer, Integer> levelMap = new HashMap<Integer, Integer>(2);
                for (int j = 0; j < colList.size(); ++j) {
                    DynamicObject jObj = colList.get(j);
                    int jLevel = jObj.getInt("level");
                    for (int i = j + 1; i < colList.size(); ++i) {
                        DynamicObject iObj = colList.get(i);
                        int iLevel = iObj.getInt("level");
                        if (jLevel != iLevel) continue;
                        String errorMsg = ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4%1$s\u548c%2$s\u884c\u5217\u7ef4\u7ea7\u522b\uff0c\u4e0d\u53ef\u76f8\u540c\u3002", (String)"TemplateInfoSaveValidator_19", (String)"tmc-fpm-business", (Object[])new Object[0]);
                        this.addErrorMessage(dataEntity, String.format(errorMsg, jObj.get("dimbd.name"), iObj.get("dimbd.name")));
                        return;
                    }
                    levelMap.put(jLevel, 1);
                }
                if (!levelMap.containsKey(1)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4e00\u7ea7\u7ef4\u5ea6\u7684\u60c5\u51b5\u4e0b\u7ef4\u5ea6\u7ea7\u522b\u4e0d\u80fd\u9009\u62e9\u4e8c\u7ea7\u6216\u8005\u4e09\u7ea7\u3002", (String)"TemplateInfoSaveValidator_20", (String)"tmc-fpm-business", (Object[])new Object[0]));
                    return;
                }
                if (!levelMap.containsKey(2)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4e00\u7ea7\u7ef4\u5ea6\u6216\u4e8c\u7ea7\u7ef4\u5ea6\u7684\u60c5\u51b5\u4e0b\u7ef4\u5ea6\u7ea7\u522b\u4e0d\u80fd\u9009\u62e9\u4e09\u7ea7\u3002", (String)"TemplateInfoSaveValidator_21", (String)"tmc-fpm-business", (Object[])new Object[0]));
                    return;
                }
                colList.forEach(dynamicObject -> this.checkColMemberCount(dataEntity, (DynamicObject)dynamicObject));
            } else {
                DynamicObject theOnlyOne = colList.get(0);
                int level = theOnlyOne.getInt("level");
                if (DimLevelEnum.TWO.getValue().equals(level)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4e00\u7ea7\u7ef4\u5ea6\u7684\u60c5\u51b5\u4e0b\u7ef4\u5ea6\u7ea7\u522b\u4e0d\u80fd\u9009\u62e9\u4e8c\u7ea7\u3002", (String)"TemplateInfoSaveValidator_22", (String)"tmc-fpm-business", (Object[])new Object[0]));
                    return;
                }
                if (DimLevelEnum.THREE.getValue().equals(level)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4e00\u7ea7\u7ef4\u5ea6\u6216\u4e8c\u7ea7\u7ef4\u5ea6\u7684\u60c5\u51b5\u4e0b\u7ef4\u5ea6\u7ea7\u522b\u4e0d\u80fd\u9009\u62e9\u4e09\u7ea7\u3002", (String)"TemplateInfoSaveValidator_23", (String)"tmc-fpm-business", (Object[])new Object[0]));
                    return;
                }
            }
        }
        if (CollectionUtils.isNotEmpty(rowList)) {
            if (rowList.stream().anyMatch(item -> item.getInt("level") == 0)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ef4\u5ea6\u5e03\u5c40\u4e3a\u884c\u7ef4\u6216\u5217\u7ef4\u65f6\u884c\u5217\u7ef4\u7ea7\u522b\u5fc5\u586b\u3002", (String)"TemplateInfoSaveValidator_24", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
            DynamicObject oneObj = rowList.get(0);
            if (rowList.size() > 2) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ef4\u5ea6\u5e03\u5c40\u4fdd\u5b58\u5931\u8d25\uff0c\u884c\u7ef4\u6570\u91cf\u4e0d\u53ef\u8d85\u8fc72\u4e2a\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\u3002", (String)"TemplateInfoSaveValidator_25", (String)"tmc-fpm-business", (Object[])new Object[0]));
            } else if (rowList.size() == 2) {
                int _2;
                DynamicObject twoObj = rowList.get(1);
                if (oneObj.get("level").equals(twoObj.get("level"))) {
                    String errorMsg = ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4%1$s\u548c%2$s\u884c\u5217\u7ef4\u7ea7\u522b\uff0c\u4e0d\u53ef\u76f8\u540c\u3002", (String)"TemplateInfoSaveValidator_26", (String)"tmc-fpm-business", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, String.format(errorMsg, oneObj.get("dimbd.name"), twoObj.get("dimbd.name")));
                    return;
                }
                int _1 = oneObj.getDynamicObjectCollection("plantemplatemember").size();
                if (_1 * (_2 = twoObj.getDynamicObjectCollection("plantemplatemember").size()) > 10000) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u9884\u89c8\u5931\u8d25\uff0c\u4e00\u7ea7\u884c\u7ef4\u56fa\u5b9a\u6210\u5458\u6570\u91cf*\u4e8c\u7ea7\u884c\u7ef4\u56fa\u5b9a\u6210\u5458\u6570\u91cf\u4e0d\u53ef\u5927\u4e8e10000\uff0c\u8bf7\u786e\u8ba4\u6210\u5458\u8303\u56f4\u3002", (String)"TemplateInfoSaveValidator_27", (String)"tmc-fpm-business", (Object[])new Object[0]));
                }
            } else if (DimLevelEnum.TWO.getValue().equals(oneObj.getInt("level"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4e00\u7ea7\u7ef4\u5ea6\u7684\u60c5\u51b5\u4e0b\u7ef4\u5ea6\u7ea7\u522b\u4e0d\u80fd\u9009\u62e9\u4e8c\u7ea7\u3002", (String)"TemplateInfoSaveValidator_28", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
        }
    }

    private void checkColMemberCount(ExtendedDataEntity dataEntity, DynamicObject dynamicObject) {
        int count = dynamicObject.getDynamicObjectCollection("plantemplatemember").size();
        DynamicObject dimObject = dynamicObject.getDynamicObject("dimbd");
        String dimName = dimObject.getString("name");
        if (count > 100) {
            String errorMsg = ResManager.loadKDString((String)"\u4fdd\u5b58\u9884\u89c8\u5931\u8d25\uff0c\u5217\u7ef4\u3010%1$s\u3011\u6210\u5458\u6570\u91cf\u4e0d\u53ef\u8d85\u8fc7100\u4e2a\uff0c\u8bf7\u786e\u8ba4\u6210\u5458\u8303\u56f4\u3002", (String)"TemplateInfoSaveValidator_29", (String)"tmc-fpm-business", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, String.format(errorMsg, dimName));
        }
    }
}

