/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.olap.common.datasource;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fpm.olap.common.datasource.ShrekDataSource;

public class ShrekDataSourceManager {
    public static final String PROVIDER = "kingdee.olap.Shrek";
    public static final String URL = "http://{0}:{1}/bos-olap-webserver/services/httpolap";

    public static ShrekDataSource getCurrent() {
        String prop = String.join((CharSequence)",", "configkey", "configvalue");
        DynamicObject[] configs = BusinessDataServiceHelper.load((String)"fpm_global_config", (String)prop, (QFilter[])new QFilter[]{new QFilter("configgroup", "=", (Object)"mddconfiggroup")});
        if (configs == null || configs.length == 0) {
            throw new KDBizException("ShrekOlap create connect error, please check config.");
        }
        Map<String, String> configMap = Arrays.stream(configs).collect(Collectors.toMap(k -> k.getString("configkey"), v -> v.getString("configvalue")));
        String serverAddress = configMap.get("serveraddress");
        String serverPort = configMap.get("port");
        String username = configMap.get("username");
        String password = configMap.get("password");
        return new ShrekDataSource(serverAddress, serverPort, username, password);
    }

    public static String getUrl(ShrekDataSource dataSource) {
        return MessageFormat.format(URL, dataSource.getIp(), dataSource.getPort());
    }
}

