/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.olap.job;

import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTracer;
import kd.tmc.fpm.olap.enums.ShrekSyncStatus;
import kd.tmc.fpm.olap.model.ShrekSyncLog;
import kd.tmc.fpm.olap.service.log.SyncLogQueryService;
import kd.tmc.fpm.olap.service.log.impl.SyncLogQueryServiceImpl;
import kd.tmc.fpm.olap.service.shrek.ShrekDataHandleService;
import kd.tmc.fpm.olap.service.shrek.impl.ShrekDataHandleServiceImpl;

public class ShrekSyncFailRedoTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(ShrekSyncFailRedoTask.class);
    public static final Integer MAX_TOP = 100;
    private SyncLogQueryService logQueryService = new SyncLogQueryServiceImpl();
    private ShrekDataHandleService dataHandleService = new ShrekDataHandleServiceImpl();

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try (IFpmTracer tracer = IFpmTracer.getInstance();){
            try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan("ShrekSyncFailRedoTask");){
                span.addTag("task start");
                List<ShrekSyncLog> syncFailLogs = this.logQueryService.loadLogsByStatus(ShrekSyncStatus.SYNC_FAILED, MAX_TOP);
                this.dataHandleService.handleReportDataToOlap(syncFailLogs);
                span.addTag("task end");
            }
            catch (Exception e) {
                logger.error("ShrekSyncFailRedoTask error", (Throwable)e);
            }
            tracer.print();
        }
    }
}

