/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.olap.service.command.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.OlapDataWriter;
import kd.tmc.fpm.common.utils.FpmAssertUtil;
import kd.tmc.fpm.olap.command.ShrekBatchSaveCommand;
import kd.tmc.fpm.olap.enums.ShrekCommandType;
import kd.tmc.fpm.olap.model.ShrekDimension;
import kd.tmc.fpm.olap.model.ShrekMember;
import kd.tmc.fpm.olap.model.ShrekMetaData;
import kd.tmc.fpm.olap.service.command.ShrekCommandService;
import kd.tmc.fpm.olap.service.shrek.ShrekConnectService;
import kd.tmc.fpm.olap.service.shrek.ShrekWriterService;
import kd.tmc.fpm.olap.service.shrek.impl.ShrekConnectServiceImpl;
import kd.tmc.fpm.olap.service.shrek.impl.ShrekWriterServiceImpl;
import kd.tmc.fpm.olap.utils.ShrekExceptionUtil;

public class ShrekBatchSaveServiceImpl
implements ShrekCommandService {
    private static final Log logger = LogFactory.getLog(ShrekBatchSaveServiceImpl.class);
    private ShrekBatchSaveCommand command;
    private ShrekConnectService connectService;
    private ShrekWriterService writerService;

    public ShrekBatchSaveServiceImpl(ShrekBatchSaveCommand command) {
        this.command = command;
        this.connectService = new ShrekConnectServiceImpl();
        this.writerService = new ShrekWriterServiceImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        FpmAssertUtil.isNotNull((Object)this.command, (String)"command is null");
        FpmAssertUtil.isNotNull((Object)this.command.getMetaData(), (String)"meta data is null");
        FpmAssertUtil.isNotEmpty(this.command.getValueMap(), (String)"value is null");
        logger.info("ShrekBatchSaveService execute start");
        OlapConnection conn = null;
        try {
            ShrekMetaData metaData = this.command.getMetaData();
            conn = this.connectService.getConnection(metaData.getCubeNumber());
            ShrekBatchSaveCommand.ValueMap valueMap = this.command.getValueMap().get(0);
            List<String> dimNumbers = valueMap.getDimensionList().stream().map(ShrekDimension::getNumber).collect(Collectors.toList());
            OlapDataWriter writer = this.writerService.createWriter(conn, dimNumbers);
            for (ShrekBatchSaveCommand.ValueMap map : this.command.getValueMap()) {
                BigDecimal value = map.getValue();
                Map<String, List> dimMap = map.getDimensionList().stream().collect(Collectors.toMap(ShrekDimension::getNumber, ShrekDimension::getDimMembers));
                ArrayList<String> members = new ArrayList<String>();
                for (String dim : dimNumbers) {
                    members.addAll(dimMap.get(dim).stream().map(ShrekMember::getNumber).collect(Collectors.toList()));
                }
                ShrekCommandType commandType = map.getCommandType();
                switch (commandType) {
                    case CREATE: 
                    case UPDATE: {
                        this.writerService.saveData(writer, members, value);
                        break;
                    }
                    case DELETE: {
                        this.writerService.deleteData(writer, members);
                        break;
                    }
                }
            }
            this.writerService.flush(writer);
            this.connectService.close(conn);
        }
        catch (Exception e) {
            try {
                logger.error("ShrekBatchSaveService execute error", (Throwable)e);
                ShrekExceptionUtil.packException(e);
                this.connectService.close(conn);
            }
            catch (Throwable throwable) {
                this.connectService.close(conn);
                throw throwable;
            }
        }
        logger.info("ShrekBatchSaveService execute end");
    }
}

