/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.olap.service.command.impl;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.OlapConnection;
import kd.tmc.fpm.common.utils.FpmAssertUtil;
import kd.tmc.fpm.olap.command.ShrekSyncCommand;
import kd.tmc.fpm.olap.service.command.ShrekCommandService;
import kd.tmc.fpm.olap.service.shrek.ShrekConnectService;
import kd.tmc.fpm.olap.service.shrek.ShrekCubeService;
import kd.tmc.fpm.olap.service.shrek.ShrekMeasureService;
import kd.tmc.fpm.olap.service.shrek.impl.ShrekConnectServiceImpl;
import kd.tmc.fpm.olap.service.shrek.impl.ShrekCubeServiceImpl;
import kd.tmc.fpm.olap.service.shrek.impl.ShrekMeasureServiceImpl;
import kd.tmc.fpm.olap.utils.ShrekExceptionUtil;

public class ShrekCubeSyncServiceImpl
implements ShrekCommandService {
    private static final Log logger = LogFactory.getLog(ShrekCubeSyncServiceImpl.class);
    private ShrekSyncCommand syncCommand;
    private ShrekCubeService cubeService;
    private ShrekMeasureService measureService;
    private ShrekConnectService connectService;

    public ShrekCubeSyncServiceImpl(ShrekSyncCommand syncCommand) {
        this.syncCommand = syncCommand;
        this.cubeService = new ShrekCubeServiceImpl();
        this.connectService = new ShrekConnectServiceImpl();
        this.measureService = new ShrekMeasureServiceImpl();
    }

    @Override
    public void execute() {
        FpmAssertUtil.isNotNull((Object)this.syncCommand, (String)"command is null");
        FpmAssertUtil.isNotNull((Object)this.syncCommand.getMetaData(), (String)"meta data is null");
        logger.info("ShrekCubeSyncService executeSync start");
        OlapConnection conn = null;
        try {
            conn = this.connectService.getEmptyConnection();
            this.connectService.openConnection(conn);
            String cubeNumber = this.syncCommand.getMetaData().getCubeNumber();
            if (!this.cubeService.existCube(conn, cubeNumber)) {
                this.cubeService.createCube(conn, cubeNumber);
            }
            this.connectService.close(conn);
            conn = this.connectService.getConnection(cubeNumber);
            this.measureService.createMeasure(conn, cubeNumber, "FMONEY");
        }
        catch (Exception e) {
            logger.error("ShrekCubeSyncService executeSync error", (Throwable)e);
            ShrekExceptionUtil.packException(e);
        }
        finally {
            this.connectService.close(conn);
        }
        logger.info("ShrekCubeSyncService executeSync end");
    }
}

