/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.olap.service.log.impl;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fpm.common.utils.FpmAssertUtil;
import kd.tmc.fpm.olap.model.ShrekSyncLog;
import kd.tmc.fpm.olap.service.log.SyncLogSaveService;

public class SyncLogSaveServiceImpl
implements SyncLogSaveService {
    @Override
    public void create(List<ShrekSyncLog> logList) {
        if (CollectionUtils.isEmpty(logList)) {
            return;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"fpm_olapsynclog");
        DynamicObject[] logArr = (DynamicObject[])logList.stream().map(o -> {
            DynamicObject obj = new DynamicObject((DynamicObjectType)entityType);
            obj.set("id", (Object)DB.genGlobalLongId());
            obj.set("entityid", (Object)o.getEntityId());
            obj.set("entityname", (Object)o.getEntityName());
            obj.set("synctype", (Object)o.getLogType().name());
            obj.set("syncstatus", (Object)o.getSyncStatus().name());
            obj.set("bodysystem", (Object)o.getSystemId());
            return obj;
        }).toArray(DynamicObject[]::new);
        SaveServiceHelper.save((DynamicObject[])logArr);
    }

    @Override
    public void update(List<ShrekSyncLog> logList) {
        if (CollectionUtils.isEmpty(logList)) {
            return;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"fpm_olapsynclog");
        DynamicObject[] logArr = (DynamicObject[])logList.stream().map(o -> {
            FpmAssertUtil.isNotNull((Object)o.getId(), (String)"log id is empty");
            DynamicObject obj = new DynamicObject((DynamicObjectType)entityType);
            obj.set("id", (Object)o.getId());
            obj.set("syncstatus", (Object)o.getSyncStatus().name());
            return obj;
        }).toArray(DynamicObject[]::new);
        SaveServiceHelper.update((DynamicObject[])logArr);
    }
}

