/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.olap.service.shrek.impl;

import kd.bos.context.RequestContext;
import kd.bos.olap.common.CommandTypes;
import kd.bos.olap.common.PropertyBag;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.MetadataCommandInfo;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.metadata.MetadataTypes;
import kd.tmc.fpm.common.utils.FpmAssertUtil;
import kd.tmc.fpm.olap.service.shrek.ShrekCubeService;
import kd.tmc.fpm.olap.service.shrek.ShrekMetaDataService;
import kd.tmc.fpm.olap.service.shrek.impl.ShrekMetaDataServiceImpl;
import kd.tmc.fpm.olap.utils.TraceIdUtil;

public class ShrekCubeServiceImpl
implements ShrekCubeService {
    private ShrekMetaDataService mateDataService = new ShrekMetaDataServiceImpl();

    @Override
    public void createCube(OlapConnection conn, String cubeName) {
        FpmAssertUtil.isNotNull((Object)conn, (String)"olap connect is null");
        FpmAssertUtil.isNotBlank((String)cubeName, (String)"cubeName is null");
        MetadataCommandInfo meta = new MetadataCommandInfo();
        meta.setAction(CommandTypes.create);
        meta.setMetadataType(MetadataTypes.Cube);
        meta.setName(cubeName);
        meta.getProperties().set("caption", cubeName + RequestContext.get().getTenantId());
        TraceIdUtil.setTraceInfo((CommandInfo)meta);
        OlapCommand command = new OlapCommand(conn, (CommandInfo)meta);
        command.executeNonQuery();
    }

    @Override
    public boolean existCube(OlapConnection conn, String cubeName) {
        FpmAssertUtil.isNotNull((Object)conn, (String)"olap connect is null");
        FpmAssertUtil.isNotBlank((String)cubeName, (String)"cubeName is null");
        PropertyBag metaData = this.mateDataService.getMetaData(conn, "", cubeName, false);
        return Boolean.parseBoolean(metaData.get("exist"));
    }

    @Override
    public void dropCube(OlapConnection conn, String cubeName) {
        FpmAssertUtil.isNotNull((Object)conn, (String)"olap connect is null");
        FpmAssertUtil.isNotBlank((String)cubeName, (String)"cubeName is null");
        MetadataCommandInfo meta = new MetadataCommandInfo();
        meta.setAction(CommandTypes.drop);
        meta.setMetadataType(MetadataTypes.Cube);
        meta.setName(cubeName.trim());
        TraceIdUtil.setTraceInfo((CommandInfo)meta);
        OlapCommand command = new OlapCommand(conn, (CommandInfo)meta);
        command.executeNonQuery();
    }
}

