/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.olap.service.shrek.impl;

import java.util.List;
import kd.bos.olap.common.CommandTypes;
import kd.bos.olap.common.PropertyBag;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.MetadataCommandInfo;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.metadata.MetadataTypes;
import kd.tmc.fpm.olap.service.shrek.ShrekDimensionService;
import kd.tmc.fpm.olap.service.shrek.ShrekMetaDataService;
import kd.tmc.fpm.olap.service.shrek.impl.ShrekMetaDataServiceImpl;
import kd.tmc.fpm.olap.utils.ShrekIdUtil;

public class ShrekDimensionServiceImpl
implements ShrekDimensionService {
    private ShrekMetaDataService mateDataService = new ShrekMetaDataServiceImpl();

    @Override
    public void createDimension(OlapConnection conn, String cubeName, List<String> dimensions) {
        for (String dimension : dimensions) {
            this.createDimension(conn, cubeName, dimension);
        }
    }

    @Override
    public void createDimension(OlapConnection conn, String cubeName, String dimension) {
        if (this.existDimension(conn, cubeName, dimension)) {
            return;
        }
        MetadataCommandInfo meta = new MetadataCommandInfo();
        meta.setAction(CommandTypes.create);
        meta.setMetadataType(MetadataTypes.Dimension);
        meta.setName(dimension);
        meta.setOwnerUniqueName(cubeName);
        meta.setDefaultMemberName(ShrekIdUtil.getNoneNumber(dimension));
        OlapCommand command = new OlapCommand(conn, (CommandInfo)meta);
        command.executeNonQuery();
    }

    @Override
    public boolean existDimension(OlapConnection conn, String cubeName, String dimension) {
        PropertyBag metaData = this.mateDataService.getMetaData(conn, cubeName, dimension, false);
        return Boolean.parseBoolean(metaData.get("exist"));
    }

    @Override
    public void deleteDimension(OlapConnection conn, String cubeName, String dimension) {
        if (!this.existDimension(conn, cubeName, dimension)) {
            return;
        }
        MetadataCommandInfo meta = new MetadataCommandInfo();
        meta.setAction(CommandTypes.drop);
        meta.setMetadataType(MetadataTypes.Dimension);
        meta.setName(dimension);
        meta.setOwnerUniqueName(cubeName);
        OlapCommand command = new OlapCommand(conn, (CommandInfo)meta);
        command.executeNonQuery();
    }
}

