/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.olap.service.shrek.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import kd.bos.olap.common.CommandTypes;
import kd.bos.olap.dataSources.AggFactorMetadataItem;
import kd.bos.olap.dataSources.AggOperators;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.MemberMetadataItem;
import kd.bos.olap.dataSources.MetadataCommandInfo;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.metadata.MemberStorageTypes;
import kd.bos.olap.metadata.MetadataTypes;
import kd.bos.orm.util.StringUtils;
import kd.tmc.fpm.common.utils.FpmAssertUtil;
import kd.tmc.fpm.olap.model.ShrekMember;
import kd.tmc.fpm.olap.service.shrek.ShrekDynamicCalcService;
import kd.tmc.fpm.olap.utils.TraceIdUtil;

public class ShrekDynamicCalcServiceImpl
implements ShrekDynamicCalcService {
    @Override
    public void updateDynamicCalc(OlapConnection conn, String cubeName, String dimension, List<ShrekMember> members) {
        FpmAssertUtil.isNotBlank((String)cubeName, (String)"cubeNumber is null");
        FpmAssertUtil.isNotNull((Object)dimension, (String)"dimension is null");
        FpmAssertUtil.isNotEmpty(members, (String)"members list is empty");
        MetadataCommandInfo meta = new MetadataCommandInfo();
        meta.setAction(CommandTypes.alter);
        meta.setMetadataType(MetadataTypes.Member);
        meta.setOwnerUniqueName(cubeName + "." + dimension);
        List items = meta.getItems();
        for (ShrekMember member : members) {
            MemberMetadataItem item = new MemberMetadataItem(member.getNumber());
            if (member.getNeedLeafCalc().booleanValue()) {
                if (member.isLeaf()) {
                    item.setStorageType(MemberStorageTypes.Stored);
                    item.setFactors(Collections.emptyList());
                } else {
                    item.setStorageType(MemberStorageTypes.DynamicCalc);
                    item = this.updateChild(member, item);
                }
            } else if (Objects.nonNull(member.getFormulaMap()) && member.getFormulaMap().size() > 0) {
                this.fillFormulaMemberMetadataItem(member, item);
            } else {
                item.setStorageType(MemberStorageTypes.Stored);
            }
            items.add(item);
        }
        if (!items.isEmpty()) {
            TraceIdUtil.setTraceInfo((CommandInfo)meta);
            OlapCommand command = new OlapCommand(conn, (CommandInfo)meta);
            command.executeNonQuery();
        }
    }

    private MemberMetadataItem updateChild(ShrekMember member, MemberMetadataItem item) {
        if (member == null || item == null) {
            return item;
        }
        if (Objects.nonNull(member.getFormulaMap()) && member.getFormulaMap().size() > 0) {
            return this.fillFormulaMemberMetadataItem(member, item);
        }
        List<ShrekMember> children = member.getChildren();
        ArrayList<AggFactorMetadataItem> aggItems = new ArrayList<AggFactorMetadataItem>(children.size());
        HashSet<String> existChild = new HashSet<String>(children.size());
        int in = children.size();
        for (int i = 0; i < in; ++i) {
            ShrekMember childMember = member.getChildren().get(i);
            if (!existChild.add(childMember.getNumber())) continue;
            AggOperators aggOperators = null;
            String aggType = childMember.getAggType();
            if (StringUtils.isEmpty((Object)aggType)) continue;
            switch (aggType) {
                case "PLUS": {
                    aggOperators = AggOperators.PLUS;
                    break;
                }
                case "SUBTRACT": {
                    aggOperators = AggOperators.SUBTRACT;
                    break;
                }
                case "IGNORE": {
                    break;
                }
            }
            if (Objects.isNull(aggOperators)) continue;
            aggItems.add(new AggFactorMetadataItem(childMember.getNumber(), aggOperators));
        }
        if (!aggItems.isEmpty()) {
            item.repairFactors(aggItems);
        } else {
            item.setFactors(aggItems);
        }
        return item;
    }

    private MemberMetadataItem fillFormulaMemberMetadataItem(ShrekMember member, MemberMetadataItem item) {
        item.setStorageType(MemberStorageTypes.DynamicCalc);
        ArrayList aggItems = new ArrayList(member.getFormulaMap().size());
        member.getFormulaMap().forEach((number, formula) -> {
            if (AggOperators.PLUS.name().equals(formula)) {
                aggItems.add(new AggFactorMetadataItem(number, AggOperators.PLUS));
            } else if (AggOperators.SUBTRACT.name().equals(formula)) {
                aggItems.add(new AggFactorMetadataItem(number, AggOperators.SUBTRACT));
            }
        });
        if (!aggItems.isEmpty()) {
            item.repairFactors(aggItems);
        } else {
            item.setFactors(aggItems);
        }
        return item;
    }
}

