/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.olap.service.shrek.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.common.PropertyBag;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.bos.olap.dataSources.DynamicCalcVersion;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.OlapDataReader;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.olap.metadata.IMetadataBuilder;
import kd.bos.olap.metadata.StringMetadataBuilder;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.olap.model.ShrekDimension;
import kd.tmc.fpm.olap.model.ShrekMember;
import kd.tmc.fpm.olap.model.ShrekReportData;
import kd.tmc.fpm.olap.service.shrek.ShrekConnectService;
import kd.tmc.fpm.olap.service.shrek.ShrekMetaDataService;
import kd.tmc.fpm.olap.service.shrek.ShrekQueryService;
import kd.tmc.fpm.olap.service.shrek.impl.ShrekConnectServiceImpl;
import kd.tmc.fpm.olap.service.shrek.impl.ShrekMetaDataServiceImpl;

public class ShrekQueryServiceImpl
implements ShrekQueryService {
    private static final Log logger = LogFactory.getLog(ShrekQueryServiceImpl.class);
    private ShrekConnectService connectService;
    private ShrekMetaDataService mateDataService = new ShrekMetaDataServiceImpl();

    public ShrekQueryServiceImpl() {
        this.connectService = new ShrekConnectServiceImpl();
    }

    @Override
    public List<ShrekDimension> loadAllDimension(OlapConnection connection) {
        PropertyBag propertyBag = this.mateDataService.getMetaData(connection, "", "", true);
        String metaData = propertyBag.get("children");
        String[] dim = metaData.contains(System.lineSeparator()) ? metaData.split(System.lineSeparator()) : metaData.split("\n");
        if (dim.length == 0) {
            return Collections.emptyList();
        }
        List result = Arrays.stream(dim).filter(item -> !"FMONEY".equals(item)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(result)) {
            return Collections.emptyList();
        }
        return result.stream().map(item -> {
            ShrekDimension shrekDimension = new ShrekDimension();
            shrekDimension.setNumber((String)item);
            return shrekDimension;
        }).collect(Collectors.toList());
    }

    @Override
    public List<ShrekDimension> loadAllMember(OlapConnection connection, ShrekDimension dimension) {
        PropertyBag metaData = this.mateDataService.getMetaData(connection, "", dimension.getNumber(), true);
        String[] children = metaData.get("children").split(System.lineSeparator());
        if (children.length == 0) {
            return Collections.emptyList();
        }
        List result = Arrays.stream(children).filter(item -> !"FMONEY".equals(item)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(result)) {
            return Collections.emptyList();
        }
        return result.stream().map(item -> {
            ShrekDimension shrekDimension = new ShrekDimension();
            shrekDimension.setNumber((String)item);
            return shrekDimension;
        }).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(OlapConnection connection, String dimension, String member) {
        SelectCommandInfo selectInfo = new SelectCommandInfo();
        selectInfo.addDims(new String[]{dimension});
        selectInfo.addMeasures(new String[]{"FPlanAmt"});
        selectInfo.addFilter(dimension, new String[]{member});
        Object result = null;
        try (OlapDataReader reader = null;){
            reader = new OlapCommand(connection, (CommandInfo)selectInfo).executeReader((IMetadataBuilder)StringMetadataBuilder.INSTANCE);
            while (reader.next()) {
                Object[] values = new Object[reader.getFieldCount()];
                reader.getValues(values);
                result = values[0];
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ShrekReportData> loadData(String cubeName, List<ShrekDimension> dims, boolean excludeDynamicCalcResult) {
        ArrayList<ShrekReportData> reportDataList = new ArrayList<ShrekReportData>(256);
        try (OlapDataReader reader = null;
             OlapConnection connection = this.connectService.getConnection(cubeName);){
            List<ShrekDimension> olapAllDims = this.loadAllDimension(connection);
            List<String> olapAllDimsNumbers = olapAllDims.stream().map(ShrekDimension::getNumber).collect(Collectors.toList());
            SelectCommandInfo selectInfo = new SelectCommandInfo();
            selectInfo.setDimensions(olapAllDimsNumbers);
            selectInfo.addMeasures(new String[]{"FMONEY"});
            ArrayList<DimensionFilterItem> dimensionFilterItems = new ArrayList<DimensionFilterItem>(dims.size());
            for (ShrekDimension dimension : dims) {
                DimensionFilterItem filterItem = new DimensionFilterItem();
                filterItem.setName(dimension.getNumber());
                List values = dimension.getAllDimMemberList().stream().map(ShrekMember::getNumber).collect(Collectors.toList());
                filterItem.setValues(values);
                dimensionFilterItems.add(filterItem);
            }
            selectInfo.setDynamicCalcVersion(DynamicCalcVersion.V2);
            selectInfo.setFilter(dimensionFilterItems);
            selectInfo.setExcludeNull(true);
            selectInfo.setIncludeDynamicMemberWhenNullFilter(true);
            selectInfo.setExcludeDynamicCalcResult(excludeDynamicCalcResult);
            reader = new OlapCommand(connection, (CommandInfo)selectInfo).executeReader((IMetadataBuilder)StringMetadataBuilder.INSTANCE);
            int metricIndex = olapAllDimsNumbers.indexOf(DimsionEnums.METRIC.getNumber());
            while (reader.next()) {
                int fieldCount = reader.getFieldCount();
                Object[] values = new Object[fieldCount];
                reader.getValues(values);
                ArrayList<String> members = new ArrayList<String>();
                for (int i = 1; i < values.length; ++i) {
                    String member = values[i].toString();
                    if (member.contains("None")) {
                        members.add("0");
                        continue;
                    }
                    members.add(member);
                }
                ShrekReportData reportData = new ShrekReportData();
                reportData.setDimensions(olapAllDimsNumbers);
                reportData.setMembers(members);
                BigDecimal value = BigDecimal.ZERO;
                if (Objects.nonNull(values[0])) {
                    value = new BigDecimal(values[0].toString());
                }
                String metricMember = (String)members.get(metricIndex);
                reportData.setMetricCode(metricMember);
                reportData.setMetricValue(value);
                reportDataList.add(reportData);
            }
        }
        return reportDataList;
    }
}

