/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.olap.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.servicehelper.DBServiceHelper;
import kd.tmc.fpm.olap.utils.NumberUtils;

public class ShrekIdUtil {
    public static String getCubeNumber(String id, String number) {
        return ShrekIdUtil.replaceBlock(id + number);
    }

    public static String getDimNumber(String number) {
        return ShrekIdUtil.replaceByRegEx(number);
    }

    public static String getDefaultMemberNumber(String number) {
        return ShrekIdUtil.replaceByRegEx(number);
    }

    public static String getNoneNumber(String number) {
        return ShrekIdUtil.replaceBlock(number + "None");
    }

    public static String getRootNumber(String number) {
        return ShrekIdUtil.replaceBlock(number + "Root");
    }

    public static String getSpecialMemberNumber(String id, String number) {
        return ShrekIdUtil.replaceBlock(id + number);
    }

    private static String replaceByRegEx(String number) {
        String trimStr = ShrekIdUtil.replaceBlock(number);
        if (!NumberUtils.checkKeyword(trimStr)) {
            return DBServiceHelper.genGlobalLongId() + "";
        }
        String regEx = trimStr.length() == 1 ? "^[a-zA-Z0-9]" : "^[a-zA-Z0-9](?!.*?\\.\\.)[-a-zA-Z0-9_.]+$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(trimStr);
        if (matcher.matches()) {
            return trimStr;
        }
        return DBServiceHelper.genGlobalLongId() + "";
    }

    private static String replaceBlock(String number) {
        return number.replaceAll(" ", "");
    }
}

