/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.olap.utils;

import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.olap.dataSources.CommandInfo;

public final class TraceIdUtil {
    public static final String TRACE_INFO = "traceId";

    public static void setTraceInfo(CommandInfo commandInfo) {
        if (commandInfo == null) {
            return;
        }
        if (commandInfo.getExtProperties() == null) {
            commandInfo.setExtProperties(new HashMap(8));
        }
        String traceId = RequestContext.get().getTraceId();
        commandInfo.getExtProperties().put(TRACE_INFO, Long.toString(TraceIdUtil.hexToId(traceId)));
    }

    public static long hexToId(String hexString) {
        int length = hexString.length();
        if (length >= 1 && length <= 32) {
            int beginIndex = length > 16 ? length - 16 : 0;
            return TraceIdUtil.hexToId(hexString, beginIndex);
        }
        throw new IllegalArgumentException("Malformed id: " + hexString);
    }

    public static long hexToId(String lowerHex, int index) {
        long result = 0L;
        int endIndex = Math.min(index + 16, lowerHex.length());
        while (index < endIndex) {
            char c = lowerHex.charAt(index);
            result <<= 4;
            if (c >= '0' && c <= '9') {
                result |= (long)(c - 48);
            } else {
                if (c < 'a' || c > 'f') {
                    throw new IllegalArgumentException("Malformed id: " + lowerHex);
                }
                result |= (long)(c - 97 + 10);
            }
            ++index;
        }
        return result;
    }
}

