/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.spread.utils;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.tmc.fpm.spread.utils.Point;
import kd.tmc.fpm.spread.utils.RangeModel;
import org.apache.commons.lang3.StringUtils;

public class ExcelUtils {
    private static final int ZeroCharValue = 48;

    public static int pos2X(String pos) {
        int colAxisIndex = ExcelUtils.getColAxisIndex(pos);
        return ExcelUtils.pos2X(pos, colAxisIndex);
    }

    private static int pos2X(String pos, int colAxisIndex) {
        int count = -1;
        for (int i = 0; i < colAxisIndex; ++i) {
            char c = pos.charAt(i);
            count = c >= 'a' && c <= 'z' ? (int)((double)count + (double)(c - 96) * Math.pow(26.0, colAxisIndex - 1 - i)) : (int)((double)count + (double)(c - 64) * Math.pow(26.0, colAxisIndex - 1 - i));
        }
        return count;
    }

    public static int pos2Y(String pos) {
        int colAxisIndex = ExcelUtils.getColAxisIndex(pos);
        return ExcelUtils.pos2Y(pos, colAxisIndex);
    }

    private static int pos2Y(String pos, int colAxisIndex) {
        int result = 0;
        int j = 1;
        for (int i = pos.length() - 1; i >= colAxisIndex; --i) {
            char c = pos.charAt(i);
            if (c >= '0' && c <= '9') {
                result += (c - 48) * j;
            } else {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8868\u683c\u5750\u6807\u65e0\u6548\uff0c%1$s\u3002", (String)"ExcelUtils_0", (String)"tmc-fpm-spread", (Object[])new Object[0]), pos));
            }
            j *= 10;
        }
        return result - 1;
    }

    private static int getColAxisIndex(String pos) {
        if (pos.length() > 1 && Character.isLetter(pos.charAt(0)) && !Character.isLetter(pos.charAt(1))) {
            return 1;
        }
        for (int index = 2; index < pos.length(); ++index) {
            if (Character.isLetter(pos.charAt(index))) continue;
            return index;
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8868\u683c\u5750\u6807\u65e0\u6548\uff0c%1$s\u3002", (String)"ExcelUtils_0", (String)"tmc-fpm-spread", (Object[])new Object[0]), pos));
    }

    @Deprecated
    public static int[] pos2XY(String pos) {
        int[] xy = new int[2];
        int colAxisIndex = ExcelUtils.getColAxisIndex(pos);
        xy[0] = ExcelUtils.pos2X(pos, colAxisIndex);
        xy[1] = ExcelUtils.pos2Y(pos, colAxisIndex);
        return xy;
    }

    public static Point pos2Point(String pos) {
        int colAxisIndex = ExcelUtils.getColAxisIndex(pos);
        return new Point(ExcelUtils.pos2X(pos, colAxisIndex), ExcelUtils.pos2Y(pos, colAxisIndex));
    }

    public static Point pos2Point(String pos, boolean needEndPoint) {
        Point result;
        String[] points = pos.split(":");
        if (points.length != 2) {
            throw new KDBizException(pos + " is not a range");
        }
        if (needEndPoint) {
            int colAxisIndex = ExcelUtils.getColAxisIndex(points[1]);
            result = new Point(ExcelUtils.pos2X(points[1], colAxisIndex), ExcelUtils.pos2Y(points[1], colAxisIndex));
        } else {
            int colAxisIndex = ExcelUtils.getColAxisIndex(points[0]);
            result = new Point(ExcelUtils.pos2X(points[0], colAxisIndex), ExcelUtils.pos2Y(points[0], colAxisIndex));
        }
        return result;
    }

    public static boolean isOverlap(String rec1, String rec2) {
        RangeModel a = new RangeModel(rec1);
        RangeModel b = new RangeModel(rec2);
        return Math.max(a.getXStart(), b.getXStart()) <= Math.min(a.getXEnd(), b.getXEnd()) && Math.max(a.getYStart(), b.getYStart()) <= Math.min(a.getYEnd(), b.getYEnd());
    }

    public static String xy2Pos(int x, int y) {
        Preconditions.checkArgument((x >= 0 ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u8868\u683c\u5750\u6807\u65e0\u6548!", (String)"ExcelUtils_3", (String)"tmc-fpm-spread", (Object[])new Object[0]));
        String xAxis = ExcelUtils.int2pos(x);
        return xAxis + (y + 1);
    }

    public static String int2pos(int intVal) {
        if (intVal < 0) {
            return null;
        }
        ++intVal;
        char[] tmp = new char[30];
        int i = 29;
        while (i >= 0) {
            int q = intVal / 26;
            int r = intVal % 26;
            if (r < 1) {
                r = 26;
                --q;
            }
            tmp[i--] = (char)(65 + r - 1);
            if (q == 0) break;
            intVal = q;
        }
        return new String(tmp, ++i, tmp.length - i);
    }

    public static RangeModel calcRange(String startPos, String endPos, String dataPos, boolean isCalcColDim) {
        int endY;
        int startY;
        int endX;
        int startX;
        Point start = ExcelUtils.pos2Point(startPos);
        Point end = ExcelUtils.pos2Point(endPos);
        Point data = ExcelUtils.pos2Point(dataPos);
        if (isCalcColDim) {
            startX = data.x;
            endX = end.x;
            startY = start.y;
            endY = data.y - 1;
        } else {
            startX = start.x;
            endX = data.x - 1;
            startY = data.y;
            endY = end.y;
        }
        return new RangeModel(startX, endX, startY, endY);
    }

    public static String checkPosValidata(String startPos, String endPos, String dataPos) {
        int startPosX = ExcelUtils.pos2X(startPos);
        int startPosY = ExcelUtils.pos2Y(startPos);
        int endPosX = ExcelUtils.pos2X(endPos);
        int endPosY = ExcelUtils.pos2Y(endPos);
        int dataPosX = ExcelUtils.pos2X(dataPos);
        int dataPosY = ExcelUtils.pos2Y(dataPos);
        StringBuilder msg = new StringBuilder();
        if (endPosX < startPosX || endPosY < startPosY) {
            msg.append(ResManager.loadKDString((String)"\u533a\u57df\u8303\u56f4\u65e0\u6548\u3002\u8bf7\u786e\u4fdd\u7ed3\u675f\u5355\u5143\u683c\u4f4d\u4e8e\u5f00\u59cb\u5355\u5143\u683c\u53f3\u4e0b\u65b9\u3002", (String)"ExcelUtils_1", (String)"tmc-fpm-spread", (Object[])new Object[0]));
        } else if (dataPosX < startPosX || dataPosY < startPosY || dataPosX > endPosX || dataPosY > endPosY) {
            msg.append(ResManager.loadKDString((String)"\u6570\u636e\u5f00\u59cb\u5355\u5143\u683c\u4e0d\u5728\u533a\u57df\u8303\u56f4\u5185\u3002", (String)"ExcelUtils_2", (String)"tmc-fpm-spread", (Object[])new Object[0]));
        }
        return msg.toString();
    }

    public static boolean isWithInScope(String areaRange, String startPosition) {
        String[] arrs = areaRange.split(":");
        return StringUtils.isEmpty((CharSequence)ExcelUtils.checkPosValidata(arrs[0], arrs[1], startPosition));
    }

    public static String[] calColAxisSerial(String areaRange) {
        String[] splitArr = areaRange.split(":");
        int colstart = ExcelUtils.pos2X(splitArr[0]);
        int colend = ExcelUtils.pos2X(splitArr[1]);
        ArrayList<String> colAxisSerial = new ArrayList<String>(colend - colstart + 1);
        for (int i = colstart; i <= colend; ++i) {
            colAxisSerial.add(ExcelUtils.int2pos(i));
        }
        return colAxisSerial.toArray(new String[0]);
    }

    public static String[] calRowAxisSerial(String areaRange) {
        String[] splitArr = areaRange.split(":");
        int rowstart = ExcelUtils.pos2Y(splitArr[0]);
        int rowend = ExcelUtils.pos2Y(splitArr[1]);
        ArrayList<String> colAxisSerial = new ArrayList<String>(rowend - rowstart + 1);
        for (int i = rowstart; i <= rowend; ++i) {
            colAxisSerial.add(String.valueOf(i + 1));
        }
        return colAxisSerial.toArray(new String[0]);
    }

    public static String offsetAxisByRow(String pos, int offset) {
        int y = ExcelUtils.pos2Y(pos);
        int x = ExcelUtils.pos2X(pos);
        return ExcelUtils.xy2Pos(x, y += offset);
    }

    public static String offsetAxisByCol(String pos, int offset) {
        int y = ExcelUtils.pos2Y(pos);
        int x = ExcelUtils.pos2X(pos);
        return ExcelUtils.xy2Pos(x += offset, y);
    }

    public static String converCoord(int row, int col, int rows, int cols) {
        StringBuilder sb = new StringBuilder();
        String s = ExcelUtils.xy2Pos(row, col);
        sb.append(s);
        sb.append(":");
        sb.append(ExcelUtils.offsetAxisByColAndRow(s, rows, cols));
        return sb.toString();
    }

    public static String offsetAxisByColAndRow(String pos, int offsetX, int offsetY) {
        int y = ExcelUtils.pos2Y(pos);
        int x = ExcelUtils.pos2X(pos);
        return ExcelUtils.xy2Pos(x += offsetY, y += offsetX);
    }
}

