/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.spread.widget.core;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.common.enums.CellDimTypeEnum;
import kd.tmc.fpm.spread.widget.CellTypeEnum;
import kd.tmc.fpm.spread.widget.DisplayTypeEnum;
import kd.tmc.fpm.spread.widget.style.CellStyleInfo;

public class Cell
implements Serializable {
    private Object dataId;
    private int row = -1;
    private int col = -1;
    private int rowSpan;
    private int colSpan;
    private int level;
    private Object displayValue;
    private Object value;
    private Object newValue;
    private CellTypeEnum cellType;
    private CellStyleInfo styleInfo;
    private Object widgetValue;
    private Boolean lock;
    private String formula;
    private DisplayTypeEnum displayType;
    private boolean summary;
    private CellDimTypeEnum cellDimType;
    private boolean initDirty;
    private String cellStyleMark;
    private List<Long> sourceIdList;

    public Cell(int row, int col, Object displayValue) {
        this.row = row;
        this.col = col;
        this.displayValue = displayValue;
    }

    public Cell() {
    }

    public void setRowAndCol(int row, int col) {
        this.row = row;
        this.col = col;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cell cell = (Cell)o;
        return this.row == cell.row && this.col == cell.col;
    }

    public int hashCode() {
        return Objects.hash(this.row, this.col);
    }

    public Object getDataId() {
        return this.dataId;
    }

    public void setDataId(Object dataId) {
        this.dataId = dataId;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public int getCol() {
        return this.col;
    }

    public void setCol(int col) {
        this.col = col;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public void setRowSpan(int rowSpan) {
        this.rowSpan = rowSpan;
    }

    public int getColSpan() {
        return this.colSpan;
    }

    public void setColSpan(int colSpan) {
        this.colSpan = colSpan;
    }

    public Object getDisplayValue() {
        return this.displayValue;
    }

    public void setDisplayValue(Object displayValue) {
        this.displayValue = displayValue;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public void setNewValue(Object newValue) {
        this.newValue = newValue;
    }

    public CellTypeEnum getCellType() {
        return this.cellType;
    }

    public void setCellType(CellTypeEnum cellType) {
        this.cellType = cellType;
    }

    public CellStyleInfo getStyleInfo() {
        return this.styleInfo;
    }

    public void setStyleInfo(CellStyleInfo styleInfo) {
        this.styleInfo = styleInfo;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public Object getWidgetValue() {
        return this.widgetValue;
    }

    public void setWidgetValue(Object widgetValue) {
        this.widgetValue = widgetValue;
    }

    public Boolean isLock() {
        return this.lock;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public void setLock(Boolean lock) {
        this.lock = lock;
    }

    public DisplayTypeEnum getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(DisplayTypeEnum displayType) {
        this.displayType = displayType;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean isSummary() {
        return this.summary;
    }

    public void setSummary(boolean summary) {
        this.summary = summary;
    }

    public CellDimTypeEnum getCellDimType() {
        return this.cellDimType;
    }

    public void setCellDimType(CellDimTypeEnum cellDimType) {
        this.cellDimType = cellDimType;
    }

    public boolean isInitDirty() {
        return this.initDirty;
    }

    public void setInitDirty(boolean initDirty) {
        this.initDirty = initDirty;
    }

    public String getStyleInfoMapKey() {
        if (EmptyUtil.isNoEmpty((Object)this.styleInfo)) {
            return this.styleInfo.getStyleUniqueKey();
        }
        return "";
    }

    public String getCellStyleMark() {
        return this.cellStyleMark;
    }

    public void setCellStyleMark(String cellStyleMark) {
        this.cellStyleMark = cellStyleMark;
    }

    public List<Long> getSourceIdList() {
        return this.sourceIdList;
    }

    public void setSourceIdList(List<Long> sourceIdList) {
        this.sourceIdList = sourceIdList;
    }

    public String toString() {
        return "Cell{row=" + this.row + ", col=" + this.col + ", displayValue=" + (BigDecimal.class.isInstance(this.displayValue) ? ((BigDecimal)this.displayValue).toPlainString() : this.displayValue) + ", value=" + (BigDecimal.class.isInstance(this.value) ? ((BigDecimal)this.value).toPlainString() : this.value) + ", newValue=" + (BigDecimal.class.isInstance(this.newValue) ? ((BigDecimal)this.newValue).toPlainString() : this.newValue) + '}';
    }
}

