/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.spread.widget.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.tmc.fpm.spread.widget.CellTypeEnum;
import kd.tmc.fpm.spread.widget.core.Cell;

public class Sheet
implements Serializable {
    private String name;
    private List<Cell> cellList;
    private Cell[][] twoDimCoord;
    private int rowEndInx;
    private int colEndInx;
    private List<Integer> rows;
    private List<Integer> cols;
    private Map<CellTypeEnum, List<Cell>> cellMapByType;

    public List<Cell> getCellList() {
        return this.cellList;
    }

    public void setCellList(List<Cell> cellList) {
        this.cellList = cellList;
        this.rows = new ArrayList<Integer>(10);
        this.cols = new ArrayList<Integer>(10);
        this.cellMapByType = cellList.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(cell -> cell.getCellType()));
        this.init2DimCoord(cellList);
        this.initRowsAndCols(cellList);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Cell[][] getTwoDimCoord() {
        return this.twoDimCoord;
    }

    public List<Integer> getRows() {
        return this.rows;
    }

    public List<Integer> getCols() {
        return this.cols;
    }

    public void setTwoDimCoord(Cell[][] twoDimCoord) {
        this.twoDimCoord = twoDimCoord;
    }

    public void setRows(List<Integer> rows) {
        this.rows = rows;
    }

    public void setCols(List<Integer> cols) {
        this.cols = cols;
    }

    public int getRowEndInx() {
        return this.rowEndInx;
    }

    public void setRowEndInx(int rowEndInx) {
        this.rowEndInx = rowEndInx;
    }

    public int getColEndInx() {
        return this.colEndInx;
    }

    public void setColEndInx(int colEndInx) {
        this.colEndInx = colEndInx;
    }

    private void init2DimCoord(List<Cell> cellList) {
        Map<Integer, List<Cell>> rowGroupCellMap = cellList.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(cell -> cell.getRow()));
        Optional<Map.Entry> maxRowMap = rowGroupCellMap.entrySet().stream().max(Comparator.comparingInt(Map.Entry::getKey));
        this.twoDimCoord = new Cell[(Integer)maxRowMap.get().getKey() + 1][];
        Set<Map.Entry<Integer, List<Cell>>> rowEntries = rowGroupCellMap.entrySet();
        for (Map.Entry<Integer, List<Cell>> rowEntry : rowEntries) {
            Integer rowIndex = rowEntry.getKey();
            List<Cell> cells = rowEntry.getValue();
            Optional<Cell> maxCell = cells.stream().max(Comparator.comparingInt(Cell::getCol));
            Cell[] cellArr = new Cell[maxCell.get().getCol() + 1];
            Iterator<Cell> iterator = cells.iterator();
            while (iterator.hasNext()) {
                Cell cell2;
                cellArr[cell2.getCol()] = cell2 = iterator.next();
            }
            this.twoDimCoord[rowIndex.intValue()] = cellArr;
        }
    }

    public Cell findCellByCoord(int row, int col) {
        if (!this.rows.contains(row) || !this.cols.contains(col)) {
            return null;
        }
        return this.twoDimCoord[row][col];
    }

    private void initRowsAndCols(List<Cell> cellList) {
        int maxRow = cellList.stream().filter(Objects::nonNull).map(Cell::getRow).max(Integer::compareTo).orElse(0);
        int maxCol = cellList.stream().filter(Objects::nonNull).map(Cell::getCol).max(Integer::compareTo).orElse(0);
        this.rows.addAll(Sheet.generateIntegerNumByScope(maxRow));
        this.cols.addAll(Sheet.generateIntegerNumByScope(maxCol));
    }

    public static List<Integer> generateIntegerNumByScope(Integer scope) {
        ArrayList<Integer> indexs = new ArrayList<Integer>(scope + 1);
        Integer num = 0;
        while (num <= scope) {
            indexs.add(num);
            Integer n = num;
            Integer n2 = num = Integer.valueOf(num + 1);
        }
        return indexs;
    }

    public List<Cell> getCellsByType(CellTypeEnum cellType) {
        if (this.cellMapByType == null || this.cellMapByType.size() == 0) {
            return new ArrayList<Cell>(0);
        }
        return this.cellMapByType.get((Object)cellType);
    }

    public Cell getTopCellInRange(int row, int col) {
        if (!this.cols.contains(col) || !this.rows.contains(row)) {
            return null;
        }
        Cell cellByCoord = this.findCellByCoord(row, col);
        if (cellByCoord == null) {
            List cells = this.rows.stream().filter(Objects::nonNull).map(o -> this.twoDimCoord[o][col]).filter(Objects::nonNull).collect(Collectors.toList());
            if ((cells = cells.stream().filter(Objects::nonNull).filter(o -> row >= o.getRow() && row <= o.getRow() + o.getRowSpan()).collect(Collectors.toList())) != null && cells.size() == 1) {
                cellByCoord = (Cell)cells.get(0);
            }
        }
        return cellByCoord;
    }

    public int getMaxRow() {
        return this.getRows().stream().max(Integer::compareTo).orElse(0);
    }

    public int getMaxCol() {
        return this.getCols().stream().max(Integer::compareTo).orElse(0);
    }
}

