/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.spread.widget.style;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;
import kd.tmc.fpm.spread.widget.style.HorizontalAlignEnum;
import kd.tmc.fpm.spread.widget.style.VerticalAlignEnum;

public class CellStyleInfo {
    private List<String> bls;
    private List<String> blc;
    private String bkc;
    private String frc;
    private String fm;
    private int va;
    private int ha;
    private Boolean l = null;
    private Boolean ww = null;
    private Boolean stf = null;
    private Integer ti;
    private String f;
    private Boolean ep = null;

    public List<String> getBls() {
        return this.bls;
    }

    public void setBls(List<String> bls) {
        this.bls = bls;
    }

    public List<String> getBlc() {
        return this.blc;
    }

    public void setBlc(List<String> blc) {
        this.blc = blc;
    }

    public String getBkc() {
        return this.bkc;
    }

    public void setBkc(String bkc) {
        this.bkc = bkc;
    }

    public String getFrc() {
        return this.frc;
    }

    public void setFrc(String frc) {
        this.frc = frc;
    }

    public String getFm() {
        return this.fm;
    }

    public void setFm(String fm) {
        this.fm = fm;
    }

    public int getVa() {
        return this.va;
    }

    public void setVa(VerticalAlignEnum va) {
        this.va = va.getIndex();
    }

    public int getHa() {
        return this.ha;
    }

    public void setHa(HorizontalAlignEnum ha) {
        this.ha = ha.getIndex();
    }

    public Boolean isL() {
        if (this.l == null) {
            return false;
        }
        return this.l;
    }

    public void setL(Boolean l) {
        this.l = l;
    }

    public Boolean isWw() {
        return this.ww;
    }

    public void setWw(Boolean ww) {
        this.ww = ww;
    }

    public Boolean isStf() {
        return this.stf;
    }

    public void setStf(Boolean stf) {
        this.stf = stf;
    }

    public Integer getTi() {
        return this.ti;
    }

    public void setTi(Integer ti) {
        this.ti = ti;
    }

    public String getF() {
        return this.f;
    }

    public void setF(String f) {
        this.f = f;
    }

    public Boolean getEp() {
        return this.ep;
    }

    public void setEp(Boolean ep) {
        this.ep = ep;
    }

    public CellStyleInfo clone() {
        String serialize = FpmSerializeUtil.serialize((Object)this);
        return (CellStyleInfo)FpmSerializeUtil.deserialize((String)serialize, CellStyleInfo.class);
    }

    public String getStyleUniqueKey() {
        ArrayList<String> flags = new ArrayList<String>(13);
        String blsStr = "nonbls";
        if (EmptyUtil.isNoEmpty(this.bls)) {
            blsStr = this.bls.stream().collect(Collectors.joining("_"));
        }
        flags.add(blsStr);
        String blcStr = "nonblc";
        if (EmptyUtil.isNoEmpty(this.blc)) {
            blcStr = this.blc.stream().collect(Collectors.joining("_"));
        }
        flags.add(blcStr);
        flags.add(Optional.ofNullable(this.bkc).map(o -> o).orElseGet(() -> "nonbkc"));
        flags.add(Optional.ofNullable(this.frc).map(o -> o).orElseGet(() -> "nonbkc"));
        flags.add(Optional.ofNullable(this.fm).map(o -> String.format("(%s)", this.fm)).orElseGet(() -> "nonfm"));
        flags.add(String.format("va%s", this.va));
        flags.add(String.format("ha%s", this.ha));
        flags.add(Optional.ofNullable(this.l).map(l -> l != false ? "lock" : "nonlock").orElseGet(() -> "nonlock"));
        flags.add(Optional.ofNullable(this.ww).map(ww -> ww != false ? "wrap" : "nonwrap").orElseGet(() -> "nonwrap"));
        flags.add(Optional.ofNullable(this.stf).map(stf -> stf != false ? "shrink" : "nonshrink").orElseGet(() -> "nonshrink"));
        flags.add(Optional.ofNullable(this.ti).map(ti -> ti.toString()).orElseGet(() -> "0"));
        flags.add(Optional.ofNullable(this.f).map(f -> f).orElseGet(() -> "nonfontformat"));
        flags.add(Optional.ofNullable(this.ep).map(ep -> ep != false ? "ep" : "nonep").orElseGet(() -> "nonep"));
        return flags.stream().collect(Collectors.joining("_"));
    }
}

