/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.opplugin.dimension;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.tmc.fpm.business.service.dimension.ICustomDimSeqService;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.common.enums.DimMemberFromEnum;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.helper.FpmGlobalConfigHelper;

public class DimSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("memberfrom");
        fieldKeys.add("basedata");
        fieldKeys.add("bodysystem");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                DynamicObject[] dimDyArray = (DynamicObject[])Arrays.stream(this.dataEntities).map(ExtendedDataEntity::getDataEntity).toArray(DynamicObject[]::new);
                Set waitUpdateDimIds = DimSaveOp.this.loadExistedDimIdSet(dimDyArray);
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject dim = dataEntity.getDataEntity();
                    String baseDataType = dim.getString("basedata");
                    if (DimsionEnums.CUSTOM.getNumber().equals(baseDataType)) {
                        DimMemberFromEnum dimMemberFromEnum = DimMemberFromEnum.valueOf((String)dim.getString("memberfrom"));
                        if (DimMemberFromEnum.CUSTOM != dimMemberFromEnum || waitUpdateDimIds.contains(dim.getPkValue())) continue;
                        String customNumber = dim.getString("number");
                        String prefix = customNumber.substring(0, 1);
                        if (!prefix.matches("[a-zA-Z]")) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7f16\u7801\u9996\u4f4d\u9700\u4e3a\u5b57\u6bcd\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"DimSaveOpValidator_2", (String)"tmc-fpm-opplugin", (Object[])new Object[0]));
                            break;
                        }
                        if (customNumber.length() > 10) {
                            dim.set("number", (Object)customNumber.substring(0, 10));
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u9650\u523610\u4f4d\u4ee5\u5185\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"DimSaveOpValidator_3", (String)"tmc-fpm-opplugin", (Object[])new Object[0]));
                            break;
                        }
                        QFilter[] qFilters = new QFilter[]{new QFilter("number", "=", (Object)customNumber), new QFilter("bodysystem", "=", (Object)Long.valueOf(dim.getDynamicObject("bodysystem").getPkValue().toString()))};
                        DynamicObjectCollection dims = QueryServiceHelper.query((String)"fpm_dimension", (String)"id", (QFilter[])qFilters);
                        if (CollectionUtils.isEmpty((Collection)dims)) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"DimSaveOpValidator_4", (String)"tmc-fpm-opplugin", (Object[])new Object[0]));
                        break;
                    }
                    QFilter[] tQFilter = new QFilter[]{new QFilter("basedata", "=", (Object)baseDataType), new QFilter("bodysystem", "=", (Object)Long.valueOf(dim.getDynamicObject("bodysystem").getPkValue().toString())), new QFilter("id", "!=", dim.getPkValue())};
                    DynamicObjectCollection dims = QueryServiceHelper.query((String)"fpm_dimension", (String)"id,name,number", (QFilter[])tQFilter);
                    if (dims == null || dims.size() <= 0) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5df2\u4f5c\u4e3a\u4f53\u7cfb\u5185\u7684\u53ef\u9009\u7ef4\u5ea6\uff0c\u4e0d\u53ef\u518d\u6b21\u9009\u62e9\u4f5c\u4e3a\u65b0\u589e\u7ef4\u5ea6\u3002", (String)"DimSaveOpValidator_1", (String)"tmc-fpm-opplugin", (Object[])new Object[0]));
                    break;
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        Set<Long> waitUpdateDimIds = this.loadExistedDimIdSet(e.getDataEntities());
        for (DynamicObject dim : e.getDataEntities()) {
            this.addCustomDimSeqIfNeed(dim, !waitUpdateDimIds.contains(dim.getPkValue()));
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        if (FpmGlobalConfigHelper.getBooleanConfigByKey((String)"startmutilsync")) {
            OperationServiceHelper.executeOperate((String)"syncdim_mdd", (String)"fpm_dimension", (DynamicObject[])e.getDataEntities(), (OperateOption)OperateOption.create());
        }
    }

    private void addCustomDimSeqIfNeed(DynamicObject dim, boolean isAddDim) {
        String baseDataType = dim.getString("basedata");
        if (!Objects.equals(DimsionEnums.CUSTOM.getNumber(), baseDataType) || !isAddDim) {
            return;
        }
        ICustomDimSeqService iCustomDimSeqService = (ICustomDimSeqService)FpmServiceFactory.getBizService(ICustomDimSeqService.class);
        Long bodySystemId = (Long)dim.getDynamicObject("bodysystem").getPkValue();
        Long dimId = dim.getLong("id");
        iCustomDimSeqService.addCustomDimSeq(dimId, bodySystemId);
    }

    private Set<Long> loadExistedDimIdSet(DynamicObject[] dimDy) {
        List dimIds = Arrays.stream(dimDy).map(DataEntityBase::getPkValue).map(pk -> (Long)pk).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", dimIds);
        DynamicObjectCollection existedDimDyColl = QueryServiceHelper.query((String)"fpm_dimension", (String)"id", (QFilter[])qFilter.toArray());
        return existedDimDyColl.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
    }
}

